# - Try to find the OpenSSL encryption library
# Once done this will define
#
#  OPENSSL_FOUND - system has the OpenSSL library
#  OPENSSL_INCLUDE_DIR - the OpenSSL include directory
#  OPENSSL_LIBRARIES - The libraries needed to use OpenSSL
#  OPENSSL_EAY_LIBRARIES - The additional libraries needed to use OpenSSL on windows

# Copyright (c) 2006, Alexander Neundorf, <neundorf@kde.org>
#
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.

INCLUDE(FindLibraryWithDebug)

# on win32 we additional need to link to libeay32.lib
MACRO(OPENSSL_ADD_LIB_EAY_LIBS)
   FIND_LIBRARY_WITH_DEBUG(OPENSSL_EAY_LIBRARIES
                   WIN32_DEBUG_POSTFIX d
                   NAMES eay libeay libeay32 libeay32MT)
ENDMACRO(OPENSSL_ADD_LIB_EAY_LIBS)

IF(OPENSSL_LIBRARIES)
   SET(OpenSSL_FIND_QUIETLY TRUE)
ENDIF(OPENSSL_LIBRARIES)

IF(SSL_EAY_DEBUG AND SSL_EAY_RELEASE)
   SET(LIB_FOUND 1)
ENDIF(SSL_EAY_DEBUG AND SSL_EAY_RELEASE)

FIND_PATH(OPENSSL_INCLUDE_DIR openssl/ssl.h )

FIND_LIBRARY_WITH_DEBUG(OPENSSL_LIBRARIES
                WIN32_DEBUG_POSTFIX d
                NAMES ssl ssleay ssleay32 libssleay32 ssleay32MT)

IF(WIN32)
   OPENSSL_ADD_LIB_EAY_LIBS()
   IF(OPENSSL_INCLUDE_DIR AND OPENSSL_LIBRARIES AND OPENSSL_EAY_LIBRARIES)
      SET(OPENSSL_FOUND TRUE)
   ELSE(OPENSSL_INCLUDE_DIR AND OPENSSL_LIBRARIES AND OPENSSL_EAY_LIBRARIES)
      SET(OPENSSL_FOUND FALSE)
   ENDIF (OPENSSL_INCLUDE_DIR AND OPENSSL_LIBRARIES AND OPENSSL_EAY_LIBRARIES)
ELSE(WIN32)
   IF(OPENSSL_INCLUDE_DIR AND OPENSSL_LIBRARIES)
      SET(OPENSSL_FOUND TRUE)
   ELSE(OPENSSL_INCLUDE_DIR AND OPENSSL_LIBRARIES)
      SET(OPENSSL_FOUND FALSE)
   ENDIF (OPENSSL_INCLUDE_DIR AND OPENSSL_LIBRARIES)
ENDIF(WIN32)

IF (OPENSSL_FOUND)
   IF (NOT OpenSSL_FIND_QUIETLY)
      MESSAGE(STATUS "Found OpenSSL: ${OPENSSL_LIBRARIES}")
   ENDIF (NOT OpenSSL_FIND_QUIETLY)
ELSE (OPENSSL_FOUND)
   IF (OpenSSL_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR "Could NOT find OpenSSL")
   ENDIF (OpenSSL_FIND_REQUIRED)
ENDIF (OPENSSL_FOUND)

MARK_AS_ADVANCED(OPENSSL_INCLUDE_DIR OPENSSL_LIBRARIES)

