// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/component_updater/component_updater_utils.h"

#include "base/files/file_path.h"
#include "base/path_service.h"
#include "build/build_config.h"
#if defined(OS_WIN)
#include "chrome/installer/util/install_util.h"
#endif  // OS_WIN

namespace component_updater {

bool IsPerUserInstall() {
#if defined(OS_WIN)
  base::FilePath exe_path;
  PathService::Get(base::FILE_EXE, &exe_path);
  return InstallUtil::IsPerUserInstall(exe_path);
#else
  return true;
#endif
}

}  // namespace component_updater
