/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.devtools.jsdoc.checks;

import com.google.javascript.rhino.head.ast.AstNode;
import com.google.javascript.rhino.head.ast.Comment;
import com.google.javascript.rhino.head.ast.FunctionNode;
import com.google.javascript.rhino.head.ast.Name;
import com.google.javascript.rhino.head.ast.ObjectProperty;
import com.google.javascript.rhino.head.ast.ReturnStatement;
import java.util.HashSet;
import java.util.Set;
import org.chromium.devtools.jsdoc.checks.AstUtil;
import org.chromium.devtools.jsdoc.checks.ContextTrackingChecker;
import org.chromium.devtools.jsdoc.checks.FunctionRecord;

public final class ReturnAnnotationChecker
extends ContextTrackingChecker {
    private final Set<FunctionRecord> valueReturningFunctions = new HashSet<FunctionRecord>();
    private final Set<FunctionRecord> throwingFunctions = new HashSet<FunctionRecord>();

    @Override
    public void enterNode(AstNode astNode) {
        switch (astNode.getType()) {
            case 4: {
                this.handleReturn((ReturnStatement)astNode);
                break;
            }
            case 50: {
                this.handleThrow();
                break;
            }
        }
    }

    private void handleReturn(ReturnStatement returnStatement) {
        if (returnStatement.getReturnValue() == null || AstUtil.parentOfType(returnStatement, 90) != null) {
            return;
        }
        FunctionRecord functionRecord = this.getState().getCurrentFunctionRecord();
        if (functionRecord == null) {
            return;
        }
        AstNode astNode = ReturnAnnotationChecker.getFunctionNameNode(functionRecord.functionNode);
        if (astNode == null) {
            return;
        }
        this.valueReturningFunctions.add(functionRecord);
    }

    private void handleThrow() {
        FunctionRecord functionRecord = this.getState().getCurrentFunctionRecord();
        if (functionRecord == null) {
            return;
        }
        AstNode astNode = ReturnAnnotationChecker.getFunctionNameNode(functionRecord.functionNode);
        if (astNode == null) {
            return;
        }
        this.throwingFunctions.add(functionRecord);
    }

    @Override
    public void leaveNode(AstNode astNode) {
        if (astNode.getType() != 109) {
            return;
        }
        FunctionRecord functionRecord = this.getState().getCurrentFunctionRecord();
        if (functionRecord != null) {
            this.checkFunctionAnnotation(functionRecord);
        }
    }

    private void checkFunctionAnnotation(FunctionRecord functionRecord) {
        String string = this.getFunctionName(functionRecord.functionNode);
        if (string == null) {
            return;
        }
        boolean bl = !string.startsWith("_") && (functionRecord.isTopLevelFunction() || functionRecord.enclosingType != null && ReturnAnnotationChecker.isPlainTopLevelFunction(functionRecord.enclosingFunctionRecord));
        Comment comment = AstUtil.getJsDocNode(functionRecord.functionNode);
        boolean bl2 = this.valueReturningFunctions.contains(functionRecord);
        boolean bl3 = functionRecord.enclosingType != null && functionRecord.enclosingType.isInterface;
        int n = ReturnAnnotationChecker.invalidReturnsAnnotationIndex(this.getState().getNodeText(comment));
        if (n != -1) {
            String string2 = bl2 || bl3 ? "should be @return instead" : "please remove, as function does not return value";
            this.getContext().reportErrorInNode(comment, n, String.format("invalid @returns annotation found - %s", string2));
            return;
        }
        AstNode astNode = ReturnAnnotationChecker.getFunctionNameNode(functionRecord.functionNode);
        if (astNode == null) {
            return;
        }
        if (bl2) {
            if (!functionRecord.hasReturnAnnotation() && bl) {
                this.reportErrorAtNodeStart(astNode, "@return annotation is required for API functions that return value");
            }
        } else if (functionRecord.hasReturnAnnotation() && !bl3 && !this.throwingFunctions.contains(functionRecord)) {
            this.reportErrorAtNodeStart(astNode, "@return annotation found, yet function does not return value");
        }
    }

    private static boolean isPlainTopLevelFunction(FunctionRecord functionRecord) {
        return functionRecord != null && functionRecord.isTopLevelFunction() && functionRecord.enclosingType == null && !functionRecord.isConstructor;
    }

    private String getFunctionName(FunctionNode functionNode) {
        AstNode astNode = ReturnAnnotationChecker.getFunctionNameNode(functionNode);
        return astNode == null ? null : this.getState().getNodeText(astNode);
    }

    private static int invalidReturnsAnnotationIndex(String string) {
        return string == null ? -1 : string.indexOf("@returns");
    }

    private static AstNode getFunctionNameNode(FunctionNode functionNode) {
        Name name = functionNode.getFunctionName();
        if (name != null) {
            return name;
        }
        ObjectProperty objectProperty = (ObjectProperty)AstUtil.parentOfType(functionNode, 103);
        if (objectProperty != null) {
            return objectProperty.getLeft();
        }
        return null;
    }
}

