/* Copyright (C) 2001, 2007 United States Government as represented by
   the Administrator of the National Aeronautics and Space Administration.
   All Rights Reserved.
*/
package gov.nasa.worldwind.servers.wms;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

/**
 *
 * @author brownrigg
 * @version $Id: SimpleMapRegistry.java 4675 2008-03-12 19:36:36Z rick $
 */
public class SimpleMapRegistry implements MapRegistry {
    
    public SimpleMapRegistry() {
    }

    public MapSource getNamedMapSource(String name) {
        return namedMapSources.get(name);
    }

    public boolean doesNamedMapSourceExist(String name) {
        return (namedMapSources.get(name) == null) ? false : true;
    }

    public void addMapSource(MapSource mapSource) {
        mapSources.add(mapSource);
    }

    public void addNamedMapSource(MapSource mapSource) {
        namedMapSources.put(mapSource.getFullName(), mapSource);
    }

    public Iterator<MapSource> getAllMapSources()
    {
        return mapSources.iterator();
    }

    public Iterator<String> getMapNames() {
        return namedMapSources.keySet().iterator();
    }
    
    private Vector<MapSource> mapSources = new Vector<MapSource>(10);
    private HashMap<String, MapSource> namedMapSources = new HashMap<String, MapSource>();
}
