/* Copyright (C) 2001, 2007 United States Government as represented by
   the Administrator of the National Aeronautics and Space Administration.
   All Rights Reserved.
 */
package gov.nasa.worldwind.servers.wms;

/**
 *
 * @author brownrigg
 * @version $Id$
 */

public class HttpUtil {

    /**
     * Decodes escape sequences in the query string.  NOTE that although there is a 
     * class java.net.URLDecoder that can do this, it appears to adhere to strict 
     * rules about what are legal characters in a URL. Evidently our clients may not
     * always generate such URLs -- in particular a WMS request might specify a 
     * format as "image/png" rather than the properly escaped "image%2Fpng".
     * URLDecode will throw an exception in such a case;  we loosen the restrictions here.
     */
    private static char[] hexChars = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
        'a', 'b', 'c', 'd', 'e', 'f'};
    
    public static String decodeEscapes(String url) {
        char[] hexStr = new char[3];  // need these two bookkeeping arrays below
        byte[] b = new byte[1];
        
        StringBuilder str = new StringBuilder(url);
        int i=-1;
        while (++i < str.length()) {
            hexStr[0] = str.charAt(i);
            if (hexStr[0] == '%') {
                if ((i+2) >= str.length()) continue;
                hexStr[1] = Character.toLowerCase(str.charAt(i+1));
                hexStr[2] = Character.toLowerCase(str.charAt(i+2));
                int hiVal = -1;  int loVal = -1;
                for (int j=0; j<hexChars.length && (hiVal == -1 || loVal == -1); j++) {
                    if (hexStr[1] == hexChars[j]) hiVal = j;
                    if (hexStr[2] == hexChars[j]) loVal = j;
                }
                if (hiVal != -1 && loVal != -1) {
                    hexStr[0] = '#';  // replace % by # for proper Java hex notation...
                    b[0] = Byte.decode(new String(hexStr));
                    str.replace(i, i+3, new String(b));
                }
            }
        }
        
        return str.toString();
    }
        
    private HttpUtil() {
    }
    
}
