#!/bin/bash
#
# This is the configuration file for the example WRR setup. Please take your
# time to study it carefully. Currently it contains the setup for my site -
# so most of the values will not be usefull to you.
#
#  Note:
#
#    Lan side = where you local machines are = incomming traffic = IN direction
#    Wan side = where you wan link is        = outgoing traffic  = OUT direction
#
#-------------------------------------------------------------------------------------
# Basic setup
#
# Name of network interfaces:
DEV_IN=eth0
DEV_OUT=eth1

# This defines how much bandwidth should be restricted to in Kbit/s for the 
# incoming and outgoing traffic. Refer to the file intro.txt for detailed
# information about setting these parameters.
#
# When the system is running you can execute the script manual-update-speed.sh
# to update the values used to the ones specified here:
#BW_IN=1650 (I used this for htb)
BW_IN=1450
BW_OUT=400  

# The IP addresses of this machine should be specified here.
# The machine should always have an address on the LAN side.
# You do not need to specify a WAN address.
ADDR_IN=10.10.10.5
ADDR_OUT=

# If this machine is masqgrading for local machine this should be 
# set to "y", else "n"
MASQGRADING=y

# MAC address of the default gateway used by local machines. That is, the MAC 
# address of DEV_IN if this machine is masqgrading or routing and MAC addresse 
# of the router if this machine is bridgeing:
GATEWAY_MAC=00:00:B4:A1:2C:B7 # My other machine: 00:60:97:BE:AE:14

# Maximal number of local machines we will ever see. Don't set this too low
# unless you have very sparse memory. Setting it two high might prevent
# the wrr qdisc from beeing created, though. I have tried 1024 sucess
# but 2048 without.
MAXCLASSES=512

# If non-zero proxy remapping is enabled and the number should be the
# maximal number of concurrent connections (it might not work with
# too high values - I have tried 2048 with success)
PROXY_MAXCON=0

# If this is set to "y" the HTB qdisc is used instead of CBQ.
# HTB is a qdisc like WRR which requires a special patch to the kernel 
# and to the iproute2 like WRR does. You will probably get more
# accurate results if you use HTB:
USE_HTB=n

#-------------------------------------------------------------------------------------
# Files and directories:

# Programs:
PRG_TC=/usr/local/sbin/tc
PRG_WIPLCEXEC=/usr/local/bin/wiplcExec
PRG_WIPLD=/usr/local/sbin/wipld
PRG_WIPLC=/usr/local/bin/wiplc

# Directory where statistics are be saved:
WIPL_STAT_DIR=/var/www/wipl/

# These are all automatically created:
WIPLD_PIDFILE_LAN="/var/run/wipld-lan.pid"
WIPLD_CONF_LAN="/etc/wrr/wipl/wipld-lan.conf"
WIPLD_LOG_LAN="/var/log/wipld-wrr-lan.log"

#------------------------------------------------------------------------------
# Penalty=priority setup.
#
# NOTE: In order to not have any penalty simply set
#         WEIGHT1_MODE_OUT=0
#         WEIGHT1_MODE_IN=0
#       below.
#
# A formula for setting useful values is given in the wrr.txt document.

WEIGHT1_WIPL_DIV_IN=1000000    # The priorities displayed by wipl are divided by this number
WEIGHT1_MODE_IN=3
WEIGHT1_INCR_IN=0.000111111111
WEIGHT1_DECR_IN=0.000000000636
WEIGHT1_MIN_IN=0.2
WEIGHT1_MAX_IN=1.0
WEIGHT1_VAL_IN=1.0

WEIGHT1_WIPL_DIV_OUT=1000000  
WEIGHT1_MODE_OUT=3
WEIGHT1_INCR_OUT=0.000111111111
WEIGHT1_DECR_OUT=0.000000002543
WEIGHT1_MIN_OUT=0.2
WEIGHT1_MAX_OUT=1.0
WEIGHT1_VAL_OUT=1.0

WEIGHT2_WIPL_DIV_IN=100000
WEIGHT2_MODE_IN=0
WEIGHT2_INCR_IN=0.0
WEIGHT2_DECR_IN=0.0
WEIGHT2_MIN_IN=0.01
WEIGHT2_MODE_IN=0
WEIGHT2_MAX_IN=1.0
WEIGHT2_VAL_IN=0.1

WEIGHT2_WIPL_DIV_OUT=100000
WEIGHT2_MODE_OUT=0
WEIGHT2_INCR_OUT=0.0
WEIGHT2_DECR_OUT=0.0
WEIGHT2_MIN_OUT=0.01
WEIGHT2_MAX_OUT=1.0
WEIGHT2_VAL_OUT=0.1
