/* normalmode_chmod.cc
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2011 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "normalmode.h"
#include "worker_locale.h"
#include "fileentry.hh"
#include "nmcopyopdir.hh"
#include "nmfieldlistviewdnd.hh"
#include "verzeichnis.hh"
#include <aguix/choosebutton.h>
#include <aguix/button.h>
#include <aguix/cyclebutton.h>

void NormalMode::chmodf( struct NM_chmodorder *cmorder )
{
    NM_specialsourceInt *ss1;
    changemod_info_t *cminfo;
    std::list<NM_specialsourceInt*> *cmlist;
    std::list<NM_specialsourceInt*>::iterator iti1;
   
    if(cmorder==NULL) return;
    if ( getCurrentDir() == NULL ) {
        // no current dir => no files to copy
        return;
    }

    finishsearchmode();
  
    cmlist = new std::list<NM_specialsourceInt*>;
    switch(cmorder->source) {
        case NM_chmodorder::NM_SPECIAL:
            buildSpecialSourceIntList( *( cmorder->sources ),
                                       *cmlist );
            break;
        case NM_chmodorder::NM_ONLYACTIVE:
            getSelFiles( cmlist, NM_GETFILES_ONLYACTIVE, false );
            break;
        default:  // all selected entries
            getSelFiles( cmlist, NM_GETFILES_SELORACT, false );
            break;
    }

    cminfo = new changemod_info_t;

    for ( iti1 = cmlist->begin(); iti1 != cmlist->end(); iti1++ ) {
        ss1 = *iti1;
        if ( worker_changemod( ss1, cminfo, cmorder ) != 0 ) {
            break;
        }
    }
    for ( iti1 = cmlist->begin(); iti1 != cmlist->end(); iti1++ ) {
        ss1 = *iti1;
        delete ss1;
    }
    delete cminfo;
    delete cmlist;
    update(false);
}

int NormalMode::worker_changemod( const struct NM_specialsourceInt *ss1,
                                  changemod_info_t *cminfo,
                                  const NM_chmodorder *cmorder )
{
    bool enter, dontChange, skip, cancel, changemodFirst;
    int erg;
    changemod_info_t newmode;
    FileEntry *subfe;
    NM_specialsourceInt *ss2;
    NM_CopyOp_Dir *cod;
  
    if ( ( ss1 == NULL ) || ( cminfo == NULL ) || ( cmorder == NULL ) ) return -1;

    newmode.mode = 0700; //default
    newmode.op = changemod_info::CHMOD_SET;

    // do we have to enter this entry?
    enter = false;
    if ( ( ss1->entry()->isDir() == true ) && ( cmorder->recursive == true ) ) {
        if ( ss1->entry()->isLink == false ) enter = true;
    }
  
    // check operation applies to this entry
    dontChange = false;
    if ( ( ss1->entry()->isDir() == true ) && ( cmorder->ondirs == false ) ) dontChange = true;
    else if ( ( ss1->entry()->isDir() == false ) && ( cmorder->onfiles == false ) ) dontChange = true;

    /* skip means skip entry AND all sub entries
     * cancel is clear
     * dontchange means to normally handle this entry
     *   but actually don't change mod
     */
    skip = cancel = false;
    if ( dontChange == false ) {
        // ask for new mode
        if ( cminfo->forAll == true ) {
            newmode = *cminfo;
        } else {
            erg = requestNewMode( ss1->entry(), &newmode );
            if ( erg == 1 ) {
                *cminfo = newmode;
                cminfo->forAll = true;
            } else if ( erg == 2 ) {
                skip = true;
            } else if ( erg == 3 ) {
                cancel = true;
            }
        }
    }
    if ( skip == true ) return 0;
    if ( cancel == true ) return 1;

    if ( ss1->entry()->checkAccess( R_OK|W_OK|X_OK ) != true ) {
        // cannot access directory to change mod so apply
        // newmode first
        changemodFirst = true;
    } else {
        changemodFirst = false;
    }
    if ( ( dontChange == false ) && ( changemodFirst == true ) ) {
        if ( applyNewMode( ss1, newmode ) != 0 ) cancel = true;
    }
    if ( ( enter == true ) && ( cancel == false ) ) {
        cod = new NM_CopyOp_Dir( ss1->entry() );
        if ( cod->user_abort == true ) {
            cancel = true;
        } else if ( cod->ok == true ) {
            for ( Verzeichnis::verz_it subfe_it1 = cod->verz->begin();
                  subfe_it1 != cod->verz->end() && cancel == false;
                  subfe_it1++ ) {
                subfe = *subfe_it1;
                if ( strcmp( subfe->name, ".." ) != 0 ) {
                    ss2 = new NM_specialsourceInt( subfe );
                    ss2->row = -1;
                    if ( worker_changemod( ss2, cminfo, cmorder ) != 0 ) {
                        cancel = true;
                    }
                    delete ss2;
                }
            }
        }
        delete cod;
    }
    if ( ( dontChange == false ) && ( changemodFirst == false ) ) {
        if ( applyNewMode( ss1, newmode ) != 0 ) cancel = true;
    }
    return ( cancel == true ) ? 1 : 0;
}

int NormalMode::applyNewMode( const NM_specialsourceInt *ss1, changemod_info_t newmode )
{
    char *textstr, *buttonstr;
    int erg;
    bool cancel = false;
  
    if ( ss1 == NULL ) return -1;

    mode_t apply_mode = ( ss1->entry()->isLink == true &&
                          ss1->entry()->isCorrupt == false ) ? ss1->entry()->dmode() : ss1->entry()->mode();
    if ( newmode.op == changemod_info::CHMOD_SET ) {
        apply_mode = newmode.mode;
    } else if ( newmode.op == changemod_info::CHMOD_ADD ) {
        apply_mode |= newmode.mode;
    } else if ( newmode.op == changemod_info::CHMOD_REM ) {
        apply_mode &= ~newmode.mode;
    } else {
        return -1;
    }

    if ( worker_chmod( ss1->entry()->fullname, apply_mode ) != 0 ) {
        // error
        buttonstr = (char*)_allocsafe( strlen( catalog.getLocale( 11 ) ) + 1 +
                                       strlen( catalog.getLocale( 8 ) ) + 1 );
        sprintf( buttonstr, "%s|%s", catalog.getLocale( 11 ),
                 catalog.getLocale( 8 ) );
        textstr = (char*)_allocsafe( strlen( catalog.getLocale( 226 ) ) + strlen( ss1->entry()->fullname ) + 1 );
        sprintf( textstr, catalog.getLocale( 226 ), ss1->entry()->fullname );
        erg = request( catalog.getLocale( 347 ), textstr, buttonstr );
        _freesafe( buttonstr );
        _freesafe( textstr );
        if ( erg == 1 ) cancel = true;
    } else {
        if ( lv->isValidRow( ss1->row ) == true ) deselect( ss1->entry(), ss1->row );
    }
    return ( cancel == true ) ? 1 : 0;
}

static void setChooseButtonMatrixForMode( ChooseButton **mcb, mode_t mode )
{
    mcb[0]->setState( ( ( mode & S_IRUSR ) == 0 ) ? false : true );
    mcb[1]->setState( ( ( mode & S_IWUSR ) == 0 ) ? false : true );
    mcb[2]->setState( ( ( mode & S_IXUSR ) == 0 ) ? false : true );
    mcb[3]->setState( ( ( mode & S_IRGRP ) == 0 ) ? false : true );
    mcb[4]->setState( ( ( mode & S_IWGRP ) == 0 ) ? false : true );
    mcb[5]->setState( ( ( mode & S_IXGRP ) == 0 ) ? false : true );
    mcb[6]->setState( ( ( mode & S_IROTH ) == 0 ) ? false : true );
    mcb[7]->setState( ( ( mode & S_IWOTH ) == 0 ) ? false : true );
    mcb[8]->setState( ( ( mode & S_IXOTH ) == 0 ) ? false : true );
    mcb[9]->setState( ( ( mode & S_ISUID ) == 0 ) ? false : true );
    mcb[10]->setState( ( ( mode & S_ISGID ) == 0 ) ? false : true );
    mcb[11]->setState( ( ( mode & S_ISVTX ) == 0 ) ? false : true );
}

int NormalMode::requestNewMode( FileEntry *fe, changemod_info_t *return_mode )
{
    mode_t tmode, newmode;
    AWindow *win;
    ChooseButton *mcb[12];
    AGMessage *msg;
    int endmode = -1;
    char *tstr;
    
    tmode = ( ( fe->isLink == true ) && ( fe->isCorrupt == false ) ) ? fe->dmode() : fe->mode();
    win = new AWindow( aguix, 10, 10, 10, 10, 0, catalog.getLocaleCom( 38 ) );
    win->create();
    
    AContainer *ac1 = win->setContainer( new AContainer( win, 1, 4 ), true );
    ac1->setMinSpace( 5 );
    ac1->setMaxSpace( 5 );
    
    tstr=(char*)_allocsafe(strlen(catalog.getLocale(213))+strlen(fe->fullname)+1);
    sprintf(tstr,catalog.getLocale(213),fe->fullname);
    
    ac1->add( new Text( aguix, 0, 0, tstr, 1 ), 0, 0, AContainer::CO_INCWNR );
    _freesafe(tstr);
    
    AContainer *ac1_1 = ac1->add( new AContainer( win, 2, 1 ), 0, 1 );
    ac1_1->setMinSpace( 5 );
    ac1_1->setMaxSpace( 5 );

    ac1_1->add( new Text( aguix, 0, 0, catalog.getLocale( 780 ), 1 ), 0, 0, AContainer::CO_FIX );
    CycleButton *apply_mode_cb = static_cast<CycleButton*>( ac1_1->add( new CycleButton( aguix,
                                                                                         0, 0,
                                                                                         10,
                                                                                         1, 0, 0 ),
                                                                        1, 0, AContainer::CO_FIX ) );
    apply_mode_cb->addOption( catalog.getLocale( 781 ) );
    apply_mode_cb->addOption( catalog.getLocale( 782 ) );
    apply_mode_cb->addOption( catalog.getLocale( 783 ) );
    apply_mode_cb->setOption( 0 );
    apply_mode_cb->resize( apply_mode_cb->getMaxSize(), apply_mode_cb->getHeight() );
    ac1_1->readLimits();
    
    AContainer *ac1_2 = ac1->add( new AContainer( win, 4, 6 ), 0, 2 );
    ac1_2->setMinSpace( 5 );
    ac1_2->setMaxSpace( 5 );
    
    ac1_2->add( new Text( aguix, 0, 0, catalog.getLocale( 218 ), 1 ), 1, 0, AContainer::CO_FIXNR + AContainer::ACONT_CENTER );
    ac1_2->add( new Text( aguix, 0, 0, catalog.getLocale( 219 ), 1 ), 2, 0, AContainer::CO_FIXNR + AContainer::ACONT_CENTER );
    ac1_2->add( new Text( aguix, 0, 0, catalog.getLocale( 220 ), 1 ), 3, 0, AContainer::CO_FIXNR + AContainer::ACONT_CENTER );
    
    ac1_2->add( new Text( aguix, 0, 0, catalog.getLocale( 214 ), 1 ), 0, 1, AContainer::CO_FIX );
    ac1_2->add( new Text( aguix, 0, 0, catalog.getLocale( 215 ), 1 ), 0, 2, AContainer::CO_FIX );
    ac1_2->add( new Text( aguix, 0, 0, catalog.getLocale( 216 ), 1 ), 0, 3, AContainer::CO_FIX );
    ac1_2->add( new Text( aguix, 0, 0, catalog.getLocale( 217 ), 1 ), 0, 5, AContainer::CO_FIX );
    
    ac1_2->add( new Text( aguix, 0, 0, catalog.getLocale( 221 ), 1 ), 1, 4, AContainer::CO_FIXNR + AContainer::ACONT_CENTER );
    ac1_2->add( new Text( aguix, 0, 0, catalog.getLocale( 222 ), 1 ), 2, 4, AContainer::CO_FIXNR + AContainer::ACONT_CENTER );
    ac1_2->add( new Text( aguix, 0, 0, catalog.getLocale( 223 ), 1 ), 3, 4, AContainer::CO_FIXNR + AContainer::ACONT_CENTER );
    
    mcb[0] = (ChooseButton*)ac1_2->add( new ChooseButton( aguix, 0, 0,
                                                          ( ( tmode & S_IRUSR ) == 0 ) ? 0 : 1,
                                                          "", LABEL_RIGHT, 0, 0 ), 1, 1, AContainer::CO_FIXNR + AContainer::ACONT_CENTER );
    mcb[1] = (ChooseButton*)ac1_2->add( new ChooseButton( aguix, 0, 0,
                                                          ( ( tmode & S_IWUSR ) == 0 ) ? 0 : 1,
                                                          "", LABEL_RIGHT, 0, 0 ), 2, 1, AContainer::CO_FIXNR + AContainer::ACONT_CENTER );
    mcb[2] = (ChooseButton*)ac1_2->add( new ChooseButton( aguix, 0, 0,
                                                          ( ( tmode & S_IXUSR ) == 0 ) ? 0 : 1,
                                                          "", LABEL_RIGHT, 0, 0 ), 3, 1, AContainer::CO_FIXNR + AContainer::ACONT_CENTER );
    mcb[3] = (ChooseButton*)ac1_2->add( new ChooseButton( aguix, 0, 0,
                                                          ( ( tmode & S_IRGRP ) == 0 ) ? 0 : 1,
                                                          "", LABEL_RIGHT, 0, 0 ), 1, 2, AContainer::CO_FIXNR + AContainer::ACONT_CENTER );
    mcb[4] = (ChooseButton*)ac1_2->add( new ChooseButton( aguix, 0, 0,
                                                          ( ( tmode & S_IWGRP ) == 0 ) ? 0 : 1,
                                                          "", LABEL_RIGHT, 0, 0 ), 2, 2, AContainer::CO_FIXNR + AContainer::ACONT_CENTER );
    mcb[5] = (ChooseButton*)ac1_2->add( new ChooseButton( aguix, 0, 0,
                                                          ( ( tmode & S_IXGRP ) == 0 ) ? 0 : 1,
                                                          "", LABEL_RIGHT, 0, 0 ), 3, 2, AContainer::CO_FIXNR + AContainer::ACONT_CENTER );
    mcb[6] = (ChooseButton*)ac1_2->add( new ChooseButton( aguix, 0, 0,
                                                          ( ( tmode & S_IROTH ) == 0 ) ? 0 : 1,
                                                          "", LABEL_RIGHT, 0, 0 ), 1, 3, AContainer::CO_FIXNR + AContainer::ACONT_CENTER );
    mcb[7] = (ChooseButton*)ac1_2->add( new ChooseButton( aguix, 0, 0,
                                                          ( ( tmode & S_IWOTH ) == 0 ) ? 0 : 1,
                                                          "", LABEL_RIGHT, 0, 0 ), 2, 3, AContainer::CO_FIXNR + AContainer::ACONT_CENTER );
    mcb[8] = (ChooseButton*)ac1_2->add( new ChooseButton( aguix, 0, 0,
                                                          ( ( tmode & S_IXOTH ) == 0 ) ? 0 : 1,
                                                          "", LABEL_RIGHT, 0, 0 ), 3, 3, AContainer::CO_FIXNR + AContainer::ACONT_CENTER );
    mcb[9] = (ChooseButton*)ac1_2->add( new ChooseButton( aguix, 0, 0,
                                                          ( ( tmode & S_ISUID ) == 0 ) ? 0 : 1,
                                                          "", LABEL_RIGHT, 0, 0 ), 1, 5, AContainer::CO_FIXNR + AContainer::ACONT_CENTER );
    mcb[10] = (ChooseButton*)ac1_2->add( new ChooseButton( aguix, 0, 0,
                                                           ( ( tmode & S_ISGID ) == 0 ) ? 0 : 1,
                                                           "", LABEL_RIGHT, 0, 0 ), 2, 5, AContainer::CO_FIXNR + AContainer::ACONT_CENTER );
    mcb[11] = (ChooseButton*)ac1_2->add( new ChooseButton( aguix, 0, 0,
                                                           ( ( tmode & S_ISVTX ) == 0 ) ? 0 : 1,
                                                           "", LABEL_RIGHT, 0, 0 ), 3, 5, AContainer::CO_FIXNR + AContainer::ACONT_CENTER );
    setChooseButtonMatrixForMode( mcb, tmode );
    
    AContainer *ac1_3 = ac1->add( new AContainer( win, 4, 1 ), 0, 3 );
    ac1_3->setMinSpace( 5 );
    ac1_3->setMaxSpace( -1 );
    ac1_3->setBorderWidth( 0 );
    Button *okb =(Button*)ac1_3->add( new Button( aguix,
                                                  0,
                                                  0,
                                                  catalog.getLocale( 11 ),
                                                  1,
                                                  0,
                                                  0 ), 0, 0, AContainer::CO_FIX );
    Button *ok2allb = (Button*)ac1_3->add( new Button( aguix,
                                                       0,
                                                       0,
                                                       catalog.getLocale( 224 ),
                                                       1,
                                                       0,
                                                       0 ), 1, 0, AContainer::CO_FIX );
    Button *skipb = (Button*)ac1_3->add( new Button( aguix,
                                                     0,
                                                     0,
                                                     catalog.getLocale( 225 ),
                                                     1,
                                                     0,
                                                     0 ), 2, 0, AContainer::CO_FIX );
    Button *cb = (Button*)ac1_3->add( new Button( aguix,
                                                  0,
                                                  0,
                                                  catalog.getLocale( 8 ),
                                                  1,
                                                  0,
                                                  0 ), 3, 0, AContainer::CO_FIX );
    win->setDoTabCycling( true );
    win->contMaximize( true, true );
    win->show();
  
    for( ; endmode == -1; ) {
        msg = aguix->WaitMessage( win );
        if ( msg != NULL ) {
            switch ( msg->type ) {
                case AG_CLOSEWINDOW:
                    if ( msg->closewindow.window == win->getWindow() ) endmode = 3;
                    break;
                case AG_BUTTONCLICKED:
                    if ( msg->button.button == okb ) endmode = 0;
                    else if ( msg->button.button == ok2allb ) endmode = 1;
                    else if ( msg->button.button == skipb ) endmode = 2;
                    else if ( msg->button.button == cb ) endmode = 3;
                    break;
                case AG_KEYPRESSED:
                    if ( win->isParent( msg->key.window, false ) == true ) {
                        switch ( msg->key.key ) {
                            case XK_1:
                            case XK_KP_1:
                            case XK_KP_End:
                                mcb[6]->setState( ( mcb[6]->getState() == true ) ? false : true );
                                break;
                            case XK_2:
                            case XK_KP_2:
                            case XK_KP_Down:
                                mcb[7]->setState( ( mcb[7]->getState() == true ) ? false : true );
                                break;
                            case XK_3:
                            case XK_KP_3:
                            case XK_KP_Next:
                                mcb[8]->setState( ( mcb[8]->getState() == true ) ? false : true );
                                break;
                            case XK_4:
                            case XK_KP_4:
                            case XK_KP_Left:
                                mcb[3]->setState( ( mcb[3]->getState() == true ) ? false : true );
                                break;
                            case XK_5:
                            case XK_KP_5:
                            case XK_KP_Begin:
                                mcb[4]->setState( ( mcb[4]->getState() == true ) ? false : true );
                                break;
                            case XK_6:
                            case XK_KP_6:
                            case XK_KP_Right:
                                mcb[5]->setState( ( mcb[5]->getState() == true ) ? false : true );
                                break;
                            case XK_7:
                            case XK_KP_7:
                            case XK_KP_Home:
                                mcb[0]->setState( ( mcb[0]->getState() == true ) ? false : true );
                                break;
                            case XK_8:
                            case XK_KP_8:
                            case XK_KP_Up:
                                mcb[1]->setState( ( mcb[1]->getState() == true ) ? false : true );
                                break;
                            case XK_9:
                            case XK_KP_9:
                            case XK_KP_Prior:
                                mcb[2]->setState( ( mcb[2]->getState() == true ) ? false : true );
                                break;
                            case XK_Return:
                            case XK_KP_Enter:
                                if ( ok2allb->getHasFocus() == false &&
                                     skipb->getHasFocus() == false &&
                                     cb->getHasFocus() == false ) {
                                    endmode = 0;
                                }
                                break;
                            case XK_F1:
                                endmode = 0;
                                break;
                            case XK_Escape:
                            case XK_F4:
                                endmode = 3;
                                break;
                            case XK_F2:
                                endmode = 1;
                                break;
                            case XK_F3:
                                endmode = 2;
                                break;
                        }
                    }
                    break;
                case AG_CYCLEBUTTONCLICKED:
                    if ( msg->cyclebutton.cyclebutton == apply_mode_cb ) {
                        switch ( msg->cyclebutton.option ) {
                            case 2:
                            case 1:
                                setChooseButtonMatrixForMode( mcb, 0 );
                                break;
                            default:
                                setChooseButtonMatrixForMode( mcb, tmode );
                                break;
                        }
                    }
                    break;
            }
            aguix->ReplyMessage( msg );
        }
    }
    
    if ( endmode == 0 || endmode == 1 ) {
        // ok
        newmode = 0;
        newmode |= ( mcb[0]->getState() == true ) ? S_IRUSR : 0;
        newmode |= ( mcb[1]->getState() == true ) ? S_IWUSR : 0;
        newmode |= ( mcb[2]->getState() == true ) ? S_IXUSR : 0;
        newmode |= ( mcb[3]->getState() == true ) ? S_IRGRP : 0;
        newmode |= ( mcb[4]->getState() == true ) ? S_IWGRP : 0;
        newmode |= ( mcb[5]->getState() == true ) ? S_IXGRP : 0;
        newmode |= ( mcb[6]->getState() == true ) ? S_IROTH : 0;
        newmode |= ( mcb[7]->getState() == true ) ? S_IWOTH : 0;
        newmode |= ( mcb[8]->getState() == true ) ? S_IXOTH : 0;
        newmode |= ( mcb[9]->getState() == true ) ? S_ISUID : 0;
        newmode |= ( mcb[10]->getState() == true ) ? S_ISGID : 0;
        newmode |= ( mcb[11]->getState() == true ) ? S_ISVTX : 0;
        return_mode->mode = newmode;

        switch ( apply_mode_cb->getSelectedOption() ) {
            case 2:
                return_mode->op = changemod_info::CHMOD_REM;
                break;
            case 1:
                return_mode->op = changemod_info::CHMOD_ADD;
                break;
            default:
                return_mode->op = changemod_info::CHMOD_SET;
                break;
        }
    }
    
    delete win;
    
    return endmode;
}

NormalMode::changemod_info::changemod_info()
{
    forAll = false;
    mode = 0;
    op = CHMOD_SET;
}
