/* fieldlistviewdnd.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2002-2007 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "fieldlistviewdnd.h"
#include "awindow.h"
#include "guielement.h"

const char *FieldListViewDND::type="FieldListViewDND";

FieldListViewDND::~FieldListViewDND()
{
  removealldndtexts();
}

FieldListViewDND::FieldListViewDND( AGUIX *taguix,
				    int tx,
				    int ty,
				    int width,
				    int height,
				    int tdata ) : FieldListView( taguix,
								 tx,
								 ty,
								 width,
								 height,
								 tdata )
{
  dndMode = DND_IDLE;
  dndtext = NULL;
}

void FieldListViewDND::handleSelect(Message *msg)
{
  int win_x, win_y;
  AGMessage *agmsg;
  
  if ( isCreated() == false ) return;

  if ( dndMode != DND_IDLE ) {
    handleDND( msg );
    return;
  }
  if ( msg->type == ButtonPress ) {
    if ( msg->window != win ) return;
    if ( selectMode != SELECT_IDLE ) {
      if ( ( msg->button == _scroll_button ) &&
	   ( selectMode == SELECT_HOLD ) ){
	dndMode = DND_ACTIVE;
        
        _aguix->queryPointer( win, &win_x, &win_y );
	if ( isValidRow( clickLastSelectedRow ) == true ) {
	  colorclass_t ti;
	  
	  if ( clickLastSelectedRow == activerow ) {
	    if ( getSelect( clickLastSelectedRow ) == true )
	      ti = CC_SELACT;
	    else
	      ti = CC_ACTIVE;
	  } else {
	    if ( getSelect( clickLastSelectedRow ) == true )
	      ti = CC_SELECT;
	    else
	      ti = CC_NORMAL;
	  }

          const char *tstr = NULL;
          if ( clickLastSelectedRow >= 0 && clickLastSelectedRow < (int)dndtexts.size() )
              tstr = dndtexts[clickLastSelectedRow].c_str();
	  if ( tstr == NULL ) tstr = ( elementarray[ clickLastSelectedRow ]->getText( 0 ) ).c_str();

	  agmsg = AGUIX_allocAGMessage();
	  agmsg->dnd.element = this;
	  agmsg->dnd.specialinfo.voidP = NULL;
	  agmsg->dnd.specialinfo.value = clickLastSelectedRow;

	  FieldLVRowData *dp = getDataExt( clickLastSelectedRow );
	  if ( dp != NULL ) {
	    agmsg->dnd.specialinfo.rowDataP = dp->duplicate();
	  } else {
	    agmsg->dnd.specialinfo.rowDataP = NULL;
	  }
	  agmsg->dnd.window = NULL;
	  agmsg->dnd.relx = win_x;
	  agmsg->dnd.rely = win_y;
	  agmsg->type = AG_DND_START;
          msgAndCB( std::auto_ptr<AGMessage>( agmsg ) );

	  dndtext = new DNDText( _aguix,
				 tstr,
				 getFG( clickLastSelectedRow, ti ),
				 getBG( clickLastSelectedRow, ti),
				 font );
	  dndtext->create();
	}
      }
      return;
    }
  }
  FieldListView::handleSelect( msg );
}

void FieldListViewDND::handleDND( Message *msg )
{
  int xw, yw, xr, yr;
  Window root, child, rroot;
  unsigned int keys_button;
  
  if ( isCreated() == false ) return;

  if ( msg->type == ButtonPress ) {
    if ( ( dndMode == DND_ACTIVE ) &&
	 ( msg->button == _scroll_button ) ) {
      delete dndtext;
      dndtext = NULL;
      dndMode = DND_DEACTIVE;
    }
  } else if ( ( msg->type == MotionNotify ) ||
	      ( msg->type == Expose ) ) {
    if ( dndtext != NULL ) dndtext->handler( msg );
  } else if ( msg->type == ButtonRelease ) {
    if ( msg->button == _select_button ) {
      if ( dndtext != NULL ) {
	delete dndtext;
	dndtext = NULL;
      }
      Display *dsp=_aguix->getDisplay();
      root=RootWindow(dsp,_aguix->getScreen());
      for(;;) {
        XQueryPointer(dsp,root,&rroot,&child,&xr,&yr,&xw,&yw,&keys_button);
	if(child==0) break;
	root=child;
      }
      // Fenster finden, dass child enthaelt
      child=root;
      AWindow *awin=_aguix->findAWindow(child);
      Widget *widel = NULL;
      if(awin!=NULL) {
	widel = awin->findWidgetForWindow( child );
	if(widel!=NULL) XQueryPointer(dsp,widel->getWindow(),&root,&child,&xr,&yr,&xw,&yw,&keys_button);
      }
      AGMessage *agmsg = AGUIX_allocAGMessage();
      agmsg->dnd.element = widel;
      agmsg->dnd.window=awin;
      agmsg->dnd.specialinfo.voidP = NULL;
      agmsg->dnd.specialinfo.value = 0;
      agmsg->dnd.specialinfo.rowDataP = NULL;
      agmsg->dnd.relx=xw;
      agmsg->dnd.rely=yw;
      if ( dndMode == DND_ACTIVE ) agmsg->type=AG_DND_END;
      else agmsg->type=AG_DND_CANCEL;
      msgAndCB( std::auto_ptr<AGMessage>( agmsg ) );

      switch ( selectMode ) {
	case SELECT_SCROLL_UP:
	case SELECT_SCROLL_DOWN:
	  _aguix->disableTimer();
	case SELECT_HOLD:
	  setSelect( clickLastSelectedRow, false );
	  runSelectHandler( clickLastSelectedRow );
	  agmsg = AGUIX_allocAGMessage();
	  agmsg->fieldlv.lv = this;
	  agmsg->fieldlv.row = clickFirstSelectedRow;
	  agmsg->fieldlv.time = msg->time;
	  agmsg->fieldlv.mouse = true;
	  if ( clickSelected == 1 ) {
	    agmsg->type = AG_FIELDLV_ONESELECT;
	  } else {
	    agmsg->type = AG_FIELDLV_MULTISELECT;
	  }
          msgAndCB( std::auto_ptr<AGMessage>( agmsg ) );
	  break;
	default:
	  break;
      }
      _aguix->msgUnlock( this );
      selectMode = SELECT_IDLE;
      dndMode = DND_IDLE;
    }
  }
}

const char *FieldListViewDND::getType() const
{
  return type;
}

bool FieldListViewDND::isType(const char *qtype) const
{
  if(strcmp(type,qtype)==0) return true;
  return false;
}

void FieldListViewDND::removealldndtexts()
{
    dndtexts.clear();
}

void FieldListViewDND::replacedndtext( int index2, const char *tstr )
{
    if ( index2 < 0 || index2 >= (int)dndtexts.size() ) return;
    dndtexts[index2] = tstr;
}

void FieldListViewDND::adddndtext( const char *tstr )
{
    dndtexts.push_back( tstr );
}

void FieldListViewDND::setSizeDNDText(int ns)
{
    int elems = (int)dndtexts.size();
    while ( elems < ns ) {
        dndtexts.push_back( "" );
        elems++;
    }
    while ( elems > ns ) {
        dndtexts.pop_back();
        elems--;
    }
}
