/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;

public class EMFHeader
implements EMFConstants {
    private static final Dimension screenMM = new Dimension(320, 240);
    private Rectangle bounds;
    private Rectangle frame;
    private String signature;
    private int versionMajor;
    private int versionMinor;
    private int bytes;
    private int records;
    private int handles;
    private String description;
    private int palEntries;
    private Dimension device;
    private Dimension millimeters;
    private Dimension micrometers;
    private boolean openGL;

    public EMFHeader(Rectangle rectangle, int n2, int n3, int n4, int n5, int n6, String string, String string2, Dimension dimension) {
        this.bounds = rectangle;
        double d2 = (double)EMFHeader.screenMM.width / (double)dimension.width;
        double d3 = (double)EMFHeader.screenMM.height / (double)dimension.height;
        this.frame = new Rectangle((int)((double)(rectangle.x * 100) * d2), (int)((double)(rectangle.y * 100) * d3), (int)((double)(rectangle.width * 100) * d2), (int)((double)(rectangle.height * 100) * d3));
        this.signature = " EMF";
        this.versionMajor = n2;
        this.versionMinor = n3;
        this.bytes = n4;
        this.records = n5;
        this.handles = n6;
        this.description = string.trim() + "\u0000" + string2.trim() + "\u0000\u0000";
        this.palEntries = 0;
        this.device = dimension;
        this.millimeters = screenMM;
        this.openGL = false;
        this.micrometers = new Dimension(EMFHeader.screenMM.width * 1000, EMFHeader.screenMM.height * 1000);
    }

    EMFHeader(EMFInputStream eMFInputStream) throws IOException {
        eMFInputStream.readUnsignedInt();
        int n2 = eMFInputStream.readDWORD();
        this.bounds = eMFInputStream.readRECTL();
        this.frame = eMFInputStream.readRECTL();
        this.signature = new String(eMFInputStream.readBYTE(4));
        int n3 = eMFInputStream.readDWORD();
        this.versionMajor = n3 >> 16;
        this.versionMinor = n3 & 0xFFFF;
        this.bytes = eMFInputStream.readDWORD();
        this.records = eMFInputStream.readDWORD();
        this.handles = eMFInputStream.readWORD();
        eMFInputStream.readWORD();
        int n4 = eMFInputStream.readDWORD();
        eMFInputStream.readDWORD();
        this.palEntries = eMFInputStream.readDWORD();
        this.device = eMFInputStream.readSIZEL();
        this.millimeters = eMFInputStream.readSIZEL();
        if (n2 - 2 * n4 > 88) {
            eMFInputStream.readDWORD();
            eMFInputStream.readDWORD();
            boolean bl2 = this.openGL = eMFInputStream.readDWORD() != 0;
            if (n2 - 2 * n4 > 100) {
                this.micrometers = eMFInputStream.readSIZEL();
            }
        }
        this.description = eMFInputStream.readWCHAR(n4);
        if (n2 - 2 * n4 > 108) {
            eMFInputStream.readUnsignedByte(n2 - 2 * n4 - 108);
        }
    }

    public void write(EMFOutputStream eMFOutputStream) throws IOException {
        int n2 = eMFOutputStream.getTagAlignment();
        int n3 = (n2 - this.size() % n2) % n2;
        int n4 = this.size() + n3;
        eMFOutputStream.writeDWORD(1);
        eMFOutputStream.writeDWORD(n4);
        eMFOutputStream.writeRECTL(this.bounds);
        eMFOutputStream.writeRECTL(this.frame);
        eMFOutputStream.writeBYTE(this.signature.getBytes());
        eMFOutputStream.writeDWORD(this.versionMajor << 16 | this.versionMinor);
        eMFOutputStream.writeDWORD(n4 + this.bytes);
        eMFOutputStream.writeDWORD(this.records);
        eMFOutputStream.writeWORD(this.handles);
        eMFOutputStream.writeWORD(0);
        eMFOutputStream.writeDWORD(this.description.length());
        eMFOutputStream.writeDWORD(108);
        eMFOutputStream.writeDWORD(this.palEntries);
        eMFOutputStream.writeSIZEL(this.device);
        eMFOutputStream.writeSIZEL(this.millimeters);
        eMFOutputStream.writeDWORD(0);
        eMFOutputStream.writeDWORD(0);
        eMFOutputStream.writeDWORD(this.openGL);
        eMFOutputStream.writeSIZEL(this.micrometers);
        eMFOutputStream.writeWCHAR(this.description);
        for (int i2 = 0; i2 < n3; ++i2) {
            eMFOutputStream.write(0);
        }
    }

    public int size() {
        return 108 + 2 * this.description.length();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("EMF Header\n");
        stringBuffer.append("  bounds: " + this.bounds + "\n");
        stringBuffer.append("  frame: " + this.frame + "\n");
        stringBuffer.append("  signature: " + this.signature + "\n");
        stringBuffer.append("  versionMajor: " + this.versionMajor + "\n");
        stringBuffer.append("  versionMinor: " + this.versionMinor + "\n");
        stringBuffer.append("  #bytes: " + this.bytes + "\n");
        stringBuffer.append("  #records: " + this.records + "\n");
        stringBuffer.append("  #handles: " + this.handles + "\n");
        stringBuffer.append("  description: " + this.description + "\n");
        stringBuffer.append("  #palEntries: " + this.palEntries + "\n");
        stringBuffer.append("  device: " + this.device + "\n");
        stringBuffer.append("  millimeters: " + this.millimeters + "\n");
        stringBuffer.append("  openGL: " + this.openGL + "\n");
        stringBuffer.append("  micrometers: " + this.micrometers);
        return stringBuffer.toString();
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public Rectangle getFrame() {
        return this.frame;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getDescription() {
        return this.description;
    }

    public Dimension getDevice() {
        return this.device;
    }

    public Dimension getMillimeters() {
        return this.millimeters;
    }

    public Dimension getMicrometers() {
        return this.micrometers;
    }

    public boolean isOpenGL() {
        return this.openGL;
    }
}

