/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphics2d;

import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedString;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.freehep.graphics2d.TagHandler;
import org.freehep.graphics2d.TagString;

public class GenericTagHandler
extends TagHandler {
    public static Integer UNDERLINE_OVERLINE = new Integer(128);
    private Graphics2D graphics;
    private StringBuffer clearedText;
    private Vector attributes;
    private Hashtable tags;
    private Stack fontFamilyStack;
    private double superscriptCorrection;

    public GenericTagHandler(Graphics2D graphics2D) {
        this.graphics = graphics2D;
        this.clearedText = new StringBuffer();
        this.tags = new Hashtable();
    }

    public void print(TagString tagString, double d2, double d3, double d4) {
        this.fontFamilyStack = new Stack();
        this.clearedText = new StringBuffer();
        this.attributes = new Vector();
        this.superscriptCorrection = d4;
        this.parse(tagString);
        while (this.tags.size() > 0) {
            this.closeTag((String)this.tags.keys().nextElement());
        }
        AttributedString attributedString = new AttributedString(this.clearedText.toString(), this.graphics.getFont().getAttributes());
        for (int i2 = 0; i2 < this.attributes.size(); ++i2) {
            ((AttributeEntry)this.attributes.elementAt(i2)).apply(attributedString);
        }
        this.graphics.drawString(attributedString.getIterator(), (float)d2, (float)d3);
    }

    public TextLayout createTextLayout(TagString tagString, double d2) {
        this.fontFamilyStack = new Stack();
        this.clearedText = new StringBuffer();
        this.attributes = new Vector();
        this.superscriptCorrection = d2;
        this.parse(tagString);
        while (this.tags.size() > 0) {
            this.closeTag((String)this.tags.keys().nextElement());
        }
        AttributedString attributedString = new AttributedString(this.clearedText.toString(), this.graphics.getFont().getAttributes());
        for (int i2 = 0; i2 < this.attributes.size(); ++i2) {
            ((AttributeEntry)this.attributes.elementAt(i2)).apply(attributedString);
        }
        return new TextLayout(attributedString.getIterator(), this.graphics.getFontRenderContext());
    }

    protected String openTag(String string) {
        if (!this.tags.containsKey(string)) {
            this.tags.put(string, new Integer(this.clearedText.length()));
        }
        return "";
    }

    protected String closeTag(String string) {
        if (!this.tags.containsKey(string)) {
            return super.closeTag(string);
        }
        int n2 = (Integer)this.tags.get(string);
        this.tags.remove(string);
        if (string.equalsIgnoreCase("b")) {
            this.attributes.add(new AttributeEntry(n2, this.clearedText.length(), TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD));
        } else if (string.equalsIgnoreCase("i")) {
            this.attributes.add(new AttributeEntry(n2, this.clearedText.length(), TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE));
        } else if (string.equalsIgnoreCase("s") || string.equalsIgnoreCase("strike")) {
            this.attributes.add(new AttributeEntry(n2, this.clearedText.length(), TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON));
        } else if (string.equalsIgnoreCase("udash")) {
            this.attributes.add(new AttributeEntry(n2, this.clearedText.length(), TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_DASHED));
        } else if (string.equalsIgnoreCase("udot")) {
            this.attributes.add(new AttributeEntry(n2, this.clearedText.length(), TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_DOTTED));
        } else if (string.equalsIgnoreCase("u")) {
            this.attributes.add(new AttributeEntry(n2, this.clearedText.length(), TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON));
        } else if (string.equalsIgnoreCase("tt")) {
            this.attributes.add(new AttributeEntry(n2, this.clearedText.length(), TextAttribute.FAMILY, this.fontFamilyStack.pop()));
        } else if (!string.equalsIgnoreCase("v")) {
            if (string.equalsIgnoreCase("over")) {
                this.attributes.add(new AttributeEntry(n2, this.clearedText.length(), TextAttribute.UNDERLINE, UNDERLINE_OVERLINE));
            } else if (string.equalsIgnoreCase("sup")) {
                this.attributes.add(new AttributeEntry(n2, this.clearedText.length(), TextAttribute.TRANSFORM, AffineTransform.getTranslateInstance(0.0, this.superscriptCorrection)));
                this.attributes.add(new AttributeEntry(n2, this.clearedText.length(), TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER));
            } else if (string.equalsIgnoreCase("sub")) {
                this.attributes.add(new AttributeEntry(n2, this.clearedText.length(), TextAttribute.TRANSFORM, AffineTransform.getTranslateInstance(0.0, -this.superscriptCorrection)));
                this.attributes.add(new AttributeEntry(n2, this.clearedText.length(), TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB));
            } else {
                return super.closeTag(string);
            }
        }
        return "";
    }

    protected String text(String string) {
        this.clearedText.append(string);
        return string;
    }

    private class AttributeEntry {
        private int begin;
        private int end;
        private TextAttribute textAttribute;
        private Object value;

        protected AttributeEntry(int n2, int n3, TextAttribute textAttribute, Object object) {
            this.begin = n2;
            this.end = n3;
            this.textAttribute = textAttribute;
            this.value = object;
        }

        protected void apply(AttributedString attributedString) {
            attributedString.addAttribute(this.textAttribute, this.value, this.begin, this.end);
        }
    }
}

