/***************************************************************************
         publichubsproxy.cpp  -  Proxy model for public hubs filtering
                             -------------------
    begin                : Mon Sep 29 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "publichubsproxy.h"

/* for DC_HubFilterObject */
#include "dcconfig.h"

/** */
PublicHubsProxy::PublicHubsProxy( QObject * parent ) : QSortFilterProxyModel( parent )
{
	/* these could also be put in the initialisation section */
	minusers = 0;
	inName = false;
	inAddress = false;
	inDesc = false;
}

/** */
PublicHubsProxy::~PublicHubsProxy()
{
	/* nothing */
}

/** */
void PublicHubsProxy::setFilter( DC_HubFilterObject * filter )
{
	if ( filter == 0 )
	{
		minusers = 0;
		inName = false;
		inAddress = false;
		inDesc = false;
		
		/* the regexp is not used when no columns are set */
		setFilterRegExp( QRegExp(QString(),filterCaseSensitivity()) );
	}
	else
	{
		minusers = filter->m_nUser;
		inName = filter->m_bName;
		inAddress = filter->m_bServer;
		inDesc = filter->m_bDescription;
		
		setFilterRegExp( QRegExp(filter->m_sContains,filterCaseSensitivity()) );
	}
}

/** */
bool PublicHubsProxy::filterAcceptsRow( int source_row, const QModelIndex & source_parent ) const
{
	const int role = filterRole();
	const QAbstractItemModel * sourcemodel = sourceModel();
	
	const QModelIndex hubusers = sourcemodel->index( source_row, 3, source_parent );
	
	if ( sourcemodel->data(hubusers,role).toUInt() < minusers )
	{
		return false;
	}
	
	if ( inName || inAddress || inDesc )
	{
		const QRegExp filter = filterRegExp();
		
		if ( inName )
		{
			const QModelIndex hubname = sourcemodel->index( source_row, 0, source_parent );
			if ( sourcemodel->data(hubname,role).toString().contains(filter) )
			{
				return true;
			}
		}
		
		if ( inAddress )
		{
			const QModelIndex hubaddr = sourcemodel->index( source_row, 1, source_parent );
			if ( sourcemodel->data(hubaddr,role).toString().contains(filter) )
			{
				return true;
			}
		}
		
		if ( inDesc )
		{
			const QModelIndex hubdesc = sourcemodel->index( source_row, 2, source_parent );
			if ( sourcemodel->data(hubdesc,role).toString().contains(filter) )
			{
				return true;
			}
		}
		
		return false;
	}
	
	return true;
}
