/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#include <gdk/gdkkeysyms.h>    // for GDK_key...

#include <uget.h>

#include <glib/gi18n.h>

#define	UGET_ACCEL_PATH_CTRL_N		"<Uget>/New/Download"

static void uget_init_window  (Uget* app);
static void uget_init_menubar (Uget* app);
static void uget_init_toolbar (Uget* app);
static void uget_init_status_icon_menu (Uget* app);
static void uget_init_summary_menu  (Uget* app);

void	uget_init_gui (Uget* app)
{
	extern	gchar*	uget_path_icons;	// uget-main.c
	gchar*			file_path;

	// accelerators
	app->accelgroup = gtk_accel_group_new ();
	gtk_accel_group_connect (app->accelgroup, GDK_q, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE,
	                         g_cclosure_new_swap (G_CALLBACK (uget_quit), app, NULL));
//	                                              G_CALLBACK (uget_on_window_close)
	gtk_accel_group_connect (app->accelgroup, GDK_s, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE,
	                         g_cclosure_new_swap (G_CALLBACK (uget_save), app, NULL));
	gtk_accel_group_connect (app->accelgroup, GDK_n, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE,
	                         g_cclosure_new_swap (G_CALLBACK (uget_on_create_download), app, NULL));
	gtk_accel_group_connect (app->accelgroup, GDK_c, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE,
	                         g_cclosure_new_swap (G_CALLBACK (uget_on_summary_copy_selected), app, NULL));
//	gtk_accel_group_lock (app->accelgroup);
//	gtk_accel_groups_activate (G_OBJECT(app->window), GDK_q, GDK_CONTROL_MASK);
//	gtk_accel_group_unlock (app->accelgroup);
	gtk_accel_map_add_entry (UGET_ACCEL_PATH_CTRL_N, GDK_n, GDK_CONTROL_MASK);

#ifdef _WIN32
	// This will use icons\hicolor\index.theme
	{
		GtkIconTheme*	icon_theme;

		icon_theme = gtk_icon_theme_get_default ();
		gtk_icon_theme_append_search_path (icon_theme, uget_path_icons);
	}
#endif

	// icon in system tray
	file_path = g_build_filename (uget_path_icons, "hicolor", "16x16", "apps", "uget-icon.png", NULL);
	if (g_file_test (file_path, G_FILE_TEST_IS_REGULAR))
		app->status_icon = gtk_status_icon_new_from_icon_name (UGET_ICON_NAME);
	else
		app->status_icon = gtk_status_icon_new_from_stock (GTK_STOCK_GO_DOWN);
	g_free (file_path);
	gtk_status_icon_set_tooltip_text (app->status_icon, "Uget");
	uget_init_status_icon_menu (app);
	g_signal_connect (app->status_icon, "activate", G_CALLBACK (uget_on_status_icon_activate), app);
	g_signal_connect (app->status_icon, "popup-menu", G_CALLBACK (uget_on_status_icon_popup_menu), app);

	uget_init_window (app);
}

static void uget_init_window (Uget* app)
{
	GtkTreeSelection*	selection;
	GtkWidget*			scrolled;
	GtkBox*				vbox;

	// Main Window
	app->window = (GtkWindow*) gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (app->window, "Uget");
	gtk_window_set_default_size (app->window, 620, 400);
	gtk_window_add_accel_group (app->window, app->accelgroup);
	g_signal_connect_swapped (app->window, "delete-event", G_CALLBACK (uget_on_window_close), app);
	g_signal_connect_swapped (app->window, "destroy", G_CALLBACK (uget_quit), app);
	g_signal_connect (app->window, "key-press-event", G_CALLBACK (uget_on_window_key_press_event), app);

	// icons for window
	gtk_window_set_default_icon_name (UGET_ICON_NAME);

	// top container for Main Window
	vbox = (GtkBox*) gtk_vbox_new (FALSE, 3);
	gtk_container_add (GTK_CONTAINER (app->window), GTK_WIDGET (vbox));

	// MenuBar
	uget_init_menubar (app);
	gtk_box_pack_start (vbox, app->menubar.self, FALSE, FALSE, 0);

	// Toolbar
	uget_init_toolbar (app);
	gtk_box_pack_start (vbox, app->toolbar.self, FALSE, FALSE, 0);

	// paned --- start ---
	app->hpaned = (GtkPaned*)gtk_hpaned_new ();
	gtk_box_pack_start (vbox, GTK_WIDGET (app->hpaned), TRUE, TRUE, 0);
	// vpaned
	app->vpaned = (GtkPaned*)gtk_vpaned_new ();
	gtk_paned_pack2 (app->hpaned, GTK_WIDGET (app->vpaned), TRUE, FALSE);
	// total list view
	app->left_vbox = (GtkBox*) gtk_vbox_new (FALSE, 2);
	app->total_list_label = gtk_label_new (_("Total"));
	gtk_box_pack_start (app->left_vbox, app->total_list_label, FALSE, FALSE, 0);
	app->total_list_view = ug_category_view_new ();
	gtk_tree_view_set_model (app->total_list_view, GTK_TREE_MODEL (app->total_list));
	selection = gtk_tree_view_get_selection (app->total_list_view);
	app->total_list_signal = g_signal_connect (selection, "changed", G_CALLBACK (uget_on_category_selection_changed), app);
	g_signal_connect (app->total_list_view, "button-press-event", G_CALLBACK (uget_on_right_button_press), app);
	gtk_box_pack_start (app->left_vbox, (GtkWidget*) app->total_list_view, FALSE, FALSE, 0);
	// cateory tree view
	app->category_tree_label = gtk_label_new (_("Category"));
	gtk_box_pack_start (app->left_vbox, app->category_tree_label, FALSE, FALSE, 0);
	app->category_tree_view = ug_category_view_new ();
	gtk_tree_view_set_model (app->category_tree_view, GTK_TREE_MODEL (app->category_tree));
	gtk_widget_set_size_request ((GtkWidget*) app->category_tree_view, 165, 100);
	selection = gtk_tree_view_get_selection (app->category_tree_view);
	app->category_tree_signal = g_signal_connect (selection, "changed", G_CALLBACK (uget_on_category_selection_changed), app);
	g_signal_connect (app->category_tree_view, "button-press-event", G_CALLBACK (uget_on_right_button_press), app);
	scrolled = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolled), GTK_SHADOW_IN);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled),
	                                GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add (GTK_CONTAINER(scrolled), GTK_WIDGET(app->category_tree_view));
	gtk_box_pack_start (app->left_vbox, GTK_WIDGET (scrolled), TRUE, TRUE, 0);
	gtk_paned_pack1 (app->hpaned, GTK_WIDGET (app->left_vbox), FALSE, TRUE);
	gtk_widget_grab_focus ((GtkWidget*) app->category_tree_view);
	app->category_tree_scroll = scrolled;
	// label
	app->label_no_selected = gtk_label_new (_("No category selected."));
	gtk_widget_set_size_request (app->label_no_selected, 50, 120);
	gtk_paned_pack1 (app->vpaned, GTK_WIDGET (app->label_no_selected), TRUE, FALSE);
	// summary
	uget_init_summary_menu  (app);
	app->summary_view = ug_item_view_new (_("Item"), _("Value"));
	ug_item_view_for_summary (app->summary_view);
	gtk_tree_view_set_model (app->summary_view, GTK_TREE_MODEL (app->summary_store));
	g_signal_connect (app->summary_view, "button-press-event", G_CALLBACK (uget_on_right_button_press), app);
	app->summary_scroll = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (app->summary_scroll),
	                                     GTK_SHADOW_IN);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (app->summary_scroll),
	                                GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_widget_set_size_request (app->summary_scroll, 200, 90);
	gtk_container_add (GTK_CONTAINER(app->summary_scroll), GTK_WIDGET(app->summary_view));
	gtk_paned_pack2 (app->vpaned, GTK_WIDGET (app->summary_scroll), FALSE, TRUE);
	// paned --- end ---

	// Statusbar
	app->statusbar = (GtkStatusbar*) gtk_statusbar_new ();
	gtk_box_pack_start (vbox, GTK_WIDGET (app->statusbar), FALSE, FALSE, 0);
	gtk_widget_show_all ((GtkWidget*) vbox);
}

static void uget_init_status_icon_menu (Uget* app)
{
	GtkWidget*		image;
	GtkWidget*		menu;
	GtkWidget*		menu_item;

	menu = gtk_menu_new ();
	// New Download
	menu_item = gtk_image_menu_item_new_with_mnemonic (_("New _Download..."));
	image = gtk_image_new_from_stock (GTK_STOCK_FILE, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect_swapped (menu_item, "activate", G_CALLBACK (uget_on_create_download), app);

	// New Download from Clipboard
	menu_item = gtk_image_menu_item_new_with_mnemonic (_("New _from Clipboard..."));
	image = gtk_image_new_from_stock (GTK_STOCK_PASTE, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_create_from_clipboard), app);

	// About
	menu_item = gtk_image_menu_item_new_from_stock (GTK_STOCK_ABOUT, NULL);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_about), app);

	// Quit
	menu_item = gtk_image_menu_item_new_from_stock (GTK_STOCK_QUIT, NULL);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect_swapped (menu_item, "activate", G_CALLBACK (uget_quit), app);

	gtk_widget_show_all (menu);
	app->status_icon_menu = (GtkMenu*) menu;
}

static void uget_init_menubar (Uget* app)
{
	GtkWidget*		image;
	GtkWidget*		menu;
	GtkWidget*		sub_menu;
	GtkWidget*		menu_item;

	// Menubar
	app->menubar.self = gtk_menu_bar_new ();

	// -----------------------------------------------------------------------
	// File Menu
	menu = gtk_menu_new ();
	menu_item = gtk_menu_item_new_with_mnemonic (_("_File"));
	gtk_menu_item_set_submenu ((GtkMenuItem*)menu_item, menu);
	gtk_menu_shell_append ((GtkMenuShell*)app->menubar.self, menu_item);
//	menu.gtk_menu_shell_append((GtkMenuShell*)menu, gtk_tearoff_menu_item_new() );

	// New --- start --- (accelerators)
	menu_item = gtk_image_menu_item_new_from_stock (GTK_STOCK_NEW, NULL);
	sub_menu = gtk_menu_new ();
	gtk_menu_set_accel_group ((GtkMenu*)sub_menu, app->accelgroup);
	gtk_menu_item_set_submenu ((GtkMenuItem*)menu_item, sub_menu);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	// New - Download (accelerators)
	menu_item = gtk_image_menu_item_new_with_mnemonic (_("_Download..."));
	gtk_menu_item_set_accel_path ((GtkMenuItem*) menu_item, UGET_ACCEL_PATH_CTRL_N);
	image = gtk_image_new_from_stock (GTK_STOCK_FILE, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*)sub_menu, menu_item);
	g_signal_connect_swapped (menu_item, "activate", G_CALLBACK (uget_on_create_download), app);
	app->menubar.file.create.download = menu_item;
	// New - Category
	menu_item = gtk_image_menu_item_new_with_mnemonic (_("_Category..."));
	image = gtk_image_new_from_stock (GTK_STOCK_DND_MULTIPLE, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*)sub_menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_create_category), app);
	app->menubar.file.create.category = menu_item;
	// New - Batch download
	menu_item = gtk_image_menu_item_new_with_mnemonic (_("_Batch download..."));
	image = gtk_image_new_from_stock (GTK_STOCK_SORT_ASCENDING, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*)sub_menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_create_batch), app);
	app->menubar.file.create.batch = menu_item;
	// New - from clipboard
	menu_item = gtk_image_menu_item_new_with_mnemonic (_("_From Clipboard..."));
	image = gtk_image_new_from_stock (GTK_STOCK_PASTE, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*)sub_menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_create_from_clipboard), app);
	app->menubar.file.create.from_clipboard = menu_item;
	// New --- end ---

	gtk_menu_shell_append ((GtkMenuShell*)menu, gtk_separator_menu_item_new() );

	// Save
	menu_item = gtk_image_menu_item_new_from_stock (GTK_STOCK_SAVE, app->accelgroup);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect_swapped (menu_item, "activate", G_CALLBACK (uget_save), app);
	app->menubar.file.save = menu_item;

	gtk_menu_shell_append ((GtkMenuShell*)menu, gtk_separator_menu_item_new() );

	menu_item = gtk_image_menu_item_new_with_mnemonic (_("Import _HTML file..."));
	image = gtk_image_new_from_stock (GTK_STOCK_CONVERT, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_import_html_file), app);
	app->menubar.file.import_html = menu_item;

	menu_item = gtk_image_menu_item_new_with_mnemonic (_("_Import text file..."));
	image = gtk_image_new_from_stock (GTK_STOCK_GO_FORWARD, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_import_text_file), app);
	app->menubar.file.import_text = menu_item;

	menu_item = gtk_image_menu_item_new_with_mnemonic (_("_Export text file..."));
	image = gtk_image_new_from_stock (GTK_STOCK_GO_BACK, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_export_text_file), app);
	app->menubar.file.export_text = menu_item;

	gtk_menu_shell_append ((GtkMenuShell*)menu, gtk_separator_menu_item_new() );

	menu_item = gtk_image_menu_item_new_from_stock (GTK_STOCK_QUIT, app->accelgroup);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect_swapped (menu_item, "activate", G_CALLBACK (uget_quit), app);
//	g_signal_connect_swapped (menu_item, "activate", G_CALLBACK (uget_on_window_close), app);
	app->menubar.file.quit = menu_item;

	// -----------------------------------------------------------------------
	// Edit Menu
	menu = gtk_menu_new ();
	menu_item = gtk_menu_item_new_with_mnemonic (_("_Edit"));
	gtk_menu_item_set_submenu ((GtkMenuItem*)menu_item, menu);
	gtk_menu_shell_append ((GtkMenuShell*)app->menubar.self, menu_item);
//	menu.gtk_menu_shell_append((GtkMenuShell*)menu, gtk_tearoff_menu_item_new() );

	menu_item = gtk_check_menu_item_new_with_mnemonic (_("Clipboard _Monitor"));
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_clipboard_monitor), app);
	app->menubar.edit.clipboard_monitor = menu_item;

	menu_item = gtk_menu_item_new_with_mnemonic (_("_Clipboard Option..."));
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_clipboard_option), app);
	app->menubar.edit.clipboard_option = menu_item;

	gtk_menu_shell_append ((GtkMenuShell*)menu, gtk_separator_menu_item_new() );

//	menu_item = gtk_menu_item_new_with_mnemonic (_("_Settings..."));
	menu_item = gtk_image_menu_item_new_with_mnemonic (_("_Settings..."));
	image = gtk_image_new_from_stock (GTK_STOCK_PROPERTIES, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_config_settings), app);
	app->menubar.edit.settings = menu_item;

	// -----------------------------------------------------------------------
	// View Menu
	menu = gtk_menu_new ();
	menu_item = gtk_menu_item_new_with_mnemonic (_("_View"));
	gtk_menu_item_set_submenu ((GtkMenuItem*) menu_item, menu);
	gtk_menu_shell_append ((GtkMenuShell*) app->menubar.self, menu_item);

	menu_item = gtk_check_menu_item_new_with_mnemonic (_("_Toolbar"));
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) menu_item, TRUE);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "toggled", G_CALLBACK (uget_on_change_visible_view), app);
	app->menubar.view.toolbar = menu_item;

	menu_item = gtk_check_menu_item_new_with_mnemonic (_("Status _Bar"));
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) menu_item, TRUE);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "toggled", G_CALLBACK (uget_on_change_visible_view), app);
	app->menubar.view.statusbar = menu_item;

	menu_item = gtk_check_menu_item_new_with_mnemonic (_("Total _List"));
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) menu_item, TRUE);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "toggled", G_CALLBACK (uget_on_change_visible_view), app);
	app->menubar.view.total_list = menu_item;

	menu_item = gtk_check_menu_item_new_with_mnemonic (_("Category _Tree"));
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) menu_item, TRUE);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "toggled", G_CALLBACK (uget_on_change_visible_view), app);
	app->menubar.view.category_tree = menu_item;

	gtk_menu_shell_append ((GtkMenuShell*)menu, gtk_separator_menu_item_new() );

	menu_item = gtk_check_menu_item_new_with_mnemonic (_("_Summary"));
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) menu_item, TRUE);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "toggled", G_CALLBACK (uget_on_change_visible_summary), app);
	app->menubar.view.summary = menu_item;

	// Summary Items --- start ---
	menu_item = gtk_menu_item_new_with_mnemonic (_("Summary _Items"));
	sub_menu  = gtk_menu_new ();
	gtk_menu_item_set_submenu ((GtkMenuItem*) menu_item, sub_menu);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	// Summary Items - Name
	menu_item = gtk_check_menu_item_new_with_mnemonic (_("_Name"));
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) menu_item, TRUE);
	gtk_menu_shell_append ((GtkMenuShell*) sub_menu, menu_item);
	g_signal_connect (menu_item, "toggled", G_CALLBACK (uget_on_change_visible_summary), app);
	app->menubar.view.summary_items.name = menu_item;
	// Summary Items - Folder
	menu_item = gtk_check_menu_item_new_with_mnemonic (_("_Folder"));
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) menu_item, TRUE);
	gtk_menu_shell_append ((GtkMenuShell*) sub_menu, menu_item);
	g_signal_connect (menu_item, "toggled", G_CALLBACK (uget_on_change_visible_summary), app);
	app->menubar.view.summary_items.folder = menu_item;
	// Summary Items - Category
	menu_item = gtk_check_menu_item_new_with_mnemonic (_("C_ategory"));
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) menu_item, TRUE);
	gtk_menu_shell_append ((GtkMenuShell*) sub_menu, menu_item);
	g_signal_connect (menu_item, "toggled", G_CALLBACK (uget_on_change_visible_summary), app);
	app->menubar.view.summary_items.category = menu_item;
	// Summary Items - Elapsed
//	menu_item = gtk_check_menu_item_new_with_mnemonic (_("_Elapsed"));
//	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) menu_item, TRUE);
//	gtk_menu_shell_append ((GtkMenuShell*) sub_menu, menu_item);
//	g_signal_connect (menu_item, "toggled", G_CALLBACK (uget_on_change_visible_summary), app);
//	app->menubar.view.summary_items.elapsed = menu_item;
	// Summary Items - URL
	menu_item = gtk_check_menu_item_new_with_mnemonic (_("_URL"));
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) menu_item, TRUE);
	gtk_menu_shell_append ((GtkMenuShell*) sub_menu, menu_item);
	g_signal_connect (menu_item, "toggled", G_CALLBACK (uget_on_change_visible_summary), app);
	app->menubar.view.summary_items.url = menu_item;
	// Summary Items - Message
	menu_item = gtk_check_menu_item_new_with_mnemonic (_("_Message"));
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) menu_item, TRUE);
	gtk_menu_shell_append ((GtkMenuShell*) sub_menu, menu_item);
	g_signal_connect (menu_item, "toggled", G_CALLBACK (uget_on_change_visible_summary), app);
	app->menubar.view.summary_items.message = menu_item;
	// Summary Items --- end ---

	gtk_menu_shell_append ((GtkMenuShell*)menu, gtk_separator_menu_item_new() );

	menu_item = gtk_check_menu_item_new_with_mnemonic (_("Download _Rules Hint"));
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) menu_item, TRUE);
	g_signal_connect (menu_item, "toggled", G_CALLBACK (uget_on_change_visible_column), app);
	app->menubar.view.rules_hint = menu_item;

	// Download Columns --- start ---
	sub_menu  = gtk_menu_new ();
	menu_item = gtk_menu_item_new_with_mnemonic (_("Download _Columns"));
	gtk_menu_item_set_submenu ((GtkMenuItem*) menu_item, sub_menu);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	app->menubar.view.columns.self = menu_item;
	// Download Columns - Completed
	menu_item = gtk_check_menu_item_new_with_mnemonic (_("_Complete"));
	gtk_menu_shell_append ((GtkMenuShell*) sub_menu, menu_item);
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) menu_item, TRUE);
	g_signal_connect (menu_item, "toggled", G_CALLBACK (uget_on_change_visible_column), app);
	app->menubar.view.columns.completed = menu_item;
	// Download Columns - Total
	menu_item = gtk_check_menu_item_new_with_mnemonic (_("_Size"));
	gtk_menu_shell_append ((GtkMenuShell*) sub_menu, menu_item);
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) menu_item, TRUE);
	g_signal_connect (menu_item, "toggled", G_CALLBACK (uget_on_change_visible_column), app);
	app->menubar.view.columns.total = menu_item;
	// Download Columns - Percent (%)
	menu_item = gtk_check_menu_item_new_with_mnemonic (_("_Percent '%'"));
	gtk_menu_shell_append ((GtkMenuShell*) sub_menu, menu_item);
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) menu_item, TRUE);
	g_signal_connect (menu_item, "toggled", G_CALLBACK (uget_on_change_visible_column), app);
	app->menubar.view.columns.percent = menu_item;
	// Download Columns - Elapsed
	menu_item = gtk_check_menu_item_new_with_mnemonic (_("_Elapsed"));
	gtk_menu_shell_append ((GtkMenuShell*) sub_menu, menu_item);
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) menu_item, TRUE);
	g_signal_connect (menu_item, "toggled", G_CALLBACK (uget_on_change_visible_column), app);
	app->menubar.view.columns.elapsed = menu_item;
	// Download Columns - Left
	menu_item = gtk_check_menu_item_new_with_mnemonic (_("_Left"));
	gtk_menu_shell_append ((GtkMenuShell*) sub_menu, menu_item);
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) menu_item, TRUE);
	g_signal_connect (menu_item, "toggled", G_CALLBACK (uget_on_change_visible_column), app);
	app->menubar.view.columns.left = menu_item;
	// Download Columns - Speed
	menu_item = gtk_check_menu_item_new_with_mnemonic (_("Spee_d"));
	gtk_menu_shell_append ((GtkMenuShell*) sub_menu, menu_item);
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) menu_item, TRUE);
	g_signal_connect (menu_item, "toggled", G_CALLBACK (uget_on_change_visible_column), app);
	app->menubar.view.columns.speed = menu_item;
	// Download Columns - Retry
	menu_item = gtk_check_menu_item_new_with_mnemonic (_("_Retry"));
	gtk_menu_shell_append ((GtkMenuShell*) sub_menu, menu_item);
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) menu_item, TRUE);
	g_signal_connect (menu_item, "toggled", G_CALLBACK (uget_on_change_visible_column), app);
	app->menubar.view.columns.retry = menu_item;
	// Download Columns - Category
	menu_item = gtk_check_menu_item_new_with_mnemonic (_("C_ategory"));
	gtk_menu_shell_append ((GtkMenuShell*) sub_menu, menu_item);
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) menu_item, TRUE);
	g_signal_connect (menu_item, "toggled", G_CALLBACK (uget_on_change_visible_column), app);
	app->menubar.view.columns.category = menu_item;
	// Download Columns - URL
	menu_item = gtk_check_menu_item_new_with_mnemonic (_("_URL"));
	gtk_menu_shell_append ((GtkMenuShell*) sub_menu, menu_item);
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) menu_item, TRUE);
	g_signal_connect (menu_item, "toggled", G_CALLBACK (uget_on_change_visible_column), app);
	app->menubar.view.columns.url = menu_item;
	// Download Columns --- end ---

	// -----------------------------------------------------------------------
	// Category Menu
	menu = gtk_menu_new ();
	menu_item = gtk_menu_item_new_with_mnemonic (_("_Category"));
	gtk_menu_item_set_submenu ((GtkMenuItem*)menu_item, menu);
	gtk_menu_shell_append ((GtkMenuShell*)app->menubar.self, menu_item);
	app->menubar.category.menu = menu;
	// New Category
	menu_item = gtk_image_menu_item_new_with_mnemonic(_("_New Category..."));
	image = gtk_image_new_from_stock (GTK_STOCK_DND_MULTIPLE, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_create_category), app);
	app->menubar.category.create = menu_item;
	// Delete Category
	menu_item = gtk_image_menu_item_new_with_mnemonic(_("_Delete Category"));
	image = gtk_image_new_from_stock (GTK_STOCK_CLOSE, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_delete_category), app);
	app->menubar.category.delete = menu_item;
	// Properties
	menu_item = gtk_image_menu_item_new_from_stock (GTK_STOCK_PROPERTIES, NULL);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_config_category), app);
	app->menubar.category.properties = menu_item;
	// separator
	gtk_menu_shell_append ((GtkMenuShell*)menu, gtk_separator_menu_item_new() );
	// Default for new
	menu_item = gtk_image_menu_item_new_with_mnemonic(_("Default for new _Category..."));
	image = gtk_image_new_from_stock (GTK_STOCK_APPLY, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_config_category_default), app);
	app->menubar.category.default_for_new = menu_item;

	// -----------------------------------------------------------------------
	// Download Menu
	menu = gtk_menu_new ();
	menu_item = gtk_menu_item_new_with_mnemonic (_("_Download"));
	gtk_menu_item_set_submenu ((GtkMenuItem*)menu_item, menu);
	gtk_menu_shell_append ((GtkMenuShell*)app->menubar.self, menu_item);
//	app->menubar.download.self = menu_item;
	app->menubar.download.menu = menu;

//	menu.gtk_menu_shell_append((GtkMenuShell*)menu, gtk_tearoff_menu_item_new() );

	menu_item = gtk_image_menu_item_new_from_stock (GTK_STOCK_NEW, app->accelgroup);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect_swapped (menu_item, "activate", G_CALLBACK (uget_on_create_download), app);
//	app->menubar.download.create = menu_item;

	menu_item = gtk_image_menu_item_new_from_stock (GTK_STOCK_DELETE, NULL);
//	menu_item = gtk_image_menu_item_new_with_mnemonic (_("_Delete"));
//	image = gtk_image_new_from_stock (GTK_STOCK_DELETE, GTK_ICON_SIZE_MENU);
//	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_delete_download), app);
	app->menubar.download.delete = menu_item;

	menu_item = gtk_image_menu_item_new_with_mnemonic (_("Delete _File and Data"));
//	image = gtk_image_new_from_stock (GTK_STOCK_DELETE, GTK_ICON_SIZE_MENU);
//	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_delete_download_file), app);
	app->menubar.download.delete_file = menu_item;

	gtk_menu_shell_append ((GtkMenuShell*)menu, gtk_separator_menu_item_new() );

	menu_item = gtk_image_menu_item_new_from_stock (GTK_STOCK_OPEN, NULL);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_open_downloaded_file), app);
	app->menubar.download.open = menu_item;
	gtk_widget_hide (menu_item);

	menu_item = gtk_image_menu_item_new_with_mnemonic(_("Open _containing folder"));
	image = gtk_image_new_from_stock (GTK_STOCK_DIRECTORY, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_open_downloaded_folder), app);
	app->menubar.download.open_folder = menu_item;

	gtk_menu_shell_append ((GtkMenuShell*)menu, gtk_separator_menu_item_new() );

	menu_item = gtk_image_menu_item_new_with_mnemonic(_("_Runnable"));
	image = gtk_image_new_from_stock (GTK_STOCK_MEDIA_PLAY, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_set_download_runnable), app);
	app->menubar.download.runnable = menu_item;

	menu_item = gtk_image_menu_item_new_from_stock (GTK_STOCK_MEDIA_PAUSE, NULL);
//	menu_item = gtk_image_menu_item_new_with_mnemonic(_("P_ause"));
//	image = gtk_image_new_from_stock (GTK_STOCK_MEDIA_PAUSE, GTK_ICON_SIZE_MENU);
//	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_set_download_to_pause), app);
	app->menubar.download.pause = menu_item;

	gtk_menu_shell_append ((GtkMenuShell*)menu, gtk_separator_menu_item_new() );

	// Move to --- start ---
	menu_item = gtk_image_menu_item_new_with_mnemonic(_("_Move To"));
	image = gtk_image_new_from_stock (GTK_STOCK_DND_MULTIPLE, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	app->menubar.download.move_to.self = menu_item;
	// Move to - submenu
	sub_menu = gtk_menu_new ();
	gtk_menu_item_set_submenu ((GtkMenuItem*)menu_item, sub_menu);
	app->menubar.download.move_to.menu = sub_menu;
	app->menubar.download.move_to.array = g_ptr_array_sized_new (16*2);
	// Move To - Queuing
	menu_item = gtk_image_menu_item_new_with_label (UG_CATEGORY_QUEUING_NAME);
//	menu_item = gtk_image_menu_item_new_with_mnemonic (UG_CATEGORY_QUEUING_NAME);
	image = gtk_image_new_from_stock (UG_CATEGORY_QUEUING_STOCK, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*) sub_menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_move_download), app);
	g_ptr_array_add (app->menubar.download.move_to.array, menu_item);
	g_ptr_array_add (app->menubar.download.move_to.array, app->queuing);
	// Move To - Completed
	menu_item = gtk_image_menu_item_new_with_label (UG_CATEGORY_COMPLETED_NAME);
//	menu_item = gtk_image_menu_item_new_with_mnemonic (UG_CATEGORY_COMPLETED_NAME);
	image = gtk_image_new_from_stock (UG_CATEGORY_COMPLETED_STOCK, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*) sub_menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_move_download), app);
	g_ptr_array_add (app->menubar.download.move_to.array, menu_item);
	g_ptr_array_add (app->menubar.download.move_to.array, app->completed);
	// Move To - Recycled
	menu_item = gtk_image_menu_item_new_with_label (UG_CATEGORY_RECYCLED_NAME);
//	menu_item = gtk_image_menu_item_new_with_mnemonic (UG_CATEGORY_RECYCLED_NAME);
	image = gtk_image_new_from_stock (UG_CATEGORY_RECYCLED_STOCK, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*) sub_menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_move_download), app);
	g_ptr_array_add (app->menubar.download.move_to.array, menu_item);
	g_ptr_array_add (app->menubar.download.move_to.array, app->recycled);
	// Move To - separator
//	gtk_menu_shell_append ((GtkMenuShell*) sub_menu, gtk_separator_menu_item_new() );
	// Move to --- end ---

	gtk_menu_shell_append ((GtkMenuShell*)menu, gtk_separator_menu_item_new() );

	menu_item = gtk_image_menu_item_new_from_stock (GTK_STOCK_GO_UP, NULL);
//	menu_item = gtk_image_menu_item_new_with_mnemonic(_("Move _Up"));
//	image = gtk_image_new_from_stock (GTK_STOCK_GO_UP, GTK_ICON_SIZE_MENU);
//	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_move_download_up), app);
	app->menubar.download.move_up = menu_item;

	menu_item = gtk_image_menu_item_new_from_stock (GTK_STOCK_GO_DOWN, NULL);
//	menu_item = gtk_image_menu_item_new_with_mnemonic(_("Move _Down"));
//	image = gtk_image_new_from_stock (GTK_STOCK_GO_DOWN, GTK_ICON_SIZE_MENU);
//	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_move_download_down), app);
	app->menubar.download.move_down = menu_item;

	menu_item = gtk_image_menu_item_new_from_stock (GTK_STOCK_GOTO_TOP, NULL);
//	menu_item = gtk_image_menu_item_new_with_mnemonic(_("Move _Top"));
//	image = gtk_image_new_from_stock (GTK_STOCK_GOTO_TOP, GTK_ICON_SIZE_MENU);
//	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_move_download_to_top), app);
	app->menubar.download.move_top = menu_item;

	menu_item = gtk_image_menu_item_new_from_stock (GTK_STOCK_GOTO_BOTTOM, NULL);
//	menu_item = gtk_image_menu_item_new_with_mnemonic(_("Move _Bottom"));
//	image = gtk_image_new_from_stock (GTK_STOCK_GOTO_BOTTOM, GTK_ICON_SIZE_MENU);
//	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_move_download_to_bottom), app);
	app->menubar.download.move_bottom = menu_item;

	gtk_menu_shell_append ((GtkMenuShell*)menu, gtk_separator_menu_item_new() );

	menu_item = gtk_image_menu_item_new_from_stock (GTK_STOCK_PROPERTIES, NULL);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_config_download), app);
	app->menubar.download.properties = menu_item;

	// -----------------------------------------------------------------------
	// Help Menu
	menu = gtk_menu_new ();
	menu_item = gtk_menu_item_new_with_mnemonic(_("_Help"));
	gtk_menu_item_set_submenu ((GtkMenuItem*)menu_item, menu);
	gtk_menu_shell_append ((GtkMenuShell*)app->menubar.self, menu_item);

	// About Uget
	menu_item = gtk_image_menu_item_new_from_stock (GTK_STOCK_ABOUT, NULL);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_about), app);
	app->menubar.help.about_uget = menu_item;
}

static void uget_init_summary_menu (Uget* app)
{
	GtkWidget*		image;
	GtkWidget*		menu;
	GtkWidget*		menu_item;

	menu = gtk_menu_new ();
	// Copy
	menu_item = gtk_image_menu_item_new_from_stock (GTK_STOCK_COPY, app->accelgroup);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect_swapped (menu_item, "activate", G_CALLBACK (uget_on_summary_copy_selected), app);

	// Copy All
	menu_item = gtk_image_menu_item_new_with_mnemonic (_("Copy _All"));
	image = gtk_image_new_from_stock (GTK_STOCK_SELECT_ALL, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_summary_copy_all), app);

	gtk_widget_show_all (menu);
	app->summary_menu = (GtkMenu*) menu;
}

static void uget_init_toolbar (Uget* app)
{
	GtkToolbar*		toolbar;
	GtkToolItem*	tool_item;

	GtkWidget*		image;
	GtkWidget*		menu;
	GtkWidget*		menu_item;


	toolbar = (GtkToolbar*) gtk_toolbar_new ();
	gtk_toolbar_set_style (toolbar, GTK_TOOLBAR_ICONS);
	gtk_toolbar_set_icon_size (toolbar, GTK_ICON_SIZE_SMALL_TOOLBAR);
	app->toolbar.self = (GtkWidget*) toolbar;

	// New button --- start ---
	tool_item = (GtkToolItem*) gtk_menu_tool_button_new_from_stock (GTK_STOCK_NEW);
	gtk_tool_item_set_tooltip_text (tool_item, _("Create new download"));
	gtk_menu_tool_button_set_arrow_tooltip_text ((GtkMenuToolButton*)tool_item, "Create new item");
	gtk_tool_item_set_homogeneous (tool_item, FALSE);
	gtk_toolbar_insert (toolbar, tool_item, -1);
	g_signal_connect_swapped (tool_item, "clicked", G_CALLBACK (uget_on_create_download), app);
	app->toolbar.create = tool_item;
	// menu for tool button (accelerators)
	menu = gtk_menu_new ();
	gtk_menu_set_accel_group ((GtkMenu*) menu, app->accelgroup);
	gtk_menu_tool_button_set_menu ((GtkMenuToolButton*)tool_item, menu);
	// New Download (accelerators)
	menu_item = gtk_image_menu_item_new_with_mnemonic (_("New _Download..."));
	gtk_menu_item_set_accel_path ((GtkMenuItem*) menu_item, UGET_ACCEL_PATH_CTRL_N);
	image = gtk_image_new_from_stock (GTK_STOCK_FILE, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect_swapped (menu_item, "activate", G_CALLBACK (uget_on_create_download), app);
	// New Category
	menu_item = gtk_image_menu_item_new_with_mnemonic (_("New _Category..."));
	image = gtk_image_new_from_stock (GTK_STOCK_DND_MULTIPLE, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_create_category), app);
	// New Batch download
	menu_item = gtk_image_menu_item_new_with_mnemonic (_("New _Batch download..."));
	image = gtk_image_new_from_stock (GTK_STOCK_SORT_ASCENDING, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_create_batch), app);
	gtk_widget_show_all (menu);
	// New from Clipboard
	menu_item = gtk_image_menu_item_new_with_mnemonic (_("New _from Clipboard..."));
	image = gtk_image_new_from_stock (GTK_STOCK_PASTE, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image ((GtkImageMenuItem*)menu_item, image);
	gtk_menu_shell_append ((GtkMenuShell*)menu, menu_item);
	g_signal_connect (menu_item, "activate", G_CALLBACK (uget_on_create_from_clipboard), app);
	gtk_widget_show_all (menu);
	// New button --- end ---

	tool_item = (GtkToolItem*) gtk_tool_button_new_from_stock (GTK_STOCK_SAVE);
	gtk_tool_item_set_tooltip_text (tool_item, _("Save all"));
	gtk_toolbar_insert (toolbar, tool_item, -1);
	g_signal_connect_swapped (tool_item, "clicked", G_CALLBACK (uget_save), app);
	app->toolbar.save = tool_item;

	tool_item = gtk_separator_tool_item_new ();
	gtk_toolbar_insert (toolbar, tool_item, -1);

	tool_item = (GtkToolItem*) gtk_tool_button_new_from_stock (GTK_STOCK_MEDIA_PLAY);
	gtk_tool_item_set_tooltip_text (tool_item, _("Set selected download runnable"));
	gtk_toolbar_insert (toolbar, tool_item, -1);
	g_signal_connect (tool_item, "clicked", G_CALLBACK (uget_on_set_download_runnable), app);
	app->toolbar.runnable = tool_item;

	tool_item = (GtkToolItem*) gtk_tool_button_new_from_stock (GTK_STOCK_MEDIA_PAUSE);
	gtk_tool_item_set_tooltip_text (tool_item, _("Set selected download to pause"));
	gtk_toolbar_insert (toolbar, tool_item, -1);
	g_signal_connect (tool_item, "clicked", G_CALLBACK (uget_on_set_download_to_pause), app);
	app->toolbar.pause = tool_item;

	tool_item = (GtkToolItem*) gtk_tool_button_new_from_stock (GTK_STOCK_PROPERTIES);
	gtk_tool_item_set_tooltip_text (tool_item, _("Set selected download properties"));
	gtk_toolbar_insert (toolbar, tool_item, -1);
	g_signal_connect (tool_item, "clicked", G_CALLBACK (uget_on_config_download), app);
	app->toolbar.properties = tool_item;

	tool_item = (GtkToolItem*) gtk_tool_button_new_from_stock (GTK_STOCK_GO_UP);
	gtk_tool_item_set_tooltip_text (tool_item, _("Move selected download up"));
	gtk_toolbar_insert (toolbar, tool_item, -1);
	g_signal_connect (tool_item, "clicked", G_CALLBACK (uget_on_move_download_up), app);
	app->toolbar.move_up = tool_item;

	tool_item = (GtkToolItem*) gtk_tool_button_new_from_stock (GTK_STOCK_GO_DOWN);
	gtk_tool_item_set_tooltip_text (tool_item, _("Move selected download down"));
	gtk_toolbar_insert (toolbar, tool_item, -1);
	g_signal_connect (tool_item, "clicked", G_CALLBACK (uget_on_move_download_down), app);
	app->toolbar.move_down = tool_item;

	tool_item = (GtkToolItem*) gtk_tool_button_new_from_stock (GTK_STOCK_GOTO_TOP);
	gtk_tool_item_set_tooltip_text (tool_item, _("Move selected download to top"));
	gtk_toolbar_insert (toolbar, tool_item, -1);
	g_signal_connect (tool_item, "clicked", G_CALLBACK (uget_on_move_download_to_top), app);
	app->toolbar.move_top = tool_item;

	tool_item = (GtkToolItem*) gtk_tool_button_new_from_stock (GTK_STOCK_GOTO_BOTTOM);
	gtk_tool_item_set_tooltip_text (tool_item, _("Move selected download to bottom"));
	gtk_toolbar_insert (toolbar, tool_item, -1);
	g_signal_connect (tool_item, "clicked", G_CALLBACK (uget_on_move_download_to_bottom), app);
	app->toolbar.move_bottom = tool_item;

	gtk_widget_show_all ((GtkWidget*) toolbar);
}

