#include <ug_message.h>
#include <ug_data_download.h>
#include <ug_dataset.h>
#include <ug_markup.h>
#include <ug_utils.h>

void test_conf ()
{
	UgMarkup*		markup;
	UgDataset*		dataset;
	UgProgress*		progress;
	UgDataHttp*		http;
	UgDataFtp*		ftp;

	markup		= ug_markup_new ();
	dataset		= ug_data_new (UgDatasetClass);
	progress	= ug_dataset_realloc (dataset, UgProgressClass, 0);
	http		= ug_dataset_realloc (dataset, UgDataHttpClass, 0);
	ftp			= ug_dataset_realloc (dataset, UgDataFtpClass, 0);

	progress->total = 1484889;
	http->redirection_limit = 10;
	http->referer	= g_strdup ("http://123.123.123.1/ref");
	ftp->user		= g_strdup ("ftpuser");
	ftp->password	= g_strdup ("ftppassword");

	ug_markup_output_start (markup, "test.ug.xml", TRUE);
	ug_data_to_markup ((UgData*) dataset, markup);
	ug_markup_output_end (markup);

	ug_data_free (dataset);

	dataset = ug_data_new (UgDatasetClass);
	if (ug_markup_input ("test.ug.xml", &ug_data_parser, dataset)) {
		progress	= ug_dataset_realloc (dataset, UgProgressClass, 0);
		http		= ug_dataset_realloc (dataset, UgDataHttpClass, 0);
		ftp			= ug_dataset_realloc (dataset, UgDataFtpClass, 0);
	}

	ug_data_free (dataset);
	ug_markup_free (markup);
}

int main (int argc, char* argv[])
{
	ug_global_init ();

	test_conf ();

	ug_global_finalize ();

	return 0;
}

