/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef UG_URL_H
#define UG_URL_H

#include <glib.h>
#include <ug_path.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
// URI : Uniform Resource Identifier (RFC3986)
// URL : Uniform Resource Locators
// UgUrlPart -----------------------------------------------------------
//
// ug_url_part ();
// scheme://user:password@host:port/directory/file?query#fragment
//    or
// scheme://user:password@host:port/directory/file_pri.file_ext?query#fragment
// scheme://user:password@host:port/directory/file_pri.file_ext?query#anchor

// ------------------------------------------------------------------
// Example:
//
// UgUrlPart* urlpart = ug_url_part_new (url_string, -1);
//
// host     = strndup (urlpart->host, urlpart->host_len);
// scheme   = strndup (urlpart->url,  urlpart->url_scheme_len);
// location = strndup (urlpart->url,  urlpart->url_location_len);
//
// if (urlpart->file_len == 0)
//     printf ("No filename");
//
// ug_url_part_free (urlpart);
// ------------------------------------------------------------------
 */

typedef struct UgUrlPart_		UgUrlPart;

struct UgUrlPart_ {
	UG_PATH_PART_MEMBERS;
//	const char*		path;
//	unsigned int	path_len;
//	unsigned int	path_drive_len;
//	const char*		folder;
//	unsigned int	folder_len;
//	const char*		file;
//	unsigned int	file_len;
//	unsigned int	file_pri_len;
//	const char*		file_ext;
//	unsigned int	file_ext_len;

	const char*		url;				// scheme
	unsigned int	url_len;
	unsigned int	url_location_len;	// length from scheme to folder.
	unsigned int	url_scheme_len;

//	const char*		authority;			// user + password + '@' + host + ':' + port
//	unsigned int	authority_len;

	const char*		user;
	unsigned int	user_len;

	const char*		password;
	unsigned int	password_len;

	const char*		host;
	unsigned int	host_len;

	const char*		port;
	unsigned int	port_len;

	// all members about path placed in head of struct (UG_PATH_PART_MEMBERS).
	// see UgPathPart at ug_path.h

	const char*		query;
	unsigned int	query_len;

	const char*		fragment;		// anchor
	unsigned int	fragment_len;	// anchor_len
};

/*  If url_len == -1, url is null-terminated. */
UgUrlPart*	ug_url_part_new (const char* url, int url_len);
void		ug_url_part_free (UgUrlPart* url_part);

/* Return TRUE if url has scheme & host, otherwise return FALSE. */
/*  If url_len == -1, url is null-terminated. */
int			ug_url_part (UgUrlPart* url_part, const char* url, int url_len);

/* unescape a escaped string and convert it to utf8. */
/* If str_len == -1, str is null-terminated. */
/* Returns a newly-created string. This string should be freed with g_free () */
char*		ug_url_unescape_to_utf8 (const char* str, int str_len);

#ifdef __cplusplus
}
#endif

#endif  /* UG_URL_H */

