/* Ubuntulooks Theme Engine
 * Copyright (C) 2005 Richard Stellingwerff.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Written by Owen Taylor <otaylor@redhat.com>
 * and by Alexander Larsson <alexl@redhat.com>
 * Modified by Richard Stellingwerff <remenic@gmail.com>
 * Modified by Kulyk Nazar <schamane@myeburg.net>
 */

#include <gtk/gtkrc.h>

typedef struct _UbuntulooksRcStyle UbuntulooksRcStyle;
typedef struct _UbuntulooksRcStyleClass UbuntulooksRcStyleClass;

extern GType ubuntulooks_type_rc_style;

#define UBUNTULOOKS_TYPE_RC_STYLE              ubuntulooks_type_rc_style
#define UBUNTULOOKS_RC_STYLE(object)           (G_TYPE_CHECK_INSTANCE_CAST ((object), UBUNTULOOKS_TYPE_RC_STYLE, UbuntulooksRcStyle))
#define UBUNTULOOKS_RC_STYLE_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), UBUNTULOOKS_TYPE_RC_STYLE, UbuntulooksRcStyleClass))
#define UBUNTULOOKS_IS_RC_STYLE(object)        (G_TYPE_CHECK_INSTANCE_TYPE ((object), UBUNTULOOKS_TYPE_RC_STYLE))
#define UBUNTULOOKS_IS_RC_STYLE_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), UBUNTULOOKS_TYPE_RC_STYLE))
#define UBUNTULOOKS_RC_STYLE_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), UBUNTULOOKS_TYPE_RC_STYLE, UbuntulooksRcStyleClass))

struct _UbuntulooksRcStyle
{
  GtkRcStyle parent_instance;

  GdkColor scrollbar_color;
  gboolean has_scrollbar_color;
  double contrast;
  guint8 sunkenmenubar;
  guint8 progressbarstyle;
  guint8 menubarstyle;
  guint8 menuitemstyle;
  guint8 listviewitemstyle;
  guint8 scrollbarstyle;
  gboolean animation;
  gboolean gdm;
};

struct _UbuntulooksRcStyleClass
{
  GtkRcStyleClass parent_class;
};

void ubuntulooks_rc_style_register_type (GTypeModule *module);
