//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef _RENDERER_H_
#define _RENDERER_H_
#ifndef DOXYGEN_NOTFOR_DEVEL

#include "Fonts.h"

namespace tlp {

class Renderer : public Fonts {
public:
  virtual ~Renderer() {}
  virtual void translate(float x, float y, float z) const =0;
  virtual void setColor(unsigned char r, unsigned char v, unsigned char b) const =0;
  virtual void drawLine(float x1, float y1, float z1, float x2, float y2, float z2) const =0;
  void setMode(FontMode  m);
  FontMode getMode();
  void setDepth(float p);
  float getDepth();

 protected:  
  FontMode mode;
  float depth;
};

}
#endif //DOXYGEN_NOTFOR_DEVEL
#endif
