//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef EPSFUNCTION
#define EPSFUNCTION
#ifndef DOXYGEN_NOTFOR_DEVEL
//====================================================
#include <stdio.h>
#include <tulip/Color.h>
#if defined(__APPLE__)
#include <OpenGL/gl.h>
#else
#include <GL/gl.h>
#endif

namespace tlp {

void Line(float x1,float y1,float z1,float x2, float y2 ,  float z2, Color C1, Color C2);
void Rect(float x, float y , float z, float w , float h);
GLfloat *spewPrimitiveEPS(FILE * file, GLfloat * loc);
void spewUnsortedFeedback(FILE * file, GLint size, GLfloat * buffer);
int compare(const void *a, const void *b);
void spewSortedFeedback(FILE * file, GLint size, GLfloat * buffer);
void spewWireFrameEPS(FILE * file, int doSort, GLint size, GLfloat * buffer, char *creator);
void print3DcolorVertex(GLint size, GLint * count, GLfloat * buffer);
void printBuffer(GLint size, GLfloat * buffer);

}
#endif //DOXYGEN_NOTFOR_DEVEL
#endif
