import os
import logging

from os import path
from shutil import rmtree
from tempfile import mkdtemp

from trac import config
from bzrlib import bzrdir, tests

from tracbzr import backend


class DummyComponent(object):

    def __init__(self):
        self.log = logging.getLogger('tracbzr.tests')
        self.log.setLevel(logging.ERROR)
        self.config = config.Configuration(None)


class MultiBranchTracTestCase(tests.TestCase):

    def setUp(self):
        super(MultiBranchTracTestCase, self).setUp()
        self.root = mkdtemp(prefix='trac+bzr-')
        self.old_cwd = os.getcwd()
        os.chdir(self.root)
        self.repo_root = path.join(self.root, 'repo')
        os.mkdir(self.repo_root)
        dir = bzrdir.BzrDir.create(self.repo_root)
        self.repo = dir.create_repository()
        self.treedir = path.join(self.repo_root, 'tree')
        self.branch = bzrdir.BzrDir.create_branch_convenience(self.treedir,
            force_new_tree=True)
        self.tree = self.branch.bzrdir.open_workingtree()

    def trac_repo(self):
        return backend.BzrRepository(self.repo_root, DummyComponent())

    def tearDown(self):
        super(MultiBranchTracTestCase, self).tearDown()
        os.chdir(self.old_cwd)
        rmtree(self.root)


class SingleBranchTracTestCase(tests.TestCase):

    def setUp(self):
        super(SingleBranchTracTestCase, self).setUp()
        self.root = mkdtemp(prefix='trac+bzr-')
        self.old_cwd = os.getcwd()
        os.chdir(self.root)
        branch = bzrdir.BzrDir.create_branch_convenience(self.root, 
                        force_new_tree=True)
        self.tree = branch.bzrdir.open_workingtree()
        self.repo = branch.repository
        self.treedir = self.root

    def trac_repo(self):
        return backend.BzrRepository(self.root, DummyComponent())

    def tearDown(self):
        super(SingleBranchTracTestCase, self).tearDown()
        os.chdir(self.old_cwd)
        rmtree(self.root)
