#!$AWK -f
# tla-log-to-cvs-log -- Make an arch log suitable for use with CVS
#
#  Copyright (C) 2003  Miles Bader <miles@gnu.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Written by Miles Bader <miles@gnu.org>

BEGIN { hdrs = 1 }

hdrs && /^Archive:/  { archive = $2; next }
hdrs && /^Revision:/ { revision = $2; next }
hdrs && /^Creator:/  { creator = $0; sub (/^Creator: */, "", creator); next }
hdrs && /^Summary:/  { summary = $0; sub (/^Summary: */, "", summary); next }

hdrs && /^$/ {
  hdrs = 0

  print "Revision: " archive "/" revision

  # In a cheap attempt at conciseness, we do not record the creator
  # field if its username happens to be same as the person doing the
  # CVS commit
  user = creator
  sub (/ *\(.*\) */, "", user)
  sub (/.*</, "", user)
  sub (/>.*/, "", user)
  sub (/@.*/, "", user)
  if (user != ENVIRON["USER"])
    print "Creator:  " creator

  if (summary) {
    print
    print summary
    blank = 1
  }

  next
}

hdrs { next }

# We suppress multiple and trailing blank linkes
/^ *$/ { blank = 1; next }

{
  # Also suppress the first body line if it is the same as the summary
  if (! printed_first_body_line) {
    printed_first_body_line = 1
    if ($0 == summary)
      next
  }

  # print any pending blank line
  if (blank) {
    blank = 0
    print ""
  }

  print
}

# arch-tag: fa2731b8-73f5-4bde-8b0f-64823177d578
