/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *	This file is part of the Tiny Look and Feel                                *
 *  Copyright 2003 - 2008  Hans Bickel                                         *
 *                                                                             *
 *  For licensing information and credits, please refer to the                 *
 *  comment in file de.muntjak.tinylookandfeel.TinyLookAndFeel                 *
 *                                                                             *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

package de.muntjak.tinylookandfeel.controlpanel;

import java.awt.Component;

import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;


/**
 * Renders the icon column of the example table.
 * @author Hans Bickel
 */
public class IconRenderer extends DefaultTableCellRenderer {
	
	public IconRenderer() {
		setHorizontalAlignment(SwingConstants.CENTER);
	}
	
	public void setValue(Object value) {
		setIcon((value instanceof Icon) ? (Icon)value : null);
	}
}