#include "TintApp.hpp"

#include "TintAbout.hpp"
#include "../reg/Components.hpp"
#include "../FileImageResource.hpp"
#include "../../../nuvola/nuvola.hpp"
#include "../../images/tint.hpp"

#ifdef __WXMSW__
#include "omp.h"
#endif

using namespace indii::tint;
using namespace indii::tint::gui;
using namespace indii::tint::reg;

IMPLEMENT_APP(TintApp)

void TintApp::MacOpenFile(const wxString &file) {
  wxBeginBusyCursor();
  TintWindow* main = new TintWindow(NULL, file, TintWindow::STANDALONE, this);
  main->Centre();
  main->Show();
  wxEndBusyCursor();
  windows.insert(main);
}

bool TintApp::OnInit() {
  bool result = wxApp::OnInit(); // for command line parsing
  if (result) {
    #ifdef __WXMAC__
    /* permanent menu for Mac */
    wxApp::SetExitOnFrameDelete(false);
    wxMenuBar* mbMenu = new wxMenuBar();
    
    wxMenu* mnFile = new wxMenu();
    mnFile->Append(wxID_OPEN);
    mnFile->Append(wxID_EXIT);  // moved to program menu
    mnFile->Append(wxID_ABOUT); // is moved to program menu

    wxMenu* mnView = new wxMenu();
    mnView->Append(ID_BUT_SPLASH, _("Splash"));

    mbMenu->Append(mnFile, _("File"));
    mbMenu->Append(mnView, _("View"));
      
    wxMenuBar::MacSetCommonMenuBar(mbMenu);
    #endif
    
    splash = new TintSplash();
    splash->CentreOnScreen();
    splash->Show(true);
    SetTopWindow(splash);
    
    dlgRegister = new TintRegistration(splash);
    dlgRegister->Centre();
  }
  
  return result;  
}

void TintApp::OnInitCmdLine(wxCmdLineParser& parser) {
  wxApp::OnInitCmdLine(parser);

  //parser.AddParam(_("path"), wxCMD_LINE_VAL_STRING);
}

bool TintApp::OnCmdLineParsed(wxCmdLineParser& parser) {
  if (wxApp::OnCmdLineParsed(parser)) {
    /* initialise images */
    wxInitAllImageHandlers();
    nuvola_initialize_images();
    tint_initialize_images();

    //res = new FileImageResource(parser.GetParam());
    //model = new ClusterModel(res);

    return true;
  } else {
    return false;
  }
}

int TintApp::OnExit() {
  return wxApp::OnExit();
}

void TintApp::OnButtonOpen(wxCommandEvent& evt) {
  wxString path = wxFileSelector(wxEmptyString,
      wxEmptyString, wxEmptyString, wxEmptyString, _("Image Files ") +
      wxImage::GetImageExtWildcard() + _("|All files (*)|*"),
      wxFD_OPEN|wxFD_CHANGE_DIR|wxFD_FILE_MUST_EXIST|wxFD_PREVIEW, NULL);
  if (!path.empty()) {
    wxBeginBusyCursor();
    TintWindow* main = new TintWindow(NULL, path, TintWindow::STANDALONE,
        this);
    main->Centre();
    main->Show();
    wxEndBusyCursor();
    windows.insert(main);
  }
}

void TintApp::OnButtonExit(wxCommandEvent& evt) {
  std::set<TintWindow*>::iterator iter;
  std::set<TintWindow*> tmp(windows);
  int ret;
  bool vetoed = false;
    
  /* raise saved images */
  for (iter = windows.begin(); iter != windows.end(); ++iter) {
    if ((*iter)->IsSaved()) {
      (*iter)->Raise();
    }
  }
  
  /* raise unsaved images and count */
  int unsaved = 0;
  for (iter = windows.begin(); iter != windows.end(); ++iter) {
    if (!(*iter)->IsSaved()) {
      (*iter)->Raise();
      ++unsaved;
    }
  }

  /* prompt about unsaved changes as appropriate */
  if (unsaved > 1) {
    ret = wxMessageBox(_("If you don't review your images, all your "
        "changes will be lost."), wxString(_("You have ")) << unsaved <<
        wxString(_(" images with unsaved changes. Do you want to review "
        "these changes before quitting?")),
        wxYES_NO|wxCANCEL|wxICON_QUESTION);
  } else {
    ret = wxYES;
  }

  if (ret == wxYES) {
    /* save images */
    for (iter = tmp.begin(); iter != tmp.end() && !vetoed; ++iter) {
      if (!(*iter)->IsSaved()) {
        (*iter)->Raise();
        ret = wxMessageBox(_("Save changes to image before closing?"),
            _("Save changes?"), wxYES_NO|wxCANCEL|wxICON_QUESTION, *iter);
        if (ret == wxYES) {
          (*iter)->OnButtonSave(evt);
          if (!(*iter)->IsSaved()) {
            vetoed = true;
          }
        } else if (ret == wxCANCEL) {
          vetoed = true;
        }
      }
    }
      
    if (!vetoed) {
      /* need to destroy windows rather than just close here, seems event
       * loop might terminate immediately after this function on wxMac? */
      
      /* close splash */
      if (splash != NULL) {
        splash->Destroy();
      }
      
      /* close windows one-by-one */
      for (iter = tmp.begin(); iter != tmp.end(); ++iter) {
        (*iter)->Destroy();
      }

      /* exit */
      wxExit();
    }
  }
}

void TintApp::OnButtonRegister(wxCommandEvent& evt) {
  dlgRegister->ShowModal();
}

void TintApp::OnButtonAbout(wxCommandEvent& evt) {
  showAboutDialog();
}

void TintApp::OnButtonSplash(wxCommandEvent& evt) {
  if (splash != NULL) {
    splash->Show(true);
    splash->Raise();
  }
}

void TintApp::notifySplashClose(TintSplash* splash) {
  splash = NULL;
}

void TintApp::notifyClose(TintWindow* window) {
  windows.erase(window);
}

BEGIN_EVENT_TABLE(TintApp, wxApp)
EVT_MENU(wxID_OPEN, TintApp::OnButtonOpen)
EVT_MENU(wxID_EXIT, TintApp::OnButtonExit)
EVT_MENU(ID_BUT_REGISTER, TintApp::OnButtonRegister)
EVT_MENU(ID_BUT_SPLASH, TintApp::OnButtonSplash)
EVT_MENU(wxID_ABOUT, TintApp::OnButtonAbout)
END_EVENT_TABLE()
