#ifndef INDII_TINT_GUI_PREPROCESSPANE_HPP
#define INDII_TINT_GUI_PREPROCESSPANE_HPP

#include "TintPane.hpp"
#include "../ClusterModel.hpp"
#include "../ClusterModelObserver.hpp"

#include "wx/spinctrl.h"
#include "wx/textctrl.h"

namespace indii {
  namespace tint {
    namespace gui {
/**
 * Preprocess settings pane.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * @version $Rev: 74 $
 * @date $Date: 2009-03-02 14:59:56 +0900 (Mon, 02 Mar 2009) $
 */
class PreProcessPane : public TintPane, public ClusterModelObserver {
public:
  /**
   * Constructor.
   *
   * @param parent Parent.
   * @param model Cluster model.
   */
  PreProcessPane(wxWindow* parent, ClusterModel* model);

  /*
   * Handle model changes.
   */
  virtual void notifyNumClustersChange();
  virtual void notifyNumRepetitionsChange();
  virtual void notifyMaxPixelsChange();
  virtual void notifySaturationThresholdChange();

  /*
   * Handle control events.
   */
  void OnSpinK(wxSpinEvent& evt);
  void OnSpinReps(wxSpinEvent& evt);
  void OnSpinSat(wxSpinEvent& evt);
  void OnTextMaxPixels(wxCommandEvent& evt);

private:
  /**
   * Cluster model.
   */
  ClusterModel* model;

  /*
   * Controls.
   */
  wxSpinCtrl *spinK, *spinReps, *spinSat;
  wxTextCtrl *textMaxPixels;

  /*
   * Control ids.
   */
  enum ID {
    ID_SPIN_K,
    ID_SPIN_REPS,
    ID_SPIN_SAT,
    ID_TEXT_MAX_PIXELS,
  };

  DECLARE_EVENT_TABLE()

};

    }
  }
}

#endif

