#include "ColourSpace.hpp"

using namespace indii::tint;
using namespace std;

ColourSpace::ColourSpace() {
  greyR = 0.299f;
  greyG = 0.587f;
  greyB = 0.114f;
}

void ColourSpace::setLightness(const float r, const float g,
    const float b) {
  /* pre-conditions */
  assert (r >= 0.0 && r <= 1.0);
  assert (g >= 0.0 && g <= 1.0);
  assert (b >= 0.0 && b <= 1.0);

  if (r > 0.0f || g > 0.0f || b > 0.0f) {
    float sum = r + g + b;
    greyR = r/sum;
    greyG = g/sum;
    greyB = b/sum;
  } else {
    /* limit, as if all equal */
    greyR = 1.0f/3.0f;
    greyG = 1.0f/3.0f;
    greyB = 1.0f/3.0f;
  }
}

