#ifndef INDII_TINT_CLUSTERMODELOBSERVER_HPP
#define INDII_TINT_CLUSTERMODELOBSERVER_HPP

#include "Observer.hpp"
#include "ClusterModel.hpp"

namespace indii {
  namespace tint {

/**
 * Observer of ClusterModel.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * @version $Rev: 93 $
 * @date $Date: 2009-08-02 18:40:29 +0800 (Sun, 02 Aug 2009) $
 */
class ClusterModelObserver : public Observer<ClusterModel> {
public:
  /**
   * Notify change specific to a single cluster.
   *
   * @param i The cluster.
   */
  virtual void notifyClusterChange(const unsigned i);

  /**
   * Notify change of hue rotation to a single cluster.
   *
   * @param i The cluster.
   */
  virtual void notifyHueChange(const unsigned i);

  /**
   * Notify change of saturation adjustent to a single cluster.
   *
   * @param i The cluster.
   */
  virtual void notifySatChange(const unsigned i);

  /**
   * Notify change of lightness adjustment to a single cluster.
   *
   * @param i The cluster.
   */
  virtual void notifyLightChange(const unsigned i);

  /**
   * Notify change in number of clusters.
   */
  virtual void notifyNumClustersChange();

  /**
   * Notify change in hard/soft cluster assignment.
   */
  virtual void notifyIsHardChange();

  /**
   * Notify change in number of repetitions.
   */
  virtual void notifyNumRepetitionsChange();

  /**
   * Notify change in saturation threshold.
   */
  virtual void notifySaturationThresholdChange();

  /**
   * Notify change in maximum pixels for clustering.
   */
  virtual void notifyMaxPixelsChange();

  /**
   * Notify change in saturation decay.
   */
  virtual void notifySaturationDecayChange();

  /**
   * Notify change in centroid decay.
   */
  virtual void notifyCentroidDecayChange();

  /**
   * Notify change in saturation softness.
   */
  virtual void notifySaturationSoftnessChange();

  /**
   * Notify change in centroid softness.
   */
  virtual void notifyCentroidSoftnessChange();

  /**
   * Notify change of greyscale parameters.
   */
  virtual void notifyGreyscaleChange();

};
 
  }
}

#endif

