#ifndef INDII_CLUSTER_EUCLIDEANDISTANCE_HPP
#define INDII_CLUSTER_EUCLIDEANDISTANCE_HPP

#include "ClusterVector.hpp"

namespace indii {
  namespace cluster {
/**
 * Euclidean distance.
 *
 * @tparam T Datum element type.
 */
template<class T = float>
class EuclideanDistance {
public:
  /**
   * Calculate distance.
   *
   * @param x1 First point.
   * @param x2 Second point, should have same size as first.
   *
   * @return %Distance between the two points.
   */
  static T distance(const typename ClusterVector<T>::type& x1,
      const typename ClusterVector<T>::type& x2);

};

  }
}

T indii::cluster::EuclideanDistance::distance(
    const typename ClusterVector<T>::type& x1,
    const typename ClusterVector<T>::type& x2) {
  /* pre-condition */
  assert (x1.size() == x2.size());

  return boost::numeric::ublas::norm_2(x2 - x1);
}

#endif
