package tijmp.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import tijmp.ProfilerHandler;
import tijmp.ui.Translator;

/** A class to show owners for all objects of a given class.
 */
public class ShowOwners extends AbstractAction {
    private ProfilerHandler ph;
    private Class<?> clz;

    public ShowOwners (ProfilerHandler ph, Class<?> clz) {
	super ("Show owners for all " + Translator.translate (clz, null));
	this.ph = ph;
	this.clz = clz;
    }

    public void actionPerformed (ActionEvent e) {
	ph.submitTask (new Runnable () {
		public void run () {
		    ph.showOwners (clz);
		}
	    });
    }    
}
