/*
function hgi(int MAX, double alpha, int n, double* x, int nx, double* p, double* q,
                    int np, int nq, double *s)

Computes s[i]= np F nq ^alpha(p,q,x[i]I_n) for i=1,2,...,nx and the summation bring
|kappa|<=MAX

by Plamen Koev May 2004

*/


#include <stdio.h>
#include <stdlib.h>
#include <memory.h>

typedef struct {
     double alpha, *x, *p, *q, *s, *z;
     int n, np, nq, nx, MAX, *l, *lc;
} glob;


void
summation(int i, int ms, glob* a)
{
  int j,m,ii;
  double zn,dn,c,d,e,f,g;

  m=ms;
  if (i>1) if ((*a).l[i-1]<m) m=(*a).l[i-1];
  for (ii=1;ii<m+1;ii++) {
     (*a).l[i]=ii;
     (*a).lc[ii]+=1;        /* update conjugate partition */

     dn=1;
	 zn=1;
     c=-(i-1)/(*a).alpha+(*a).l[i]-1;
     for (j=0;j<(*a).np;j++)  zn*=(*a).p[j]+c;
     for (j=0;j<(*a).nq;j++)  dn*=(*a).q[j]+c;

     d=(*a).l[i]*(*a).alpha-i;             /* update j_lambda  */
     for (j=1;j<(*a).l[i];j++) {
        e=d-j*(*a).alpha+(*a).lc[j];
        g=e+1;
        zn*=(g-(*a).alpha)*e;
        dn*=g*(e+(*a).alpha);
     }
     for (j=1;j<i;j++) {
        f=(*a).l[j]*(*a).alpha-j-d;
        g=f+(*a).alpha;
        e=f*g;
        zn*=e-f;
        dn*=g+e;
     }
	 zn*=((*a).n+(*a).alpha*c)/dn;
	 for (j=0;j<(*a).nx;j++) {
	    (*a).z[i*(*a).nx+j]*=(*a).x[j] * zn;
        (*a).s[j]+=(*a).z[i*(*a).nx+j];
	 }
	 if ((ms>ii)&&(i<(*a).n)) {
		 memcpy((*a).z+(i+1)*(*a).nx,(*a).z+i*(*a).nx,(*a).nx * sizeof(double));
		 summation(i+1,ms-ii,a);
	 }
  }

  (*a).l[i]=0;
  for (ii=1;ii<m+1;ii++)
      (*a).lc[ii]--;
}


void
hgi(int MAX, double alpha, int n, double* x, int nx, double* p, double* q,
    int np, int nq, double *s)
{
  int i;
  glob *a;

  a=(glob*)malloc(sizeof(glob));
  (*a).n=n;
  (*a).MAX=MAX;
  (*a).alpha=alpha;
  (*a).p = p;
  (*a).q = q;
  (*a).np = np;
  (*a).nq = nq;
  (*a).nx = nx;
  (*a).s=s;
  for (i=0;i<nx;i++)
      s[i]=1;
  (*a).x=x;

  (*a).l =(int*)malloc(sizeof(int)*(MAX+1));
  memset((*a).l,0,sizeof(int)*(MAX+1));
  (*a).lc =(int*)malloc(sizeof(int)*(MAX+1));
  memset((*a).lc,0,sizeof(int)*(MAX+1));
  (*a).z=(double*)malloc(sizeof(double)*(MAX+1)*nx);
  memcpy((*a).z+nx,(*a).s,sizeof(double)*nx);    /* set to 1 also */

  summation(1,MAX,a);

  free((*a).z);
  free((*a).lc);
  free((*a).l);
  free(a);
}

int main()
{
  double s[2];
  double x[10],p[5],q[5];
  int i;

  p[0]=0.1; p[1]=0.2;
  q[0]=0.3; q[1]=0.4;

  for (i=0;i<10;i++)
      x[i]=(1.0+i)/10.0;

  hgi(12,2,10,x,2,p,q,2,2,s);

  printf("hg = %E\n",s[0]);
  printf("hg = %E\n",s[1]);
  return(0);
}
