/*
 * This file is part of TelepathyQt4
 *
 * Copyright (C) 2009 Collabora Ltd. <http://www.collabora.co.uk/>
 * Copyright (C) 2009 Nokia Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <TelepathyQt4/Feature>

namespace Tp
{

struct TELEPATHY_QT4_NO_EXPORT Feature::Private : public QSharedData
{
    Private(bool critical) : critical(critical) {}

    bool critical;
};

Feature::Feature(const QString &className, uint id, bool critical)
    : QPair<QString, uint>(className, id),
      mPriv(new Private(critical))
{
}

Feature::Feature(const Feature &other)
    : QPair<QString, uint>(other.first, other.second),
      mPriv(other.mPriv)
{
}

Feature::~Feature()
{
}

Feature &Feature::operator=(const Feature &other)
{
    *this = other;
    this->mPriv = other.mPriv;
    return *this;
}

bool Feature::isCritical() const
{
    return mPriv->critical;
}

} // Tp
