/*-----------------------------------------------------------------------

                         SYRTHES version 3.4
                         -------------------

     This file is part of the SYRTHES Kernel, element of the
     thermal code SYRTHES.

     Copyright (C) 1988-2008 EDF S.A., France

     contact: syrthes-support@edf.fr


     The SYRTHES Kernel is free software; you can redistribute it
     and/or modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2 of
     the License, or (at your option) any later version.

     The SYRTHES Kernel is distributed in the hope that it will be
     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.


     You should have received a copy of the GNU General Public License
     along with the Code_Saturne Kernel; if not, write to the
     Free Software Foundation, Inc.,
     51 Franklin St, Fifth Floor,
     Boston, MA  02110-1301  USA

-----------------------------------------------------------------------*/
# include <stdio.h>
# include <stdlib.h>
# include <math.h>

# include "f2c_syrthes.h"
# include "tree.h"
# include "abs.h"
# include "interfaces.h"

int nelvoip;

/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | orie3d                                                               |
  |                                                                      |
  |======================================================================| */

void orie3d  (int *nodray, int nelray, int npoinr,
              int *nrfray, double *cooray, double *pinter,
              int numgu, int ndim, int nblblr,int *grconv)

{
     
    int *grconx, *norini, *ifabor ;
    int numg,i,ielem,nbmalo ;

    ifabor = (int *)malloc( nelray * 3 * sizeof(int));
    grconx = (int *)malloc( nelray * sizeof(int));
    if (ifabor==NULL || grconx==NULL) 
      {printf(" ERREUR orie3d : probleme d'allocation memoire\n");
       exit(0);}

    nbmalo = 0 ;


    voisic_3d(ifabor,nodray,nelray,npoinr,nblblr) ;

    connex_3d(ifabor,grconx,nelray,npoinr,&numg,numgu,nblblr) ;
     
    /* On stockera autant d'elements de depart que de surfaces connexes  trouves */
    norini = (int *)malloc( numg  * sizeof(int));
    if (norini==NULL) 
      {printf(" ERREUR orie3d : probleme d'allocation memoire\n");
       exit(0);}

    iniori_3d(ifabor,nodray,cooray,nrfray,grconx,nelray,npoinr,
	      pinter,&numg,ndim,norini,grconv,numgu,&nbmalo,nblblr) ;
    
    oriene_3d( ifabor, nodray, nelray, grconx, norini, &numg, &nbmalo,nblblr) ;
    

      /* 4- Post processing pour developpeur (IR,CP)
      ---------------------------------------------- */
      if ( nblblr > 10 ) 
      {
         for ( i=0; i < 3 * nelray; i++ ) 
         {
            if ( ifabor[i] != -1 )  ifabor[i] += 1 ;
         }
         printf("\n Table des elements colles aux faces de chaque element \n ") ;

         for ( ielem=0; ielem < nelray; ielem++ )
         {
            printf( " Element %d  :  %d %d %d \n", ielem+1,
                      ifabor[ielem] ,ifabor[ielem+ nelray] ,
                      ifabor[ielem+2* nelray] ) ;
         }
      }

    free(grconx) ;free(norini) ;
}



/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | voisic_3d                                                            |
  |                                                                      |
  |======================================================================| */
void voisic_3d(int *ifabor, int *nodray, int nelray, int npoinr, int nblblr)
{    
    int i,m1,m2;
    int i1,i2,imax,npmax;
    int iface,iface2,ielem,ielem2;
    int somfac[6];
    int *nvois,*iadr,*mat;

    somfac[0] = 0;
    somfac[1] = 1;
    somfac[2] = 1;
    somfac[3] = 2;
    somfac[4] = 2;
    somfac[5] = 0; 

    nvois = (int *)malloc( (npoinr) * sizeof(int));
    if (nvois==NULL) 
      {printf(" ERREUR voisic_3d : probleme d'allocation memoire\n");
       exit(0);}


    /* 1- INITIALISATION 
       ==================== */
    for (i=0; i < npoinr ; i++) *(nvois+i) = 2 ;

    for (iface=0; iface < 3 ; iface++) 
    {
       for ( ielem=0; ielem < nelray; ielem++ )
       {
           i1 = nodray[ielem + nelray*somfac[2*iface]];
           i2 = nodray[ielem + nelray*somfac[2*iface+1]];
           nvois[i1-1] += 1 ;
           nvois[i2-1] += 1 ;
       }
    }

    for (i=0; i < npoinr ; i++)  nvois[i] = nvois[i] / 2 ;

    nelvoip = 0;
    for (i=0; i< npoinr;i++) if (nelvoip < nvois[i] ) {nelvoip = nvois[i] ; npmax = i;}

    if (nblblr>=10)
      {
	printf("\n *** VOISIC_3D : Point ayant le plus d'elements attaches : %d\n",
	       npmax+1);
	printf("                 Nombre d'elements rattaches :             %d\n",
	       nelvoip-1);
      }

    iadr  = (int *)malloc( (npoinr) * sizeof(int));
    mat   = (int *)malloc( (npoinr) * 3*nelvoip * sizeof(int));
    if (iadr==NULL || mat==NULL) 
      {printf(" ERREUR voisic_3d : probleme d'allocation memoire\n");
       exit(0);}



    /* 2- Calcul des adresses de chaque point dans une structure
       de type matrice compacte    
       =========================================================  */
 
    iadr[0] = 0 ;
    for (i=1; i < npoinr ; i++)
    {
    iadr[i] = iadr[i-1] + nvois[i-1] ;
    }

    imax = iadr[npoinr-1] + nvois[npoinr-1] ;

    if ( imax > 3*nelvoip* npoinr ) 
      printf("\n Augmenter la taille memoire : voir developpeurs (CP,IR)\n");

    for (i=0; i < imax ; i++) *(mat+i) = 0 ;

    /* 3- BOUCLE SUR LES FACES DE CHAQUE ELEMENT :
    ===========================================    */
    for (iface=0; iface < 3 ; iface++) 
    {
       for ( ielem=0; ielem < nelray ; ielem++ )
       {
           ifabor[ielem+ nelray*iface] = -1 ;

           i1 = nodray[ielem+nelray*somfac[2*iface]];
           i2 = nodray[ielem+nelray*somfac[2*iface+1]];

           if ( i1 < i2 ) 
           {
              m1 = i1 ;
              m2 = i2 ;
           }
           else
           {
              m1 = i2 ;
              m2 = i1 ;
           }

           for ( i=1 ; i < nvois[m1-1]+1 ; i++ )
           {
             if ( mat[iadr[m1-1]+i-1] == 0 )
             {
                mat[iadr[m1-1]+i-1] = m2 ;
                mat[iadr[m1-1]+i-1+nelvoip*   npoinr] = ielem ;
                mat[iadr[m1-1]+i-1+2*nelvoip* npoinr] = iface ;
                goto sortie ;
             }
             else if  ( mat[iadr[m1-1]+i-1] == m2 )
             {
                ielem2 = mat[iadr[m1-1]+i-1+nelvoip* npoinr] ;
                iface2 = mat[iadr[m1-1]+i-1+2*nelvoip* npoinr] ;
                ifabor[ielem+nelray*iface]   = ielem2 ;
                ifabor[ielem2+nelray*iface2] = ielem  ;
                goto sortie ;
             }
           
           }  


           printf("\n -->  ERREUR VOISIC_3D : erreur dans le maillage\n");
           printf("                         il y a peut etre des points confondus \n") ;

           sortie : ;
           
       
       }  /* Fin de la boucle sur les elements */

    }  /* Fin de la boucle sur les faces */



      /* 4- Post processing pour developpeur (IR,CP)
      ---------------------------------------------- */
     if ( nblblr > 10 ) 
      {
         for ( i=0; i < 3 * nelray; i++ ) 
         {
           if ( ifabor[i] != -1 )  ifabor[i] += 1 ; 
         }
         printf(" VOISIC_3D : Table des elements colles aux faces de chaque element \n ") ;

         for ( ielem=0; ielem < nelray; ielem++ )
         {
            printf( " VOISIC_3D :Element %d  :  %d %d  %d\n", ielem+1,
                      ifabor[ielem] ,ifabor[ielem+ nelray],ifabor[ielem+ 2*nelray] ) ;
         }

         for ( i=0; i < 3 * nelray; i++ ) 
         {
           if ( ifabor[i] != -1 )  ifabor[i] -= 1 ; 
         }

      }


      free(nvois) ; free(mat) ; free(iadr) ;


}

/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | connex_3d                                                            |
  |                                                                      |
  |======================================================================| */
void connex_3d(int *ifabor,int *grconx,int nelray,int npoinr,
	       int *numg,int numgu, int nblblr) 
    
{

    int i,j;
    int iel1,iel2;

    for (i=0; i < nelray ; i++) *(grconx+i) = 0 ;


    *numg = 1 ;
    grconx[0] = *numg ;
    iel1=0;


    if (ifabor[iel1+2* nelray]+ifabor[iel1+nelray]+ifabor[iel1]==-3 )
    {
       printf("\n $$ ATTENTION CONNEX_3D : element %d isole \n" , iel1+1) ;
     }
    else
    {
      for (i=0; i <  3 ; i++ )
	{
	  iel2 = ifabor[iel1+i* nelray]  ;
          if (iel2==-1) continue;
	  if (grconx[iel2]!=0) continue ;
	  group_3d(iel1,iel2,nelray,grconx,ifabor,nblblr) ; 
	}
    }




    
    for (j=0; j <  nelray ; j++ )
    { 
       if ( grconx[j] == 0 )
       {
          if ( nblblr>10 ) 
	    printf(" *** CONNEX_3D : l'element %d n'appartient pas encore a un groupe\n", j+1) ;

          iel1 = j ;
          iel2 = -10 ;
          *numg += 1 ;
          grconx[j] = *numg ;

 	  if(ifabor[iel1+2* nelray]+ifabor[iel1+nelray]+ifabor[iel1]==-3)
	    {
	      printf("\n $$ ATTENTION CONNEX_3 : element %d isole \n" , iel1+1)  ;
	      continue ;
	    }
   
          for (i=0; i <  3 ; i++ )
          {
	    iel2 = ifabor[iel1+i* nelray] ;
	    if (iel2 ==-1) continue;
	    if (grconx[iel2]!=0) continue ;
	    group_3d( iel1,iel2,nelray,grconx,ifabor,nblblr ) ;
	  }

        }      /* Fin du test sur l'appartenance a un groupe */

     }         /* Fin de la boucle sur tous les elements */
   

      printf("\n *** CONNEX_3D : le maillage surfacique contient %d surfaces connexes et %d volumes connexes \n",*numg,numgu );

}


/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | group_3d                                                             |
  |                                                                      |
  |======================================================================| */
void group_3d(int iel1,int iel2,int nelray,int *grconx,int *ifabor, int nblblr)

{
    int i ;
    int ielv ;

    grconx[iel2] = grconx[iel1] ;

/*    printf(" dans group2 : iel1+1=%d iel2+1=%d \n",iel1+1,iel2+1); 
    printf(" grconx[iel1]+1 : %d",grconx[iel1]); */


    for (i=0; i <  3 ; i++ )
    {
      ielv = ifabor[iel2+i* nelray] ;
      if ( ielv != -1 && grconx[ielv] == 0)
      {
          group_3d( iel2,ielv,nelray,grconx,ifabor,nblblr) ;
      }
    }
}
    
/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | oriene_3d                                                            |
  |                                                                      |
  |======================================================================| */
void oriene_3d(int *ifabor, int *nodray, int nelray, 
              int *grconx, int *norini, int *numg, int* nbmalo, int nblblr)

{

    int i,i1,i2,iel1,iel2;
    int iface;
    int somfac[6];

    somfac[0] = 0;
    somfac[1] = 1;
    somfac[2] = 1;
    somfac[3] = 2;
    somfac[4] = 2;
    somfac[5] = 0; 


    for ( i=0 ; i < *numg ; i++ ) 
    {        
       iel1 = norini[i] ;

       for ( iface=0 ; iface < 3 ; iface++ )
       {
          i1 = nodray[iel1+ nelray * somfac[2*iface] ] ;
          i2 = nodray[iel1+ nelray * somfac[2*iface +1] ] ;
          iel2 = ifabor[iel1 + iface* nelray] ;
          if ( iel2 != -1 && grconx[iel2] > 0 )
          {
              rorien_3d( iel1,i1,i2,iel2,ifabor,grconx,nodray,nelray,
                      nbmalo,nblblr ) ;
          }
       }
     }

    printf("\n *** ORIENE_3D : le nombre de facettes reorientees est : %d \n",
			  *nbmalo);


}  


/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | rorien_3d                                                            |
  |                                                                      |
  |======================================================================| */
void rorien_3d(int iel1,int i1,int i2,int iel2,int *ifabor,int *grconx,
            int *nodray,int nelray, int *nbmalo, int nblblr)

{ 
     int j1,j2;
     int ielv,iface;
     int lmalo,nodaux,neleaux;
     int somfac[6];

     somfac[0] = 0;
     somfac[1] = 1;
     somfac[2] = 1;
     somfac[3] = 2;
     somfac[4] = 2;
     somfac[5] = 0; 

     lmalo = 0 ;

     for ( iface=0 ; iface < 3 ; iface++ )
     {
        j1 = nodray[iel2+ nelray * somfac[2*iface] ] ;
        j2 = nodray[iel2+ nelray * somfac[2*iface +1] ] ;
             
        if ( j1 == i1 && j2 == i2 )
        {
            lmalo = 1 ;
        }
      }

      if ( lmalo == 1 )
      {
          *nbmalo += 1 ;
          nodaux = nodray[iel2+ nelray * somfac[2] ] ;
          nodray[iel2+ nelray * somfac[2] ] = nodray[iel2+ nelray * somfac[3] ] ;  
          nodray[iel2+ nelray * somfac[3] ] = nodaux ;

          neleaux = ifabor[iel2] ;
          ifabor[iel2] = ifabor[iel2 + 2 * nelray ] ;
          ifabor[iel2 + 2 * nelray] = neleaux ;
        
          grconx[iel2] = - grconx[iel2] ;
          
          if (nblblr>10) printf("\n *** RORIEN_3D : la facette %d etait mal orientee \n",iel2+1 );
      }
      else
      {
          /* L'element etait deja bien oriente */
          grconx[iel2] = - grconx[iel2] ;     
      }     


     
     for ( iface=0 ; iface < 3 ; iface++ )
     {
        j1 = nodray[iel2+ nelray * somfac[2*iface] ] ;
        j2 = nodray[iel2+ nelray * somfac[2*iface +1] ] ;
             
        ielv = ifabor[iel2 + iface* nelray] ;
        if ( ielv != -1 && grconx[ielv] > 0 )
        {
           rorien_3d(iel1,j1,j2,ielv,ifabor,grconx,nodray,nelray,nbmalo,nblblr) ;      
        }
     }

}

/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | iniori_3d                                                            |
  |        Initialisation des processus recursifs                        |
  |======================================================================| */
void iniori_3d(int *ifabor,int *nodray,double *cooray,int *nrfray,
	       int *grconx,int nelray,int npoinr,
	       double *pvinter,int *numg,int ndim,int *norini,
	       int *grconv,int numgu,
	       int *nbmalo, int nblblr)

{

     int i,j,k,imin ;
     int n1,n2,n3 ;
     int iel,nodaux,neleaux ;
     int iv,pintok,dejaunpoint;
     double xint,yint,zint ;
     double dmin ;
     double x1,y1,z1,x2,y2,z2,x3,y3,z3 ;
     double x12,y12,z12,x13,y13,z13 ;
     double xnorelx,xnorely,xnorelz,xnormel ;
     double xvecgix,xvecgiy,xvecgiz,xnormve ;
     double xvec1ix,xvec1iy,xvec1iz ;
     double pscal ;
     double xxg,yyg,zzg;
     double dist;
     
     int *norinit, *npvint, *ncompteur ;
     double eps ;

     eps = 1e-6 ;

     norinit = (int *)malloc( *numg * numgu * sizeof(int) );
     npvint = (int *)malloc( *numg * sizeof(int) );
     ncompteur = (int *)malloc( *numg * sizeof(int) );
     if (norinit==NULL || npvint==NULL || ncompteur==NULL) 
       {printf(" ERREUR iniori_3d : probleme d'allocation memoire\n");
	exit(0);}

     for (i=0; i < nelray ; i++) *(grconv+i) = 0 ;
     for (i=0; i < *numg ; i++) *(npvint+i) = 0 ;
     for (i=0; i < *numg ; i++) *(ncompteur+i) = 0 ;
     for (i=0; i < *numg*numgu ; i++) *(norinit+i) = 0 ;

     if ( nblblr > 10 )
     {
        for ( i=0 ; i < nelray ; i++ ) printf(" INIORI_2D : Element , nrfray : %d   %d \n",i+1,nrfray[i] ) ;
	printf("\n");
        for ( i=0 ; i < nelray ; i++ ) printf(" INIORI_2D : Element , grconx : %d   %d \n",i+1,grconx[i] ) ;
	printf("\n");
        for ( i=0 ; i < npoinr ; i++ )
        {
           printf(" INIORI_2D : Noeud %d  x y z :   %f %f %f \n",i+1,cooray[i],cooray[i+npoinr],cooray[i+2* npoinr]) ;
        }
      }
      
     /* Boucle sur les surfaces connexes */
     for ( j=0 ; j < *numg ; j++ )
       {           
	 /* boucle sur les points volumiques internes */
	 for (iv=0;iv<numgu;iv++)
	      {
		xint = pvinter[3*iv] ;
		yint = pvinter[3*iv + 1] ;
		zint = pvinter[3*iv + 2] ;
		dmin = 1.E6 ;
		dist = 1.E+6 ;
		for ( i=0 ; i < nelray ; i++ )
		  {
		    if ( grconx[i]-1 == j )
		      {
			n1  = nodray[i]-1 ;          
			x1  = cooray[n1] ;
			y1  = cooray[n1+ npoinr] ;
			z1  = cooray[n1+2 * npoinr] ;
           
			n2  = nodray[i+ nelray]-1 ;          
			x2  = cooray[n2] ;
			y2  = cooray[n2+ npoinr] ;
			z2  = cooray[n2+2 * npoinr] ;

			n3  = nodray[i+ 2 * nelray]-1 ;          
			x3  = cooray[n3] ;
			y3  = cooray[n3+ npoinr] ;
			z3  = cooray[n3+2 * npoinr] ;

			xxg = (x1+x2+x3)/3.;
			yyg = (y1+y2+y3)/3.;
			zzg = (z1+z2+z3)/3.;
			/* On commence par se baser sur un test peu fiable 
			 la distance minimal G-PINT*/
			dist = (xxg-xint)*(xxg-xint)+(yyg-yint)*(yyg-yint)+(zzg-zint)*(zzg-zint);
			if (dist < dmin) {dmin = dist ; imin = i;}
		      }
		  }

		if (dist<eps*eps*1.1)
		  {printf("\n *** INIORI_2D : Point interne %d mal choisi : sur la facette %d \n",iv+1,imin+1);exit(0);}

		/* La facette potentielle que l'on va tester est imin */
		i=imin;
		n1  = nodray[i]-1 ;          
		x1  = cooray[n1] ;
		y1  = cooray[n1+ npoinr] ;
		z1  = cooray[n1+2 * npoinr] ;
           
		n2  = nodray[i+ nelray]-1 ;          
		x2  = cooray[n2] ;
		y2  = cooray[n2+ npoinr] ;
		z2  = cooray[n2+2 * npoinr] ;
		
		n3  = nodray[i+ 2 * nelray]-1 ;          
		x3  = cooray[n3] ;
		y3  = cooray[n3+ npoinr] ;
		z3  = cooray[n3+2 * npoinr] ;

		xxg = (x1+x2+x3)/3.;
		yyg = (y1+y2+y3)/3.;
		zzg = (z1+z2+z3)/3.;

		x12 = x2 - x1 ;
		y12 = y2 - y1 ;
		z12 = z2 - z1 ;

		x13 = x3 - x1 ;
		y13 = y3 - y1 ;
		z13 = z3 - z1 ;

		xnorelx =  y12*z13 - z12*y13 ;
		xnorely = -x12*z13 + z12*x13 ;
		xnorelz =  x12*y13 - y12*x13 ;
		xnormel = sqrt( xnorelx*xnorelx + xnorely*xnorely + xnorelz*xnorelz ) ;
		if ( xnormel > -eps && xnormel < eps )
		    { printf( "\n --> ERREUR INIORI_3D : l'element %d est vraisemblablement degenere\n", i+1 ) ; exit(0) ; }
		else
		  {
		    xnorelx = xnorelx / xnormel ;
		    xnorely = xnorely / xnormel ;
		    xnorelz = xnorelz / xnormel ;
		  }

		  xvecgix = xint - xxg ;
		  xvecgiy = yint - yyg ;
		  xvecgiz = zint - zzg ;
		  xnormve = sqrt( xvecgix*xvecgix + xvecgiy*xvecgiy + xvecgiz*xvecgiz ) ;
		  if ( xnormve > -eps && xnormve < eps )
		    {
		      printf("\n $$ ATTENTION INIORI_3D : le point interne %d \n",j+1);
                      printf("                           de coordonnees xc = %f , yc = %f , zc = %f \n",
			                                   xint,yint,zint);
		      printf("                           est mal choisi, car confondu avec le centre de gravite\n");

		      exit(0) ;
		    }
		  else
		    {
		      xvecgix = xvecgix / xnormve ;
		      xvecgiy = xvecgiy / xnormve ;
		      xvecgiz = xvecgiz / xnormve ;
		    }

		  pscal = xnorelx*xvecgix + xnorely*xvecgiy + xnorelz*xvecgiz ;
		  if ( pscal > -eps && pscal < eps )
		    {
		      printf("\n  $$ ATTENTION INIORI_3D : le point interne %d \n",j+1);
                      printf("                           de coordonnees xc = %f , yc = %f , zc = %f \n",
			                                   xint,yint,zint);
		      printf("                           est mal choisi, car dans le plan de la facette %d\n",i);
		      exit(0) ;
		    }
		  
		/* Verification  de non recoupage  de la surface connexe j */
		xvecgix = xvecgix * xnormve ;
		xvecgiy = xvecgiy * xnormve ;
		xvecgiz = xvecgiz * xnormve ;
		for ( k=0;k<nelray;k++ )
		  {
		    if ( grconx[k]-1 == j && k!=i )  
		      {
			n1  = nodray[k]-1 ;          
			x1  = cooray[n1] ;
			y1  = cooray[n1+ npoinr] ;
			z1  = cooray[n1+2 * npoinr] ;
			
			n2  = nodray[k+ nelray]-1 ;          
			x2  = cooray[n2] ;
			y2  = cooray[n2+ npoinr] ;
			z2  = cooray[n2+2 * npoinr] ;
			
			n3  = nodray[k+ 2 * nelray]-1 ;          
			x3  = cooray[n3] ;
			y3  = cooray[n3+ npoinr] ;
			z3  = cooray[n3+2 * npoinr] ;

			if (racines_3d(x1,y1,z1,x2,y2,z2,x3,y3,z3,xvecgix,xvecgiy,xvecgiz,xxg,yyg,zzg,k))
			  {printf("\n *** INIORI_3D : Il y a une ambiguite --> changer la position du point %d \n",iv+1); exit(0);}
		      }
		  }

      		/* Stockage de tous les elements correspondants au couple iv et surface connexe j */
		norinit[iv +j*numgu] = imin ;
		if (nblblr > 10 ) {for (k=0;k<*numg*numgu;k++) printf (" INIORI_3D : norinit[ %d ] = %d \n",k+1,norinit[k]+1);}
		
	      }
       }

  if (nblblr>10)
    for (iv=0;iv<numgu;iv++)
      for ( j=0;j<*numg ; j++ )
	printf(" INIORI_3D : composante connexe %d , face initiale %d pour le noeud volumique %d  \n", j+1,norinit[ iv +j* numgu]+1,iv+1);
  

/* Determination du point interieur iv qui convient a la surface connexe j
   Recoupage pair des autres surfaces connexes necessaire
   */
  for ( j=0 ; j < *numg ; j++ )
    {	  
      dejaunpoint = 0;
      for (iv=0;iv<numgu;iv++)
	{
	  xint = pvinter[3*iv] ;
	  yint = pvinter[3*iv + 1] ;
	  zint = pvinter[3*iv + 2] ;
	  for (i=0; i<*numg; i++) ncompteur[i]=0;
	  iel = norinit[iv + j* numgu] ;
	  
	  n1  = nodray[iel]-1 ;          
	  x1  = cooray[n1] ;
	  y1  = cooray[n1+ npoinr] ;
	  z1  = cooray[n1+2 * npoinr] ;
	  
	  n2  = nodray[iel+ nelray]-1 ;          
	  x2  = cooray[n2] ;
	  y2  = cooray[n2+ npoinr] ;
	  z2  = cooray[n2+2 * npoinr] ;
	  
	  n3  = nodray[iel+ 2 * nelray]-1 ;          
	  x3  = cooray[n3] ;
	  y3  = cooray[n3+ npoinr] ;
	  z3  = cooray[n3+2 * npoinr] ;
	  
	  xxg = (x1+x2+x3)/3.;
	  yyg = (y1+y2+y3)/3.;
	  zzg = (z1+z2+z3)/3.;
	  
	  xvecgix = xint - xxg ;
	  xvecgiy = yint - yyg ;
	  xvecgiz = zint - zzg ;
	  
	  if (nblblr>10)  printf(" *** INIORI_3D : composante connexe j = %d noeud interieur iv = %d \n",j+1,iv+1);
	  for ( k=0;k<nelray;k++ )
	    {
	      if ( grconx[k]-1 != j )
		{
		  if (nblblr>10) printf(" comp conex %d    facette testee k = %d \n",j+1,k+1); 
		  n1  = nodray[k]-1 ;          
		  x1  = cooray[n1] ;
		  y1  = cooray[n1+ npoinr] ;
		  z1  = cooray[n1+2 * npoinr] ;
		  
		  n2  = nodray[k+ nelray]-1 ;          
		  x2  = cooray[n2] ;
		  y2  = cooray[n2+ npoinr] ;
		  z2  = cooray[n2+2 * npoinr] ;
		  
		  n3  = nodray[k+ 2 * nelray]-1 ;          
		  x3  = cooray[n3] ;
		  y3  = cooray[n3+ npoinr] ;
		  z3  = cooray[n3+2 * npoinr] ;
		  if (racines_3d(x1,y1,z1,x2,y2,z2,x3,y3,z3,xvecgix,xvecgiy,xvecgiz,xxg,yyg,zzg,k))
		    {
		      if (nblblr > 10 )  printf(" *** INIORI_3D : Intersection avec une autre surface connexe (face %d) composante connexe %d \n", k+1,grconx[k]);
		      ncompteur[grconx[k]-1] += 1;
		    }

		}
	      
	      
	    }
      
       if (nblblr>10) printf(" *** INIORI_3D : composante connexe j = %d noeud interieur iv = %d \n",j+1,iv+1);
       if (nblblr>10) {for (i=0;i<*numg;i++) printf( " INIORI_3D : ncompteur[ %d ] = %d \n",i+1,ncompteur[i]);}

      pintok =1;
      /* Flag des intersections impaires */
      for (i=0; i<*numg;i++)
	{
	  if ((ncompteur[i]/2)*2-ncompteur[i]!=0)
	    pintok = 0;
	}
      if (pintok == 0)
	{if (nblblr>10) printf( " *** INIORI_3D : le point interieur %d non ok pour la surface connexe j %d \n",iv+1,j+1);}
      else
	{ if (dejaunpoint==1)
	    {
	      printf("\n *** INIORI_3D : Ce volume est :\n");
	      printf("                   soit deja defini par un point precedent \n");
	      printf("                   soit une ambiguite existe sur le volume ---> a verifier tres soigneusement \n" );
	      printf("                   --> essayer de modifier la position du noeud interieur %d \n",iv+1);
	      exit(0);
	    }
	else	  
	  {norini[j] = iel;npvint[j]=iv;dejaunpoint=1;}
	}
    }
  
      if (dejaunpoint==0 ) 
	{
	  printf("\n *** INIORI_3D : Il y a un probleme pour la surface connexe j= %d\n" ,j+1);
	  printf("                   Aucun des points fournis par l'utilisateur  ne permet de la definir \n");
	  printf("                   Verifier bien que tous les volumes independants ont ete definis par un point \n");
	  exit(0);
	}
      
    }

  if (nblblr>=10)
    {for (i=0;i<*numg;i++) printf(" *** INIORI_3D : Composante connexe %d  face de depart %d point interieur %d \n",
				  i+1,norini[i]+1,npvint[i]+1);}
  



     /* Traitement proprement dit */
       for ( j= 0 ; j < *numg ; j++ )
       { 
            xint = pvinter[3*npvint[j]] ;
            yint = pvinter[3*npvint[j] + 1] ;
	    zint = pvinter[3*npvint[j] + 2] ;

            iel = norini[j] ;

	    n1  = nodray[iel]-1 ;          
	    x1  = cooray[n1] ;
	    y1  = cooray[n1+ npoinr] ;
	    z1  = cooray[n1+2 * npoinr] ;
	    
	    n2  = nodray[iel+ nelray]-1 ;          
	    x2  = cooray[n2] ;
	    y2  = cooray[n2+ npoinr] ;
	    z2  = cooray[n2+2 * npoinr] ;
	    
	    n3  = nodray[iel+ 2 * nelray]-1 ;          
	    x3  = cooray[n3] ;
	    y3  = cooray[n3+ npoinr] ;
	    z3  = cooray[n3+2 * npoinr] ;
	    
	    x12 = x2 - x1 ;
	    y12 = y2 - y1 ;
	    z12 = z2 - z1 ;
	    
	    x13 = x3 - x1 ;
	    y13 = y3 - y1 ;
	    z13 = z3 - z1 ;
	    
	    xnorelx =  y12*z13 - z12*y13 ;
	    xnorely = -x12*z13 + z12*x13 ;
	    xnorelz =  x12*y13 - y12*x13 ;
	    
	    xnormel = sqrt( xnorelx*xnorelx + xnorely*xnorely + xnorelz*xnorelz ) ;
	    if ( xnormel > -eps && xnormel < eps )
	      {
		printf( "\n --> ERREUR INIORI_3D : l'element %d est vraisemblablement degenere\n",
		       iel+1 ) ;
		exit(0) ;
	      }
	    else
	      {
		xnorelx = xnorelx / xnormel ;
		xnorely = xnorely / xnormel ;
		xnorelz = xnorelz / xnormel ;
	      }
	    
	    
	    xvec1ix = xint - x1 ;
	    xvec1iy = yint - y1 ;
	    xvec1iz = zint - z1 ;
	    xnormve = sqrt( xvec1ix*xvec1ix + xvec1iy*xvec1iy + xvec1iz*xvec1iz ) ;
	    if ( xnormve > -eps && xnormve < eps )
           {
	     printf("\n  --> ERREUR INIORI_3D : le point interne %d \n",j+1);
	     printf("                           de coordonnees xc = %f , yc = %f , zc = %f \n",
		    xint,yint,zint);
	     printf("                           est mal choisi, car confondu avec le noeud %d\n",n1);
	     exit(0) ;
           }
	    else
	      {
		xvec1ix = xvec1ix / xnormve ;
		xvec1iy = xvec1iy / xnormve ;
		xvec1iz = xvec1iz / xnormve ;
	      }
	    
           pscal = xnorelx*xvec1ix + xnorely*xvec1iy + xnorelz*xvec1iz ;
	    if ( pscal > -eps && pscal < eps )
	      {
	     printf("\n --> ERREUR INIORI_3D : le point interne %d \n",j+1);
	     printf("                          de coordonnees xc = %f , yc = %f , zc = %f \n",
		    xint,yint,zint);
	     printf("                          est mal choisi, car  dans l'alignelement de la facette %d\n",iel);
	     exit(0) ;
           }
	    
	    if ( pscal < -eps )
           {
	     
	     nodaux = nodray[iel+ nelray ] ;
	     nodray[iel+ nelray ] = nodray[iel+ nelray * 2 ] ;  
	     nodray[iel+ nelray * 2 ] = nodaux ;
	     
	     neleaux = ifabor[iel] ;
	     ifabor[iel] = ifabor[iel + 2 * nelray ] ;
	     ifabor[iel + 2 * nelray] = neleaux ;
	     
	     *nbmalo += 1 ;
	     if ( nblblr == 11 ) printf( " INIORI_3D : la facette initiale %d etait mal orientee \n",
					iel+1 ) ;
	     
           }
	  }
     
     /* Volumes connexes */
     for (j=0;j<*numg;j++)
       {
	 for (k=0;k<nelray;k++)
	   {
	     if( grconx[k]-1==j) grconv[k] =  npvint[j];
	   }
       }
     
     if (nblblr>10) {for ( i=0 ; i < nelray ; i++ ) printf(" INIORI_3D : element , grconv : %d   %d \n",i,grconv[i] ) ;}
     
     free(norinit);free(npvint);free(ncompteur) ; 
     
     
}
           

/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | racines_3d                                                           |
  |        Calcul de la racine eventuelle entre la facette consideree    |
  |        et le vecteur xvec,yvec,zvec                                  |
  |        Si l'intersection n'est pas dans le triangle on met 1e6       |
  |        sur chaque composante                                         |
  |======================================================================| */
int racines_3d(double x1,double y1,double z1,
	     double x2,double y2,double z2,double x3,double y3,double z3,
	     double xvec,double yvec,double zvec,
	     double xxg,double yyg,double zzg,int iel)
{
  int ii;
  double eps;
  double denom,numer,alfa,d,xp,yp,zp;
  double x12,y12,z12,x13,y13,z13;
  double xnorelx,xnorely,xnorelz,xnormel;



  eps = 1.e-8; alfa = 1.e6;

  x12 = x2 - x1 ;
  y12 = y2 - y1 ;
  z12 = z2 - z1 ;

  x13 = x3 - x1 ;
  y13 = y3 - y1 ;
  z13 = z3 - z1 ;

  xnorelx =  y12*z13 - z12*y13 ;
  xnorely = -x12*z13 + z12*x13 ;
  xnorelz =  x12*y13 - y12*x13 ;
  xnormel = sqrt( xnorelx*xnorelx + xnorely*xnorely + xnorelz*xnorelz ) ;
  if ( xnormel > -eps && xnormel < eps )
    {
      printf("\n --> ERREUR RACINES_3D : l'element %d est vraisemblablement degenere\n",iel+1 ) ;
      exit(0) ;
    }
  else
    {
      xnorelx = xnorelx / xnormel ;
      xnorely = xnorely / xnormel ;
      xnorelz = xnorelz / xnormel ;
    }

  d = -x1*xnorelx-y1*xnorely-z1*xnorelz;

  denom = xnorelx*xvec+xnorely*yvec+xnorelz*zvec;
  if ( abs(denom) > eps ) 
    {
      numer = - ( xnorelx*xxg +  xnorely*yyg + xnorelz*zzg + d);
      alfa  = numer/denom;
    }

  if ((0.<alfa) && (alfa < 1.))
    {
      xp = xxg+alfa*xvec;  yp = yyg+alfa*yvec;  zp = zzg+alfa*zvec;
      ii=in_triangle(xnorelx,xnorely,xnorelz,d,x1,y1,z1,x12,y12,z12,x13,y13,z13,xp,yp,zp);

      if (! ii)
	return(0);
      else
	return(1);
    }
  else
    return(0);


}



















