#include <SyFi.h>
#include <fstream>

using namespace GiNaC; 
using namespace SyFi; 
using namespace std; 





int main(){ 

    initSyFi(2); 

    //matrix in terms of rational numbers 
    int order = 1; 
    Triangle triangle(lst(0,0), lst(1,0), lst(0,1));   
    Lagrange fe; 
    fe.set_order(order); 
    fe.set_polygon(triangle); 
    fe.compute_basis_functions(); 

    Dof dof; 
    std::map<std::pair<unsigned int,unsigned int>, ex> A; 
    compute_Poisson_element_matrix(fe, dof, A); 
    print(A); 

    //matrix in terms of symbols 
    symbol x0("x0", "x_0"), x1("x1", "x_1"), x2("x2", "x_2");  
    symbol y0("y0", "y_0"), y1("y1", "y_1"), y2("y2", "y_2");  
    Triangle triangle2(lst(x0,y0), lst(x1,y1), lst(x2,y2));   

    Lagrange fe2; 
    fe2.set_order(order); 
    fe2.set_polygon(triangle2); 
    fe2.compute_basis_functions(); 

    Dof dof2; 
    std::map<std::pair<unsigned int,unsigned int>, ex> A2; 
    compute_Poisson_element_matrix(fe2, dof2, A2); 

    cout <<"standard format on output"<<endl; 
    print(A2); 
    cout <<"LaTeX format on output "<<endl; 
    cout <<latex; 
    print(A2); 
    cout <<"C code format on output "<<endl; 
    cout <<csrc; 
    print(A2); 


    /*
    // regression test 
    archive ar; 
    map<std::pair<int,int>,ex>::iterator iter; 
    for (iter = A.begin(); iter != A.end() ; iter++) {
      ar.archive_ex((*iter).second, istr("A", (*iter).first.first, (*iter).first.second).c_str()); 
    }

    for (iter = A2.begin(); iter != A2.end() ; iter++) {
      ar.archive_ex((*iter).second, istr("A2_", (*iter).first.first, (*iter).first.second).c_str()); 
    }
    ofstream vfile("fe_ex4.gar.v"); 
    vfile << ar; vfile.close(); 
    if(!compare_archives("fe_ex4.gar.v", "fe_ex4.gar.r")) { 
      cerr << "Failure!" << endl;
      return -1;
    }
    */

    return 0; 
}


