// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory.
// Licensed under the GNU GPL Version 2, or (at your option) any later version.

#ifndef ELEMENTCOMPUTATIONS_IS_INCLUDED
#define ELEMENTCOMPUTATIONS_IS_INCLUDED

#include "FE.h"
#include "Dof.h"

namespace SyFi
{

	void usage(FE& fe);
	void usage(FE& v_fe, FE& p_fe);

	void compute_Poisson_element_matrix(FE& fe, Dof& dof, std::map<std::pair<unsigned int,unsigned int>, GiNaC::ex>& A);
	void compute_Stokes_element_matrix(FE& v_fe, FE& p_fe, Dof& dof, std::map<std::pair<unsigned int,unsigned int>, GiNaC::ex>& A);
	void compute_mixed_Poisson_element_matrix(FE& v_fe, FE& p_fe, Dof& dof, std::map<std::pair<unsigned int,unsigned int>, GiNaC::ex>& A);

}
#endif
