/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.math;

import cadyts.utilities.math.Cholesky;
import cadyts.utilities.math.Matrix;

public class CholeskyModified
extends Cholesky {
    private final int maxTrials;
    private int trials = 0;

    public CholeskyModified(int maxTrials) {
        this.maxTrials = maxTrials;
    }

    public int getTrials() {
        return this.trials;
    }

    public int getMaxTrials() {
        return this.maxTrials;
    }

    private double smallestDiagonalElement(Matrix _A) {
        double result = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < _A.rowSize()) {
            result = Math.min(result, _A.getRow(i).get(i));
            ++i;
        }
        return result;
    }

    @Override
    public boolean calculateSquareRoot(Matrix _A) {
        this.trials = 1;
        double tau = 0.0;
        Matrix _B = _A.copy();
        double frobNorm = _A.frobeniusNorm();
        if (this.smallestDiagonalElement(_A) <= 0.0) {
            tau = 0.5 * frobNorm;
            _B.add(Matrix.newDiagonal(_B.rowSize(), 1.0), tau);
        }
        while (!super.calculateSquareRoot(_B) && this.trials < this.maxTrials) {
            tau = Math.max(2.0 * tau, 0.5 * frobNorm);
            _B = _A.copy();
            _B.add(Matrix.newDiagonal(_B.rowSize(), 1.0), tau);
            ++this.trials;
        }
        return this.valid();
    }
}

