/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#include "DiffInfo.h"


DiffInfo::DiffInfo( ConflictType type, int blockNumber, const BlockInfo& info )
: _type(type), _merged(msNotMerged), _diff(0), _block(blockNumber),
  _blockInfo(info)
{
}

DiffInfo::DiffInfo( const DiffInfo& src )
{
  _type   = src._type;
  _merged = src._merged;

  _diff      = src._diff;
  _block     = src._block;
  _blockInfo = src._blockInfo;
}

MergeType DiffInfo::getMergeType() const
{
  return _merged;
}

void DiffInfo::setMergeType( MergeType t )
{
  _merged = t;
}

ConflictType DiffInfo::getType() const
{
  return _type;
}

int DiffInfo::getBlockNumber() const
{
  return _block;
}

int DiffInfo::getDiffNumber() const
{
  return _diff;
}

const BlockInfo& DiffInfo::getBlockInfo() const
{
  return _blockInfo;
}

void DiffInfo::setDiffNumber( int num )
{
  _diff = num;
}

