#if defined LINUX_MIPSO32
	/* For an O32 strace, decode the o32 syscalls.  */
	{ MA,	0,	printargs,		"syscall"	}, /* 4000 */ /* start of Linux o32 */
	{ 1,	TP|SE,	sys_exit,		"exit"		}, /* 4001 */
	{ 0,	TP,	sys_fork,		"fork"		}, /* 4002 */
	{ 3,	TD,	sys_read,		"read"		}, /* 4003 */
	{ 3,	TD,	sys_write,		"write"		}, /* 4004 */
	{ 3,	TD|TF,	sys_open,		"open"		}, /* 4005 */
	{ 1,	TD,	sys_close,		"close"		}, /* 4006 */
	{ 3,	TP,	sys_waitpid,		"waitpid"	}, /* 4007 */
	{ 2,	TD|TF,	sys_creat,		"creat"		}, /* 4008 */
	{ 2,	TF,	sys_link,		"link"		}, /* 4009 */
	{ 1,	TF,	sys_unlink,		"unlink"	}, /* 4010 */
	{ 3,	TF|TP|SE|SI,	sys_execve,		"execve"	}, /* 4011 */
	{ 1,	TF,	sys_chdir,		"chdir"		}, /* 4012 */
	{ 1,	0,	sys_time,		"time"		}, /* 4013 */
	{ 3,	TF,	sys_mknod,		"mknod"		}, /* 4014 */
	{ 2,	TF,	sys_chmod,		"chmod"		}, /* 4015 */
	{ 3,	TF,	sys_chown,		"lchown"	}, /* 4016 */
	{ 0,	TM,	sys_break,		"break"		}, /* 4017 */
	{ 2,	TF,	sys_oldstat,		"oldstat"	}, /* 4018 */
	{ 3,	TD,	sys_lseek,		"lseek"		}, /* 4019 */
	{ 0,	0,	sys_getpid,		"getpid"	}, /* 4020 */
	{ 5,	TF,	sys_mount,		"mount"		}, /* 4021 */
	{ 1,	TF,	sys_umount,		"umount"	}, /* 4022 */
	{ 1,	0,	sys_setuid,		"setuid"	}, /* 4023 */
	{ 0,	NF,	sys_getuid,		"getuid"	}, /* 4024 */
	{ 1,	0,	sys_stime,		"stime"		}, /* 4025 */
	{ 4,	0,	sys_ptrace,		"ptrace"	}, /* 4026 */
	{ 1,	0,	sys_alarm,		"alarm"		}, /* 4027 */
	{ 2,	TD,	sys_oldfstat,		"oldfstat"	}, /* 4028 */
	{ 0,	TS,	sys_pause,		"pause"		}, /* 4029 */
	{ 2,	TF,	sys_utime,		"utime"		}, /* 4030 */
	{ 0,	0,	sys_stty,		"stty"		}, /* 4031 */
	{ 0,	0,	sys_gtty,		"gtty"		}, /* 4032 */
	{ 2,	TF,	sys_access,		"access"	}, /* 4033 */
	{ 1,	0,	sys_nice,		"nice"		}, /* 4034 */
	{ 1,	0,	sys_ftime,		"ftime"		}, /* 4035 */
	{ 0,	0,	sys_sync,		"sync"		}, /* 4036 */
	{ 2,	TS,	sys_kill,		"kill"		}, /* 4037 */
	{ 2,	TF,	sys_rename,		"rename"	}, /* 4038 */
	{ 2,	TF,	sys_mkdir,		"mkdir"		}, /* 4039 */
	{ 1,	TF,	sys_rmdir,		"rmdir"		}, /* 4040 */
	{ 1,	TD,	sys_dup,		"dup"		}, /* 4041 */
	{ 1,	TD,	sys_pipe,		"pipe"		}, /* 4042 */
	{ 1,	0,	sys_times,		"times"		}, /* 4043 */
	{ 0,	0,	sys_prof,		"prof"		}, /* 4044 */
	{ 1,	TM|SI,	sys_brk,		"brk"		}, /* 4045 */
	{ 1,	0,	sys_setgid,		"setgid"	}, /* 4046 */
	{ 0,	NF,	sys_getgid,		"getgid"	}, /* 4047 */
	{ 1,	TS,	sys_signal,		"signal"	}, /* 4048 */
	{ 0,	NF,	sys_geteuid,		"geteuid"	}, /* 4049 */
	{ 0,	NF,	sys_getegid,		"getegid"	}, /* 4050 */
	{ 1,	TF,	sys_acct,		"acct"		}, /* 4051 */
	{ 2,	TF,	sys_umount2,		"umount2"	}, /* 4052 */
	{ 0,	0,	sys_lock,		"lock"		}, /* 4053 */
	{ 3,	TD,	sys_ioctl,		"ioctl"		}, /* 4054 */
	{ 3,	TD,	sys_fcntl,		"fcntl"		}, /* 4055 */
	{ 0,	0,	sys_mpx,		"mpx"		}, /* 4056 */
	{ 2,	0,	sys_setpgid,		"setpgid"	}, /* 4057 */
	{ 0,	0,	sys_ulimit,		"ulimit"	}, /* 4058 */
	{ 1,	0,	sys_oldolduname,	"oldolduname"	}, /* 4059 */
	{ 1,	0,	sys_umask,		"umask"		}, /* 4060 */
	{ 1,	TF,	sys_chroot,		"chroot"	}, /* 4061 */
	{ 2,	0,	sys_ustat,		"ustat"		}, /* 4062 */
	{ 2,	TD,	sys_dup2,		"dup2"		}, /* 4063 */
	{ 0,	0,	sys_getppid,		"getppid"	}, /* 4064 */
	{ 0,	0,	sys_getpgrp,		"getpgrp"	}, /* 4065 */
	{ 0,	0,	sys_setsid,		"setsid"	}, /* 4066 */
	{ 3,	TS,	sys_sigaction,		"sigaction"	}, /* 4067 */
	{ 0,	TS,	sys_siggetmask,		"sgetmask"	}, /* 4068 */
	{ 1,	TS,	sys_sigsetmask,		"ssetmask"	}, /* 4069 */
	{ 2,	0,	sys_setreuid,		"setreuid"	}, /* 4070 */
	{ 2,	0,	sys_setregid,		"setregid"	}, /* 4071 */
	{ 3,	TS,	sys_sigsuspend,		"sigsuspend"	}, /* 4072 */
	{ 1,	TS,	sys_sigpending,		"sigpending"	}, /* 4073 */
	{ 2,	0,	sys_sethostname,	"sethostname"	}, /* 4074 */
	{ 2,	0,	sys_setrlimit,		"setrlimit"	}, /* 4075 */
	{ 2,	0,	sys_getrlimit,		"getrlimit"	}, /* 4076 */
	{ 2,	0,	sys_getrusage,		"getrusage"	}, /* 4077 */
	{ 2,	0,	sys_gettimeofday,	"gettimeofday"	}, /* 4078 */
	{ 2,	0,	sys_settimeofday,	"settimeofday"	}, /* 4079 */
	{ 2,	0,	sys_getgroups,		"getgroups"	}, /* 4080 */
	{ 2,	0,	sys_setgroups,		"setgroups"	}, /* 4081 */
	{ 0,	0,	printargs,		"reserved82"	}, /* 4082 */
	{ 2,	TF,	sys_symlink,		"symlink"	}, /* 4083 */
	{ 2,	TF,	sys_oldlstat,		"oldlstat"	}, /* 4084 */
	{ 3,	TF,	sys_readlink,		"readlink"	}, /* 4085 */
	{ 1,	TF,	sys_uselib,		"uselib"	}, /* 4086 */
	{ 2,	TF,	sys_swapon,		"swapon"	}, /* 4087 */
	{ 4,	0,	sys_reboot,		"reboot"	}, /* 4088 */
	{ 3,	TD,	sys_readdir,		"readdir"	}, /* 4089 */
	{ 6,	TD|TM|SI,	sys_mmap,		"mmap"		}, /* 4090 */
	{ 2,	TM|SI,	sys_munmap,		"munmap"	}, /* 4091 */
	{ 2,	TF,	sys_truncate,		"truncate"	}, /* 4092 */
	{ 2,	TD,	sys_ftruncate,		"ftruncate"	}, /* 4093 */
	{ 2,	TD,	sys_fchmod,		"fchmod"	}, /* 4094 */
	{ 3,	TD,	sys_fchown,		"fchown"	}, /* 4095 */
	{ 2,	0,	sys_getpriority,	"getpriority"	}, /* 4096 */
	{ 3,	0,	sys_setpriority,	"setpriority"	}, /* 4097 */
	{ 0,	0,	sys_profil,		"profil"	}, /* 4098 */
	{ 3,	TF,	sys_statfs,		"statfs"	}, /* 4099 */
	{ 3,	TD,	sys_fstatfs,		"fstatfs"	}, /* 4100 */
	{ 0,	0,	sys_ioperm,		"ioperm"	}, /* 4101 */
	{ 2,	TD,	sys_socketcall,		"socketcall"	}, /* 4102 */
	{ 3,	0,	sys_syslog,		"syslog"	}, /* 4103 */
	{ 3,	0,	sys_setitimer,		"setitimer"	}, /* 4104 */
	{ 2,	0,	sys_getitimer,		"getitimer"	}, /* 4105 */
	{ 2,	TF,	sys_stat,		"stat"		}, /* 4106 */
	{ 2,	TF,	sys_lstat,		"lstat"		}, /* 4107 */
	{ 2,	TD,	sys_fstat,		"fstat"		}, /* 4108 */
	{ 1,	0,	sys_olduname,		"olduname"	}, /* 4109 */
	{ 0,	0,	sys_iopl,		"iopl"		}, /* 4110 */
	{ 0,	0,	sys_vhangup,		"vhangup"	}, /* 4111 */
	{ 0,	0,	sys_idle,		"idle"		}, /* 4112 */
	{ 5,	0,	sys_vm86old,		"vm86"		}, /* 4113 */
	{ 4,	TP,	sys_wait4,		"wait4"		}, /* 4114 */
	{ 1,	TF,	sys_swapoff,		"swapoff"	}, /* 4115 */
	{ 1,	0,	sys_sysinfo,		"sysinfo"	}, /* 4116 */
	{ 6,	TI,	sys_ipc,		"ipc"		}, /* 4117 */
	{ 1,	TD,	sys_fsync,		"fsync"		}, /* 4118 */
	{ 0,	TS,	sys_sigreturn,		"sigreturn"	}, /* 4119 */
	{ 5,	TP,	sys_clone,		"clone"		}, /* 4120 */
	{ 2,	0,	sys_setdomainname,	"setdomainname"	}, /* 4121 */
	{ 1,	0,	sys_uname,		"uname"		}, /* 4122 */
	{ 0,	0,	sys_modify_ldt,		"modify_ldt"	}, /* 4123 */
	{ 1,	0,	sys_adjtimex,		"adjtimex"	}, /* 4124 */
	{ 3,	TM|SI,	sys_mprotect,		"mprotect"	}, /* 4125 */
	{ 3,	TS,	sys_sigprocmask,	"sigprocmask"	}, /* 4126 */
	{ 2,	0,	sys_create_module,	"create_module"	}, /* 4127 */
	{ 3,	0,	sys_init_module,	"init_module"	}, /* 4128 */
	{ 2,	0,	sys_delete_module,	"delete_module"	}, /* 4129 */
	{ 1,	0,	sys_get_kernel_syms,	"get_kernel_syms"}, /* 4130 */
	{ 4,	TF,	sys_quotactl,		"quotactl"	}, /* 4131 */
	{ 1,	0,	sys_getpgid,		"getpgid"	}, /* 4132 */
	{ 1,	TD,	sys_fchdir,		"fchdir"	}, /* 4133 */
	{ 2,	0,	sys_bdflush,		"bdflush"	}, /* 4134 */
	{ 3,	0,	sys_sysfs,		"sysfs"		}, /* 4135 */
	{ 1,	0,	sys_personality,	"personality"	}, /* 4136 */
	{ 0,	0,	sys_afs_syscall,	"afs_syscall"	}, /* 4137 */
	{ 1,	NF,	sys_setfsuid,		"setfsuid"	}, /* 4138 */
	{ 1,	NF,	sys_setfsgid,		"setfsgid"	}, /* 4139 */
	{ 5,	TD,	sys_llseek,		"_llseek"	}, /* 4140 */
	{ 3,	TD,	sys_getdents,		"getdents"	}, /* 4141 */
	{ 5,	TD,	sys_select,		"_newselect"	}, /* 4142 */
	{ 2,	TD,	sys_flock,		"flock"		}, /* 4143 */
	{ 3,	TM,	sys_msync,		"msync"		}, /* 4144 */
	{ 3,	TD,	sys_readv,		"readv"		}, /* 4145 */
	{ 3,	TD,	sys_writev,		"writev"	}, /* 4146 */
	{ 3,	0,	printargs,		"cacheflush"	}, /* 4147 */
	{ 3,	0,	printargs,		"cachectl"	}, /* 4148 */
	{ 4,	0,	sys_sysmips,		"sysmips"	}, /* 4149 */
	{ 0,	0,	sys_setup,		"setup"		}, /* 4150 */
	{ 1,	0,	sys_getsid,		"getsid"	}, /* 4151 */
	{ 1,	TD,	sys_fdatasync,		"fdatasync"	}, /* 4152 */
	{ 1,	0,	sys_sysctl,		"_sysctl"	}, /* 4153 */
	{ 2,	TM,	sys_mlock,		"mlock"		}, /* 4154 */
	{ 2,	TM,	sys_munlock,		"munlock"	}, /* 4155 */
	{ 1,	TM,	sys_mlockall,		"mlockall"	}, /* 4156 */
	{ 0,	TM,	sys_munlockall,		"munlockall"	}, /* 4157 */
	{ 2,	0,	sys_sched_setparam,	"sched_setparam"}, /* 4158 */
	{ 2,	0,	sys_sched_getparam,	"sched_getparam"}, /* 4159 */
	{ 3,	0,	sys_sched_setscheduler,	"sched_setscheduler"}, /* 4160 */
	{ 1,	0,	sys_sched_getscheduler,	"sched_getscheduler"}, /* 4161 */
	{ 0,	0,	sys_sched_yield,	"sched_yield"	}, /* 4162 */
	{ 1,	0,	sys_sched_get_priority_max,"sched_get_priority_max"}, /* 4163 */
	{ 1,	0,	sys_sched_get_priority_min,"sched_get_priority_min"}, /* 4164 */
	{ 2,	0,	sys_sched_rr_get_interval,"sched_rr_get_interval"}, /* 4165 */
	{ 2,	0,	sys_nanosleep,		"nanosleep"	}, /* 4166 */
	{ 5,	TM|SI,	sys_mremap,		"mremap"	}, /* 4167 */
	{ 3,	TN,	sys_accept,		"accept"	}, /* 4168 */
	{ 3,	TN,	sys_bind,		"bind"		}, /* 4169 */
	{ 3,	TN,	sys_connect,		"connect"	}, /* 4170 */
	{ 3,	TN,	sys_getpeername,	"getpeername"	}, /* 4171 */
	{ 3,	TN,	sys_getsockname,	"getsockname"	}, /* 4172 */
	{ 5,	TN,	sys_getsockopt,		"getsockopt"	}, /* 4173 */
	{ 2,	TN,	sys_listen,		"listen"	}, /* 4174 */
	{ 4,	TN,	sys_recv,		"recv"		}, /* 4175 */
	{ 6,	TN,	sys_recvfrom,		"recvfrom"	}, /* 4176 */
	{ 3,	TN,	sys_recvmsg,		"recvmsg"	}, /* 4177 */
	{ 4,	TN,	sys_send,		"send"		}, /* 4178 */
	{ 3,	TN,	sys_sendmsg,		"sendmsg"	}, /* 4179 */
	{ 6,	TN,	sys_sendto,		"sendto"	}, /* 4180 */
	{ 5,	TN,	sys_setsockopt,		"setsockopt"	}, /* 4181 */
	{ 2,	TN,	sys_shutdown,		"shutdown"	}, /* 4182 */
	{ 3,	TN,	sys_socket,		"socket"	}, /* 4183 */
	{ 4,	TN,	sys_socketpair,		"socketpair"	}, /* 4184 */
	{ 3,	0,	sys_setresuid,		"setresuid"	}, /* 4185 */
	{ 3,	0,	sys_getresuid,		"getresuid"	}, /* 4186 */
	{ 5,	0,	sys_query_module,	"query_module"	}, /* 4187 */
	{ 3,	TD,	sys_poll,		"poll"		}, /* 4188 */
	{ 3,	0,	sys_nfsservctl,		"nfsservctl"	}, /* 4189 */
	{ 3,	0,	sys_setresgid,		"setresgid"	}, /* 4190 */
	{ 3,	0,	sys_getresgid,		"getresgid"	}, /* 4191 */
	{ 5,	0,	sys_prctl,		"prctl"		}, /* 4192 */
	{ 0,	TS,	sys_rt_sigreturn,	"rt_sigreturn"	}, /* 4193 */
	{ 4,	TS,	sys_rt_sigaction,	"rt_sigaction"	}, /* 4194 */
	{ 4,	TS,	sys_rt_sigprocmask,	"rt_sigprocmask"}, /* 4195 */
	{ 2,	TS,	sys_rt_sigpending,	"rt_sigpending"	}, /* 4196 */
	{ 4,	TS,	sys_rt_sigtimedwait,	"rt_sigtimedwait"},/* 4197 */
	{ 3,	TS,	sys_rt_sigqueueinfo,	"rt_sigqueueinfo"},/* 4198 */
	{ 2,	TS,	sys_rt_sigsuspend,	"rt_sigsuspend"	}, /* 4199 */
	{ 6,	TD,	sys_pread,		"pread64"	}, /* 4200 */
	{ 6,	TD,	sys_pwrite,		"pwrite64"	}, /* 4201 */
	{ 3,	TF,	sys_chown,		"chown"		}, /* 4202 */
	{ 2,	TF,	sys_getcwd,		"getcwd"	}, /* 4203 */
	{ 2,	0,	sys_capget,		"capget"	}, /* 4204 */
	{ 2,	0,	sys_capset,		"capset"	}, /* 4205 */
	{ 2,	TS,	sys_sigaltstack,	"sigaltstack"	}, /* 4206 */
	{ 4,	TD|TN,	sys_sendfile,		"sendfile"	}, /* 4207 */
	{ 5,	TN,	printargs,		"getpmsg"	}, /* 4208 */
	{ 5,	TN,	printargs,		"putpmsg"	}, /* 4209 */
	{ 6,	TD|TM|SI,	sys_mmap_4koff,		"mmap2"		}, /* 4210 */
	{ 4,	TF,	sys_truncate64,		"truncate64"	}, /* 4211 */
	{ 4,	TD,	sys_ftruncate64,	"ftruncate64"	}, /* 4212 */
	{ 2,	TF,	sys_stat64,		"stat64"	}, /* 4213 */
	{ 2,	TF,	sys_lstat64,		"lstat64"	}, /* 4214 */
	{ 2,	TD,	sys_fstat64,		"fstat64"	}, /* 4215 */
	{ 2,	TF,	sys_pivotroot,		"pivot_root"	}, /* 4216 */
	{ 3,	TM,	sys_mincore,		"mincore"	}, /* 4217 */
	{ 3,	TM,	sys_madvise,		"madvise"	}, /* 4218 */
	{ 3,	TD,	sys_getdents64,		"getdents64"	}, /* 4219 */
	{ 3,	TD,	sys_fcntl,		"fcntl64"	}, /* 4220 */
	{ 0,	0,	NULL,			NULL		}, /* 4221 */
	{ 0,	0,	sys_gettid,		"gettid"	}, /* 4222 */
	{ 5,	TD,	sys_readahead,		"readahead"	}, /* 4223 */
	{ 5,	TF,	sys_setxattr,		"setxattr"	}, /* 4224 */
	{ 5,	TF,	sys_setxattr,		"lsetxattr"	}, /* 4225 */
	{ 5,	TD,	sys_fsetxattr,		"fsetxattr"	}, /* 4226 */
	{ 4,	TF,	sys_getxattr,		"getxattr"	}, /* 4227 */
	{ 4,	TF,	sys_getxattr,		"lgetxattr"	}, /* 4228 */
	{ 4,	TD,	sys_fgetxattr,		"fgetxattr"	}, /* 4229 */
	{ 3,	TF,	sys_listxattr,		"listxattr"	}, /* 4230 */
	{ 3,	TF,	sys_listxattr,		"llistxattr"	}, /* 4231 */
	{ 3,	TD,	sys_flistxattr,		"flistxattr"	}, /* 4232 */
	{ 2,	TF,	sys_removexattr,	"removexattr"	}, /* 4233 */
	{ 2,	TF,	sys_removexattr,	"lremovexattr"	}, /* 4234 */
	{ 2,	TD,	sys_fremovexattr,	"fremovexattr"	}, /* 4235 */
	{ 2,	TS,	sys_kill,		"tkill"		}, /* 4236 */
	{ 4,	TD|TN,	sys_sendfile64,		"sendfile64"	}, /* 4237 */
	{ 6,	0,	sys_futex,		"futex"		}, /* 4238 */
	{ 3,	0,	sys_sched_setaffinity,	"sched_setaffinity"}, /* 4239 */
	{ 3,	0,	sys_sched_getaffinity,	"sched_getaffinity"}, /* 4240 */
	{ 2,	0,	sys_io_setup,		"io_setup"	}, /* 4241 */
	{ 1,	0,	sys_io_destroy,		"io_destroy"	}, /* 4242 */
	{ 5,	0,	sys_io_getevents,		"io_getevents"	}, /* 4243 */
	{ 3,	0,	sys_io_submit,		"io_submit"	}, /* 4244 */
	{ 3,	0,	sys_io_cancel,		"io_cancel"	}, /* 4245 */
	{ 1,	TP|SE,	sys_exit,		"exit_group"	}, /* 4246 */
	{ 4,	0,	sys_lookup_dcookie,	"lookup_dcookie"}, /* 4247 */
	{ 1,	TD,	sys_epoll_create,	"epoll_create"	}, /* 4248 */
	{ 4,	TD,	sys_epoll_ctl,		"epoll_ctl"	}, /* 4249 */
	{ 4,	TD,	sys_epoll_wait,		"epoll_wait"	}, /* 4250 */
	{ 5,	TM|SI,	sys_remap_file_pages,	"remap_file_pages"}, /* 4251 */
	{ 1,	0,	sys_set_tid_address,	"set_tid_address"}, /* 4252 */
	{ 0,	0,	sys_restart_syscall,	"restart_syscall"}, /* 4253 */
	{ 7,	TD,	sys_fadvise64_64,	"fadvise64_64"	}, /* 4254 */
	{ 3,	TF,	sys_statfs64,		"statfs64"	}, /* 4255 */
	{ 2,	TD,	sys_fstatfs64,		"fstatfs64"	}, /* 4256 */
	{ 3,	0,	sys_timer_create,	"timer_create"	}, /* 4257 */
	{ 4,	0,	sys_timer_settime,	"timer_settime"	}, /* 4258 */
	{ 2,	0,	sys_timer_gettime,	"timer_gettime"	}, /* 4259 */
	{ 1,	0,	sys_timer_getoverrun,	"timer_getoverrun"}, /* 4260 */
	{ 1,	0,	sys_timer_delete,	"timer_delete"	}, /* 4261 */
	{ 2,	0,	sys_clock_settime,	"clock_settime"	}, /* 4262 */
	{ 2,	0,	sys_clock_gettime,	"clock_gettime"	}, /* 4263 */
	{ 2,	0,	sys_clock_getres,	"clock_getres"	}, /* 4264 */
	{ 4,	0,	sys_clock_nanosleep,	"clock_nanosleep"}, /* 4265 */
	{ 3,	TS,	sys_tgkill,		"tgkill"	}, /* 4266 */
	{ 2,	TF,	sys_utimes,		"utimes"	}, /* 4267 */
	{ 4,	TM,	sys_mbind,		"mbind"		}, /* 4268 */
	{ 5,	TM,	sys_get_mempolicy,	"get_mempolicy"	}, /* 4269 */
	{ 3,	TM,	sys_set_mempolicy,	"set_mempolicy"	}, /* 4270 */
	{ 4,	0,	sys_mq_open,		"mq_open"	}, /* 4271 */
	{ 1,	0,	sys_mq_unlink,		"mq_unlink"	}, /* 4272 */
	{ 5,	0,	sys_mq_timedsend,	"mq_timedsend"	}, /* 4273 */
	{ 5,	0,	sys_mq_timedreceive,	"mq_timedreceive"}, /* 4274 */
	{ 2,	0,	sys_mq_notify,		"mq_notify"	}, /* 4275 */
	{ 3,	0,	sys_mq_getsetattr,	"mq_getsetattr"	}, /* 4276 */
	{ 5,	0,	sys_vserver,		"vserver"	}, /* 4277 */
	{ 5,	TP,	sys_waitid,		"waitid"	}, /* 4278 */
	{ 0,	0,	NULL,			NULL		}, /* 4279 */
	{ 5,	0,	sys_add_key,		"add_key"	}, /* 4280 */
	{ 4,	0,	sys_request_key,	"request_key"	}, /* 4281 */
	{ 5,	0,	sys_keyctl,		"keyctl"	}, /* 4282 */
	{ 1,	0,	sys_set_thread_area,	"set_thread_area" }, /* 4283 */
	{ 0,	TD,	sys_inotify_init,	"inotify_init"	}, /* 4284 */
	{ 3,	TD,	sys_inotify_add_watch,	"inotify_add_watch" }, /* 4285 */
	{ 2,	TD,	sys_inotify_rm_watch,	"inotify_rm_watch" }, /* 4286 */
	{ 4,	TM,	sys_migrate_pages,	"migrate_pages"	}, /* 4287 */
	{ 4,	TD|TF,	sys_openat,		"openat"	}, /* 4288 */
	{ 3,	TD|TF,	sys_mkdirat,		"mkdirat"	}, /* 4289 */
	{ 4,	TD|TF,	sys_mknodat,		"mknodat"	}, /* 4290 */
	{ 5,	TD|TF,	sys_fchownat,		"fchownat"	}, /* 4291 */
	{ 3,	TD|TF,	sys_futimesat,		"futimesat"	}, /* 4292 */
	{ 4,	TD|TF,	sys_newfstatat,		"fstatat64"	}, /* 4293 */
	{ 3,	TD|TF,	sys_unlinkat,		"unlinkat"	}, /* 4294 */
	{ 4,	TD|TF,	sys_renameat,		"renameat"	}, /* 4295 */
	{ 5,	TD|TF,	sys_linkat,		"linkat"	}, /* 4296 */
	{ 3,	TD|TF,	sys_symlinkat,		"symlinkat"	}, /* 4297 */
	{ 4,	TD|TF,	sys_readlinkat,		"readlinkat"	}, /* 4298 */
	{ 3,	TD|TF,	sys_fchmodat,		"fchmodat"	}, /* 4299 */
	{ 3,	TD|TF,	sys_faccessat,		"faccessat"	}, /* 4300 */
	{ 6,	TD,	sys_pselect6,		"pselect6"	}, /* 4301 */
	{ 5,	TD,	sys_ppoll,		"ppoll"		}, /* 4302 */
	{ 1,	TP,	sys_unshare,		"unshare"	}, /* 4303 */
	{ 6,	TD,	sys_splice,		"splice"	}, /* 4304 */
	{ 7,	TD,	sys_sync_file_range,	"sync_file_range" }, /* 4305 */
	{ 4,	TD,	sys_tee,		"tee"		}, /* 4306 */
	{ 4,	TD,	sys_vmsplice,		"vmsplice"	}, /* 4307 */
	{ 6,	TM,	sys_move_pages,		"move_pages"	}, /* 4308 */
	{ 2,	0,	sys_set_robust_list,	"set_robust_list" }, /* 4309 */
	{ 3,	0,	sys_get_robust_list,	"get_robust_list" }, /* 4310 */
	{ 4,	0,	sys_kexec_load,		"kexec_load"	}, /* 4311 */
	{ 3,	0,	sys_getcpu,		"getcpu"	}, /* 4312 */
	{ 6,	TD,	sys_epoll_pwait,	"epoll_pwait"	}, /* 4313 */
	{ 3,	0,	sys_ioprio_set,		"ioprio_set"	}, /* 4314 */
	{ 2,	0,	sys_ioprio_get,		"ioprio_get"	}, /* 4315 */
	{ 4,	0,	printargs,		"utimensat"	}, /* 4316 */
	{ 3,	TD|TS,	sys_signalfd,		"signalfd"	}, /* 4317 */
	{ 4,	TD,	sys_timerfd,		"timerfd"	}, /* 4318 */
	{ 1,	TD,	sys_eventfd,		"eventfd"	}, /* 4319 */
	{ 6,	TD,	sys_fallocate,		"fallocate"	}, /* 4320 */
	{ 2,	TD,	sys_timerfd_create,	"timerfd_create" }, /* 4321 */
	{ 2,	TD,	sys_timerfd_gettime,	"timerfd_gettime" }, /* 4322 */
	{ 4,	TD,	sys_timerfd_settime,	"timerfd_settime" }, /* 4323 */
	{ 4,	TD|TS,	sys_signalfd4,		"signalfd4"	}, /* 4324 */
	{ 2,	TD,	sys_eventfd2,		"eventfd2"	}, /* 4325 */
	{ 1,	TD,	sys_epoll_create1,	"epoll_create1"	}, /* 4326 */
	{ 3,	TD,	sys_dup3,		"dup3"		}, /* 4327 */
	{ 2,	TD,	sys_pipe2,		"pipe2"		}, /* 4328 */
	{ 1,	TD,	sys_inotify_init1,	"inotify_init1"	}, /* 4329 */
	{ 5,	TD,	sys_preadv,		"preadv"	}, /* 4330 */
	{ 5,	TD,	sys_pwritev,		"pwritev"	}, /* 4331 */
	{ 4,	TP|TS,	sys_rt_tgsigqueueinfo,	"rt_tgsigqueueinfo" }, /* 4332 */
	{ 5,	TD,	sys_perf_event_open,	"perf_event_open" }, /* 4333 */
	{ 4,	TN,	sys_accept4,		"accept4"	}, /* 4334 */
	{ 5,	TN,	sys_recvmmsg,		"recvmmsg"	}, /* 4335 */
	{ 2,	TD,	sys_fanotify_init,	"fanotify_init"	}, /* 4336 */
	{ 6,	TD|TF,	sys_fanotify_mark,	"fanotify_mark"	}, /* 4337 */
	{ 4,	0,	sys_prlimit64,		"prlimit64"	}, /* 4338 */
	{ 5,	TD|TF,	sys_name_to_handle_at,	"name_to_handle_at"}, /* 4339 */
	{ 3,	TD,	sys_open_by_handle_at,	"open_by_handle_at"}, /* 4340 */
	{ 2,	0,	sys_clock_adjtime,	"clock_adjtime"	}, /* 4341 */
	{ 1,	TD,	sys_syncfs,		"syncfs"	}, /* 4342 */
	{ 4,	TN,	sys_sendmmsg,		"sendmmsg"	}, /* 4343 */
	{ 2,	TD,	sys_setns,		"setns"		}, /* 4344 */
	{ 6,	0,	sys_process_vm_readv,	"process_vm_readv"	}, /* 4345 */
	{ 6,	0,	sys_process_vm_writev,	"process_vm_writev"	}, /* 4346 */
	{ 5,	0,	sys_kcmp,		"kcmp"		}, /* 4347 */
	{ 3,	TD,	sys_finit_module,	"finit_module"	}, /* 4348 */
	{ 3,	0,	sys_sched_setattr,	"sched_setattr"	}, /* 4349 */
	{ 4,	0,	sys_sched_getattr,	"sched_getattr"	}, /* 4350 */
	{ 5,	TD|TF,	sys_renameat2,		"renameat2"	}, /* 4351 */
#else
	{ 0,	0,	printargs,		"o32_syscall"	}, /* 4000 */
	{ 1,	TP|SE,	printargs,		"o32_exit"		}, /* 4001 */
	{ 0,	TP,	printargs,		"o32_fork"		}, /* 4002 */
	{ 0,	0,	printargs,		"o32_read"		}, /* 4003 */
	{ 0,	0,	printargs,		"o32_write"		}, /* 4004 */
	{ 0,	0,	printargs,		"o32_open"		}, /* 4005 */
	{ 0,	0,	printargs,		"o32_close"		}, /* 4006 */
	{ 3,	TP,	printargs,		"o32_waitpid"	}, /* 4007 */
	{ 0,	0,	printargs,		"o32_creat"		}, /* 4008 */
	{ 0,	0,	printargs,		"o32_link"		}, /* 4009 */
	{ 0,	0,	printargs,		"o32_unlink"	}, /* 4010 */
	{ 3,	TF|TP|SE|SI,	printargs,		"o32_execve"	}, /* 4011 */
	{ 0,	0,	printargs,		"o32_chdir"		}, /* 4012 */
	{ 0,	0,	printargs,		"o32_time"		}, /* 4013 */
	{ 0,	0,	printargs,		"o32_mknod"		}, /* 4014 */
	{ 0,	0,	printargs,		"o32_chmod"		}, /* 4015 */
	{ 0,	0,	printargs,		"o32_lchown"	}, /* 4016 */
	{ 0,	TM,	printargs,		"o32_break"		}, /* 4017 */
	{ 0,	0,	printargs,		"o32_oldstat"	}, /* 4018 */
	{ 0,	0,	printargs,		"o32_lseek"		}, /* 4019 */
	{ 0,	0,	printargs,		"o32_getpid"	}, /* 4020 */
	{ 0,	0,	printargs,		"o32_mount"		}, /* 4021 */
	{ 0,	0,	printargs,		"o32_umount"	}, /* 4022 */
	{ 0,	0,	printargs,		"o32_setuid"	}, /* 4023 */
	{ 0,	0,	printargs,		"o32_getuid"	}, /* 4024 */
	{ 0,	0,	printargs,		"o32_stime"		}, /* 4025 */
	{ 0,	0,	printargs,		"o32_ptrace"	}, /* 4026 */
	{ 0,	0,	printargs,		"o32_alarm"		}, /* 4027 */
	{ 0,	0,	printargs,		"o32_oldfstat"	}, /* 4028 */
	{ 0,	0,	printargs,		"o32_pause"		}, /* 4029 */
	{ 0,	0,	printargs,		"o32_utime"		}, /* 4030 */
	{ 0,	0,	printargs,		"o32_stty"		}, /* 4031 */
	{ 0,	0,	printargs,		"o32_gtty"		}, /* 4032 */
	{ 0,	0,	printargs,		"o32_access"	}, /* 4033 */
	{ 0,	0,	printargs,		"o32_nice"		}, /* 4034 */
	{ 0,	0,	printargs,		"o32_ftime"		}, /* 4035 */
	{ 0,	0,	printargs,		"o32_sync"		}, /* 4036 */
	{ 0,	0,	printargs,		"o32_kill"		}, /* 4037 */
	{ 0,	0,	printargs,		"o32_rename"	}, /* 4038 */
	{ 0,	0,	printargs,		"o32_mkdir"		}, /* 4039 */
	{ 0,	0,	printargs,		"o32_rmdir"		}, /* 4040 */
	{ 0,	0,	printargs,		"o32_dup"		}, /* 4041 */
	{ 0,	0,	printargs,		"o32_pipe"		}, /* 4042 */
	{ 0,	0,	printargs,		"o32_times"		}, /* 4043 */
	{ 0,	0,	printargs,		"o32_prof"		}, /* 4044 */
	{ 0,	TM|SI,	printargs,		"o32_brk"		}, /* 4045 */
	{ 0,	0,	printargs,		"o32_setgid"	}, /* 4046 */
	{ 0,	0,	printargs,		"o32_getgid"	}, /* 4047 */
	{ 0,	0,	printargs,		"o32_signal"	}, /* 4048 */
	{ 0,	0,	printargs,		"o32_geteuid"	}, /* 4049 */
	{ 0,	0,	printargs,		"o32_getegid"	}, /* 4050 */
	{ 0,	0,	printargs,		"o32_acct"		}, /* 4051 */
	{ 0,	0,	printargs,		"o32_umount2"	}, /* 4052 */
	{ 0,	0,	printargs,		"o32_lock"		}, /* 4053 */
	{ 0,	0,	printargs,		"o32_ioctl"		}, /* 4054 */
	{ 0,	0,	printargs,		"o32_fcntl"		}, /* 4055 */
	{ 0,	0,	printargs,		"o32_mpx"		}, /* 4056 */
	{ 0,	0,	printargs,		"o32_setpgid"	}, /* 4057 */
	{ 0,	0,	printargs,		"o32_ulimit"	}, /* 4058 */
	{ 0,	0,	printargs,		"o32_oldolduname"	}, /* 4059 */
	{ 0,	0,	printargs,		"o32_umask"		}, /* 4060 */
	{ 0,	0,	printargs,		"o32_chroot"	}, /* 4061 */
	{ 0,	0,	printargs,		"o32_ustat"		}, /* 4062 */
	{ 0,	0,	printargs,		"o32_dup2"		}, /* 4063 */
	{ 0,	0,	printargs,		"o32_getppid"	}, /* 4064 */
	{ 0,	0,	printargs,		"o32_getpgrp"	}, /* 4065 */
	{ 0,	0,	printargs,		"o32_setsid"	}, /* 4066 */
	{ 0,	0,	printargs,		"o32_sigaction"	}, /* 4067 */
	{ 0,	0,	printargs,		"o32_siggetmask"	}, /* 4068 */
	{ 0,	0,	printargs,		"o32_sigsetmask"	}, /* 4069 */
	{ 0,	0,	printargs,		"o32_setreuid"	}, /* 4070 */
	{ 0,	0,	printargs,		"o32_setregid"	}, /* 4071 */
	{ 0,	0,	printargs,		"o32_sigsuspend"	}, /* 4072 */
	{ 0,	0,	printargs,		"o32_sigpending"	}, /* 4073 */
	{ 0,	0,	printargs,		"o32_sethostname"	}, /* 4074 */
	{ 0,	0,	printargs,		"o32_setrlimit"	}, /* 4075 */
	{ 0,	0,	printargs,		"o32_getrlimit"	}, /* 4076 */
	{ 0,	0,	printargs,		"o32_getrusage"	}, /* 4077 */
	{ 0,	0,	printargs,		"o32_gettimeofday"	}, /* 4078 */
	{ 0,	0,	printargs,		"o32_settimeofday"	}, /* 4079 */
	{ 0,	0,	printargs,		"o32_getgroups"	}, /* 4080 */
	{ 0,	0,	printargs,		"o32_setgroups"	}, /* 4081 */
	{ 0,	0,	printargs,		"o32_reserved82"	}, /* 4082 */
	{ 0,	0,	printargs,		"o32_symlink"	}, /* 4083 */
	{ 0,	0,	printargs,		"o32_oldlstat"	}, /* 4084 */
	{ 0,	0,	printargs,		"o32_readlink"	}, /* 4085 */
	{ 0,	0,	printargs,		"o32_uselib"	}, /* 4086 */
	{ 0,	0,	printargs,		"o32_swapon"	}, /* 4087 */
	{ 0,	0,	printargs,		"o32_reboot"	}, /* 4088 */
	{ 0,	0,	printargs,		"o32_readdir"	}, /* 4089 */
	{ 0,	TD|TM|SI,	printargs,		"o32_mmap"	}, /* 4090 */
	{ 0,	TM|SI,	printargs,		"o32_munmap"	}, /* 4091 */
	{ 0,	0,	printargs,		"o32_truncate"	}, /* 4092 */
	{ 0,	0,	printargs,		"o32_ftruncate"	}, /* 4093 */
	{ 0,	0,	printargs,		"o32_fchmod"	}, /* 4094 */
	{ 0,	0,	printargs,		"o32_fchown"	}, /* 4095 */
	{ 0,	0,	printargs,		"o32_getpriority"	}, /* 4096 */
	{ 0,	0,	printargs,		"o32_setpriority"	}, /* 4097 */
	{ 0,	0,	printargs,		"o32_profil"	}, /* 4098 */
	{ 0,	0,	printargs,		"o32_statfs"	}, /* 4099 */
	{ 0,	0,	printargs,		"o32_fstatfs"	}, /* 4100 */
	{ 0,	0,	printargs,		"o32_ioperm"	}, /* 4101 */
	{ 0,	0,	printargs,		"o32_socketcall"	}, /* 4102 */
	{ 0,	0,	printargs,		"o32_syslog"	}, /* 4103 */
	{ 0,	0,	printargs,		"o32_setitimer"	}, /* 4104 */
	{ 0,	0,	printargs,		"o32_getitimer"	}, /* 4105 */
	{ 0,	0,	printargs,		"o32_stat"		}, /* 4106 */
	{ 0,	0,	printargs,		"o32_lstat"		}, /* 4107 */
	{ 0,	0,	printargs,		"o32_fstat"		}, /* 4108 */
	{ 0,	0,	printargs,		"o32_olduname"	}, /* 4109 */
	{ 0,	0,	printargs,		"o32_iopl"		}, /* 4110 */
	{ 0,	0,	printargs,		"o32_vhangup"	}, /* 4111 */
	{ 0,	0,	printargs,		"o32_idle"		}, /* 4112 */
	{ 0,	0,	printargs,		"o32_vm86"		}, /* 4113 */
	{ 4,	TP,	printargs,		"o32_wait4"		}, /* 4114 */
	{ 0,	0,	printargs,		"o32_swapoff"	}, /* 4115 */
	{ 0,	0,	printargs,		"o32_sysinfo"	}, /* 4116 */
	{ 0,	0,	printargs,		"o32_ipc"		}, /* 4117 */
	{ 0,	0,	printargs,		"o32_fsync"		}, /* 4118 */
	{ 0,	0,	printargs,		"o32_sigreturn"	}, /* 4119 */
	{ 5,	TP,	printargs,		"o32_clone"		}, /* 4120 */
	{ 0,	0,	printargs,		"o32_setdomainname"	}, /* 4121 */
	{ 0,	0,	printargs,		"o32_uname"		}, /* 4122 */
	{ 0,	0,	printargs,		"o32_modify_ldt"	}, /* 4123 */
	{ 0,	0,	printargs,		"o32_adjtimex"	}, /* 4124 */
	{ 0,	TM|SI,	printargs,		"o32_mprotect"	}, /* 4125 */
	{ 0,	0,	printargs,		"o32_sigprocmask"	}, /* 4126 */
	{ 0,	0,	printargs,		"o32_create_module"	}, /* 4127 */
	{ 0,	0,	printargs,		"o32_init_module"	}, /* 4128 */
	{ 0,	0,	printargs,		"o32_delete_module"	}, /* 4129 */
	{ 0,	0,	printargs,		"o32_get_kernel_syms"}, /* 4130 */
	{ 0,	TF,	printargs,		"o32_quotactl"	}, /* 4131 */
	{ 0,	0,	printargs,		"o32_getpgid"	}, /* 4132 */
	{ 0,	0,	printargs,		"o32_fchdir"	}, /* 4133 */
	{ 0,	0,	printargs,		"o32_bdflush"	}, /* 4134 */
	{ 0,	0,	printargs,		"o32_sysfs"		}, /* 4135 */
	{ 0,	0,	printargs,		"o32_personality"	}, /* 4136 */
	{ 0,	0,	printargs,		"o32_afs_syscall"	}, /* 4137 */
	{ 0,	0,	printargs,		"o32_setfsuid"	}, /* 4138 */
	{ 0,	0,	printargs,		"o32_setfsgid"	}, /* 4139 */
	{ 0,	0,	printargs,		"o32__llseek"	}, /* 4140 */
	{ 0,	0,	printargs,		"o32_getdents"	}, /* 4141 */
	{ 0,	0,	printargs,		"o32__newselect"	}, /* 4142 */
	{ 0,	0,	printargs,		"o32_flock"		}, /* 4143 */
	{ 0,	TM,	printargs,		"o32_msync"		}, /* 4144 */
	{ 0,	0,	printargs,		"o32_readv"		}, /* 4145 */
	{ 0,	0,	printargs,		"o32_writev"	}, /* 4146 */
	{ 0,	0,	printargs,		"o32_cacheflush"	}, /* 4147 */
	{ 0,	0,	printargs,		"o32_cachectl"	}, /* 4148 */
	{ 0,	0,	printargs,		"o32_sysmips"	}, /* 4149 */
	{ 0,	0,	printargs,		"o32_setup"		}, /* 4150 */
	{ 0,	0,	printargs,		"o32_getsid"	}, /* 4151 */
	{ 0,	0,	printargs,		"o32_fdatasync"	}, /* 4152 */
	{ 0,	0,	printargs,		"o32__sysctl"	}, /* 4153 */
	{ 0,	TM,	printargs,		"o32_mlock"		}, /* 4154 */
	{ 0,	TM,	printargs,		"o32_munlock"	}, /* 4155 */
	{ 0,	TM,	printargs,		"o32_mlockall"	}, /* 4156 */
	{ 0,	TM,	printargs,		"o32_munlockall"	}, /* 4157 */
	{ 0,	0,	printargs,		"o32_sched_setparam"}, /* 4158 */
	{ 0,	0,	printargs,		"o32_sched_getparam"}, /* 4159 */
	{ 0,	0,	printargs,		"o32_sched_setscheduler"}, /* 4160 */
	{ 0,	0,	printargs,		"o32_sched_getscheduler"}, /* 4161 */
	{ 0,	0,	printargs,		"o32_sched_yield"	}, /* 4162 */
	{ 0,	0,	printargs,		"o32_sched_get_priority_max"}, /* 4163 */
	{ 0,	0,	printargs,		"o32_sched_get_priority_min"},/* 4164 */
	{ 0,	0,	printargs,		"o32_sched_rr_get_interval"}, /* 4165 */
	{ 0,	0,	printargs,		"o32_nanosleep"	}, /* 4166 */
	{ 0,	TM|SI,	printargs,		"o32_mremap"	}, /* 4167 */
	{ 0,	0,	printargs,		"o32_accept"	}, /* 4168 */
	{ 0,	0,	printargs,		"o32_bind"		}, /* 4169 */
	{ 0,	0,	printargs,		"o32_connect"	}, /* 4170 */
	{ 0,	0,	printargs,		"o32_getpeername"	}, /* 4171 */
	{ 0,	0,	printargs,		"o32_getsockname"	}, /* 4172 */
	{ 0,	0,	printargs,		"o32_getsockopt"	}, /* 4173 */
	{ 0,	0,	printargs,		"o32_listen"	}, /* 4174 */
	{ 0,	0,	printargs,		"o32_recv"		}, /* 4175 */
	{ 0,	0,	printargs,		"o32_recvfrom"	}, /* 4176 */
	{ 0,	0,	printargs,		"o32_recvmsg"	}, /* 4177 */
	{ 0,	0,	printargs,		"o32_send"		}, /* 4178 */
	{ 0,	0,	printargs,		"o32_sendmsg"	}, /* 4179 */
	{ 0,	0,	printargs,		"o32_sendto"	}, /* 4180 */
	{ 0,	0,	printargs,		"o32_setsockopt"	}, /* 4181 */
	{ 0,	0,	printargs,		"o32_shutdown"	}, /* 4182 */
	{ 0,	0,	printargs,		"o32_socket"	}, /* 4183 */
	{ 0,	0,	printargs,		"o32_socketpair"	}, /* 4184 */
	{ 0,	0,	printargs,		"o32_setresuid"	}, /* 4185 */
	{ 0,	0,	printargs,		"o32_getresuid"	}, /* 4186 */
	{ 0,	0,	printargs,		"o32_query_module"	}, /* 4187 */
	{ 0,	0,	printargs,		"o32_poll"		}, /* 4188 */
	{ 0,	0,	printargs,		"o32_nfsservctl"	}, /* 4189 */
	{ 0,	0,	printargs,		"o32_setresgid"	}, /* 4190 */
	{ 0,	0,	printargs,		"o32_getresgid"	}, /* 4191 */
	{ 0,	0,	printargs,		"o32_prctl"		}, /* 4192 */
	{ 0,	0,	printargs,		"o32_rt_sigreturn"	}, /* 4193 */
	{ 0,	0,	printargs,		"o32_rt_sigaction"	}, /* 4194 */
	{ 0,	0,	printargs,		"o32_rt_sigprocmask"}, /* 4195 */
	{ 0,	0,	printargs,		"o32_rt_sigpending"	}, /* 4196 */
	{ 0,	0,	printargs,		"o32_rt_sigtimedwait"},/* 4197 */
	{ 0,	0,	printargs,		"o32_rt_sigqueueinfo"},/* 4198 */
	{ 0,	0,	printargs,		"o32_rt_siguspend"	}, /* 4199 */
	{ 0,	0,	printargs,		"o32_pread64"	}, /* 4200 */
	{ 0,	0,	printargs,		"o32_pwrite64"	}, /* 4201 */
	{ 0,	0,	printargs,		"o32_chown"		}, /* 4202 */
	{ 0,	0,	printargs,		"o32_getcwd"	}, /* 4203 */
	{ 0,	0,	printargs,		"o32_capget"	}, /* 4204 */
	{ 0,	0,	printargs,		"o32_capset"	}, /* 4205 */
	{ 0,	0,	printargs,		"o32_sigaltstack"	}, /* 4206 */
	{ 0,	0,	printargs,		"o32_sendfile"	}, /* 4207 */
	{ 5,	TN,	printargs,		"o32_getpmsg"	}, /* 4208 */
	{ 5,	TN,	printargs,		"o32_putpmsg"	}, /* 4209 */
	{ 6,	TD|TM|SI,	printargs,		"o32_mmap2"	}, /* 4210 */
	{ 0,	0,	printargs,		"o32_truncate64"	}, /* 4211 */
	{ 0,	0,	printargs,		"o32_ftruncate64"	}, /* 4212 */
	{ 0,	0,	printargs,		"o32_stat64"	}, /* 4213 */
	{ 0,	0,	printargs,		"o32_lstat64"	}, /* 4214 */
	{ 0,	0,	printargs,		"o32_fstat64"	}, /* 4215 */
	{ 0,	0,	printargs,		"o32_pivot_root"	}, /* 4216 */
	{ 0,	TM,	printargs,		"o32_mincore"	}, /* 4217 */
	{ 0,	TM,	printargs,		"o32_madvise"	}, /* 4218 */
	{ 0,	0,	printargs,		"o32_getdents64"	}, /* 4219 */
	{ 0,	0,	printargs,		"o32_fcntl64"	}, /* 4220 */
	{ 0,	0,	NULL,			NULL		}, /* 4221 */
	{ 0,	0,	printargs,		"o32_gettid"	}, /* 4222 */
	{ 5,	TD,	printargs,		"o32_readahead"	}, /* 4223 */
	{ 5,	TF,	printargs,		"o32_setxattr"	}, /* 4224 */
	{ 5,	TF,	printargs,		"o32_lsetxattr"	}, /* 4225 */
	{ 5,	TD,	printargs,		"o32_fsetxattr"	}, /* 4226 */
	{ 4,	TF,	printargs,		"o32_getxattr"	}, /* 4227 */
	{ 4,	TF,	printargs,		"o32_lgetxattr"	}, /* 4228 */
	{ 4,	TD,	printargs,		"o32_fgetxattr"	}, /* 4229 */
	{ 3,	TF,	printargs,		"o32_listxattr"	}, /* 4230 */
	{ 3,	TF,	printargs,		"o32_llistxattr"	}, /* 4231 */
	{ 3,	TD,	printargs,		"o32_flistxattr"	}, /* 4232 */
	{ 2,	TF,	printargs,		"o32_removexattr"	}, /* 4233 */
	{ 2,	TF,	printargs,		"o32_lremovexattr"	}, /* 4234 */
	{ 2,	TD,	printargs,		"o32_fremovexattr"	}, /* 4235 */
	{ 2,	TS,	printargs,		"o32_tkill"		}, /* 4236 */
	{ 5,	TD|TN,	printargs,		"o32_sendfile64"	}, /* 4237 */
	{ 6,	0,	printargs,		"o32_futex"		}, /* 4238 */
	{ 3,	0,	printargs,		"o32_sched_setaffinity"}, /* 4239 */
	{ 3,	0,	printargs,		"o32_sched_getaffinity"}, /* 4240 */
	{ 2,	0,	printargs,		"o32_io_setup"	}, /* 4241 */
	{ 1,	0,	printargs,		"o32_io_destroy"	}, /* 4242 */
	{ 5,	0,	printargs,		"o32_io_getevents"	}, /* 4243 */
	{ 3,	0,	printargs,		"o32_io_submit"	}, /* 4244 */
	{ 3,	0,	printargs,		"o32_io_cancel"	}, /* 4245 */
	{ 1,	TP|SE,	printargs,		"o32_exit_group"	}, /* 4246 */
	{ 3,	0,	printargs,		"o32_lookup_dcookie"}, /* 4247 */
	{ 1,	TD,	printargs,		"o32_epoll_create"	}, /* 4248 */
	{ 4,	TD,	printargs,		"o32_epoll_ctl"	}, /* 4249 */
	{ 4,	TD,	printargs,		"o32_epoll_wait"	}, /* 4250 */
	{ 5,	TM|SI,	printargs,		"o32_remap_file_pages"}, /* 4251 */
	{ 1,	0,	printargs,		"o32_set_tid_address"}, /* 4252 */
	{ 0,	0,	printargs,		"o32_restart_syscall"}, /* 4253 */
	{ MA,	0,	printargs,		"o32_fadvise64_64"	}, /* 4254 */
	{ 3,	TF,	printargs,		"o32_statfs64"	}, /* 4255 */
	{ 2,	TD,	printargs,		"o32_fstatfs64"	}, /* 4256 */
	{ 3,	0,	printargs,		"o32_timer_create"	}, /* 4257 */
	{ 4,	0,	printargs,		"o32_timer_settime"	}, /* 4258 */
	{ 2,	0,	printargs,		"o32_timer_gettime"	}, /* 4259 */
	{ 1,	0,	printargs,		"o32_timer_getoverrun"}, /* 4260 */
	{ 1,	0,	printargs,		"o32_timer_delete"	}, /* 4261 */
	{ 2,	0,	printargs,		"o32_clock_settime"	}, /* 4262 */
	{ 2,	0,	printargs,		"o32_clock_gettime"	}, /* 4263 */
	{ 2,	0,	printargs,		"o32_clock_getres"	}, /* 4264 */
	{ 4,	0,	printargs,		"o32_clock_nanosleep"}, /* 4265 */
	{ 3,	TS,	printargs,		"o32_tgkill"	}, /* 4266 */
	{ 2,	TF,	printargs,		"o32_utimes"	}, /* 4267 */
	{ 4,	TM,	printargs,		"o32_mbind"		}, /* 4268 */
	{ 5,	TM,	printargs,		"o32_get_mempolicy"	}, /* 4269 */
	{ 3,	TM,	printargs,		"o32_set_mempolicy"	}, /* 4270 */
	{ 4,	0,	printargs,		"o32_mq_open"	}, /* 4271 */
	{ 1,	0,	printargs,		"o32_mq_unlink"	}, /* 4272 */
	{ 5,	0,	printargs,		"o32_mq_timedsend"	}, /* 4273 */
	{ 5,	0,	printargs,		"o32_mq_timedreceive"}, /* 4274 */
	{ 2,	0,	printargs,		"o32_mq_notify"	}, /* 4275 */
	{ 3,	0,	printargs,		"o32_mq_getsetattr"	}, /* 4276 */
	{ 5,	0,	printargs,		"o32_vserver"	}, /* 4277 */
	{ 5,	TP,	printargs,		"o32_waitid"	}, /* 4278 */
	{ 0,	0,	printargs,		"o32_SYS_4279"	}, /* 4279 */
	{ 5,	0,	printargs,		"o32_add_key"	}, /* 4280 */
	{ 4,	0,	printargs,		"o32_request_key"	}, /* 4281 */
	{ 5,	0,	printargs,		"o32_keyctl"	}, /* 4282 */
	{ 1,	0,	printargs,		"o32_set_thread_area" }, /* 4283 */
	{ 0,	TD,	printargs,		"o32_inotify_init"	}, /* 4284 */
	{ 3,	TD,	printargs,		"o32_inotify_add_watch" }, /* 4285 */
	{ 2,	TD,	printargs,		"o32_inotify_rm_watch" }, /* 4286 */
	{ 4,	TM,	printargs,		"o32_migrate_pages"	}, /* 4287 */
	{ 4,	TD|TF,	printargs,		"o32_openat"	}, /* 4288 */
	{ 3,	TD|TF,	printargs,		"o32_mkdirat"	}, /* 4289 */
	{ 4,	TD|TF,	printargs,		"o32_mknodat"	}, /* 4290 */
	{ 5,	TD|TF,	printargs,		"o32_fchownat"	}, /* 4291 */
	{ 3,	TD|TF,	printargs,		"o32_futimesat"	}, /* 4292 */
	{ 4,	TD|TF,	printargs,		"o32_fstatat64"	}, /* 4293 */
	{ 3,	TD|TF,	printargs,		"o32_unlinkat"	}, /* 4294 */
	{ 4,	TD|TF,	printargs,		"o32_renameat"	}, /* 4295 */
	{ 5,	TD|TF,	printargs,		"o32_linkat"	}, /* 4296 */
	{ 3,	TD|TF,	printargs,		"o32_symlinkat"	}, /* 4297 */
	{ 4,	TD|TF,	printargs,		"o32_readlinkat"	}, /* 4298 */
	{ 3,	TD|TF,	printargs,		"o32_fchmodat"	}, /* 4299 */
	{ 3,	TD|TF,	printargs,		"o32_faccessat"	}, /* 4300 */
	{ 6,	TD,	printargs,		"o32_pselect6"	}, /* 4301 */
	{ 5,	TD,	printargs,		"o32_ppoll"		}, /* 4302 */
	{ 1,	TP,	printargs,		"o32_unshare"	}, /* 4303 */
	{ 6,	TD,	printargs,		"o32_splice"	}, /* 4304 */
	{ 4,	TD,	printargs,		"o32_sync_file_range" }, /* 4305 */
	{ 4,	TD,	printargs,		"o32_tee"	}, /* 4306 */
	{ 4,	TD,	printargs,		"o32_vmsplice"	}, /* 4307 */
	{ 6,	TM,	printargs,		"o32_move_pages"	}, /* 4308 */
	{ 2,	0,	printargs,		"o32_set_robust_list" }, /* 4309 */
	{ 3,	0,	printargs,		"o32_get_robust_list" }, /* 4310 */
	{ 4,	0,	printargs,		"o32_kexec_load" }, /* 4311 */
	{ 3,	0,	printargs,		"o32_getcpu"	}, /* 4312 */
	{ 5,	TD,	printargs,		"o32_epoll_pwait"	}, /* 4313 */
	{ 3,	0,	printargs,		"o32_ioprio_set" }, /* 4314 */
	{ 2,	0,	printargs,		"o32_ioprio_get" }, /* 4315 */
	{ 4,	0,	printargs,		"o32_utimensat"	}, /* 4316 */
	{ 3,	TD|TS,	printargs,		"o32_signalfd"	}, /* 4317 */
	{ 4,	TD,	printargs,		"o32_timerfd"	}, /* 4318 */
	{ 1,	TD,	printargs,		"o32_eventfd"	}, /* 4319 */
	{ 6,	TD,	printargs,		"o32_fallocate"	}, /* 4320 */
	{ 2,	TD,	printargs,		"o32_timerfd_create" }, /* 4321 */
	{ 2,	TD,	printargs,		"o32_timerfd_gettime" }, /* 4322 */
	{ 4,	TD,	printargs,		"o32_timerfd_settime" }, /* 4323 */
	{ 4,	TD|TS,	printargs,		"o32_signalfd4"	}, /* 4324 */
	{ 2,	TD,	printargs,		"o32_eventfd2"	}, /* 4325 */
	{ 1,	TD,	printargs,		"o32_epoll_create1" }, /* 4326 */
	{ 3,	TD,	printargs,		"o32_dup3"	}, /* 4327 */
	{ 2,	TD,	printargs,		"o32_pipe2"	}, /* 4328 */
	{ 1,	TD,	printargs,		"o32_inotify_init1" }, /* 4329 */
	{ 5,	TD,	printargs,		"o32_preadv"	}, /* 4330 */
	{ 5,	TD,	printargs,		"o32_pwritev"	}, /* 4331 */
	{ 4,	TP|TS,	printargs,		"o32_rt_tgsigqueueinfo" }, /* 4332 */
	{ 5,	TD,	printargs,		"o32_perf_event_open" }, /* 4333 */
	{ 4,	TN,	printargs,		"o32_accept4"	}, /* 4334 */
	{ 5,	TN,	printargs,		"o32_recvmmsg"	}, /* 4335 */
	{ 2,	TD,	printargs,		"o32_fanotify_init" }, /* 4336 */
	{ 6,	TD|TF,	printargs,		"o32_fanotify_mark" }, /* 4337 */
	{ 4,	0,	printargs,		"o32_prlimit64"	}, /* 4338 */
	{ 5,	TD|TF,	printargs,		"o32_name_to_handle_at"}, /* 4339 */
	{ 3,	TD,	printargs,		"o32_open_by_handle_at"}, /* 4340 */
	{ 2,	0,	printargs,		"o32_clock_adjtime" }, /* 4341 */
	{ 1,	TD,	printargs,		"o32_syncfs"	}, /* 4342 */
	{ 4,	TN,	printargs,		"o32_sendmmsg"	}, /* 4343 */
	{ 2,	TD,	printargs,		"o32_setns"	}, /* 4344 */
	{ 6,	0,	printargs,		"o32_process_vm_readv"	}, /* 4345 */
	{ 6,	0,	printargs,		"o32_process_vm_writev"	}, /* 4346 */
	{ 5,	0,	printargs,		"o32_kcmp"		}, /* 4347 */
	{ 3,	TD,	printargs,		"o32_finit_module"	}, /* 4348 */
	{ 3,	0,	printargs,		"o32_sched_setattr"	}, /* 4349 */
	{ 4,	0,	printargs,		"o32_sched_getattr"	}, /* 4350 */
	{ 5,	TD|TF,	printargs,		"o32_renameat2"	}, /* 4351 */
#endif
	[4349 ... 4999] = { }, /* 4999 */ /* end of Linux o32 */
