#!/bin/sh
# ./debian/repack
# Repackage the AST source files as a DFSG tarball, with unnecessary
# files removed to avoid license conflicts.

TMPDIR=$(mktemp --directory)
trap "rm -fr ${TMPDIR} || exit 1" EXIT INT TERM

ver=$2
orig_tar=$3
tardir=$(dirname $orig_tar)

tar xf $orig_tar -C $TMPDIR 
srcdir=$TMPDIR/*
echo $srcdir
rm -rf $srcdir/sofa* $srcdir/pal* $srcdir/Ers.h \
       $srcdir/erfa* $srcdir/cminpack* \
       $srcdir/sun???.htx_tar $srcdir/sun???.ps $srcdir/sun???.pdf

dfsg_tar=$tardir/starlink-ast_$ver+dfsg.orig.tar.gz
tar czf $dfsg_tar -C $TMPDIR .

exec uupdate --no-symlink --upstream-version $ver+dfsg $dfsg_tar
