#include <pthread.h>
#include <gtk/gtk.h>
#include <getopt.h>
#include <string.h>
#include "specimen.h"
#include "gui/gui.h"
#include "midi.h"
#include "driver.h"
#include "lfo.h"
#include "patch.h"
#include "mixer.h"
#include "beef.h"
#ifdef HAVE_LASH
#include "lashdriver.h"
#endif

void show_usage (void)
{
	fprintf (stderr, "\nUsage: specimen [options] [bankname]\n");
	fprintf (stderr, "Options:\n");
	fprintf (stderr, "        -n, --name <client_name>  Specify jack client name\n");
	fprintf (stderr, "        -h, --help                Display this help message\n");
	fprintf (stderr, "For more information see http://zhevny.com/specimen/\n");
}

int main(int argc, char *argv[])
{
     int opt;
     int longopt_index;
     char* client_name = NULL;
     static struct option long_options[] = 
     {
        { "name", 1, 0, 'n'},
        { "help", 0, 0, 'h'},
        { 0, 0, 0, 0}
     };

     /* command line argument processing */
     while((opt = getopt_long(argc, argv, "n:h", long_options, &longopt_index))>0)
     {
        switch(opt){
	    case 'n':
	        client_name = strdup(optarg);
		    break;
	    case 'h':
	        show_usage();
            return 1;
		    break;
        default:
            show_usage();
            return 1;
            break;
	    }
     }
     
     /* constructors */
#ifdef HAVE_LASH
     /* FIXME: use client_name in lashdriver_init */
     lashdriver_init(&argc, &argv);
#endif
     /* FIXME: use client_name in gtk_init */
     gtk_init(&argc, &argv);
     driver_init();
     lfo_init();
     mixer_init();
     patch_init();
     gui_init();

     if (optind < argc) 
     {
	     beef_read(argv[optind]);
		 gui_refresh();
     }

     /* start */
     midi_start();
     driver_start(0, client_name);
#ifdef HAVE_LASH
     lashdriver_start();
#endif
     gtk_main();

     /* stop */
     midi_stop();
     driver_stop();

     /* destructors */
     patch_shutdown();
     mixer_shutdown();

     debug("Goodbye.\n");
     return 0;
}

