<?php

require_once dirname(__FILE__) . '/forwards.php';

/**
 * Vacation_Driver_qmail implements the Vacation_Driver API for ftp driven
 * qmail mail servers.  This depends on Peter Samuel's qmail-vacation program.
 *
 * $Horde: vacation/lib/Driver/qmail.php,v 1.27.2.5 2009/01/06 15:28:08 jan Exp $
 *
 * Copyright 2001-2009 The Horde Project (http://www.horde.org/)
 *
 * See the enclosed file LICENSE for license information (BSD). If you
 * did not receive this file, see http://www.horde.org/licenses/bsdl.php.
 *
 * @author  Eric Rostetter <eric.rostetter@physics.utexas.edu>
 * @author  Jan Schneider <jan@horde.org>
 * @since   Vacation 2.2
 * @package Vacation
 */
class Vacation_Driver_qmail extends Vacation_Driver_forwards {

    /**
     * Runs any code required before creating the vacation file.
     */
    function _setVacationPreCheck()
    {
        // Clean up old backup and move existing .qmail .
        if ($this->_vfs->exists('', '.qmail_horde')) {
            return PEAR::raiseError(_("Vacation notice already exists."));
        }
        if ($this->_vfs->exists('', '.qmail')) {
            return $this->_vfs->rename('', '.qmail', '', '.qmail_horde');
        }
    }

    /**
     * Creates the main vacation file.
     *
     * @param string $alias  The alias email address.
     */
    function _createVacationFile($alias)
    {
        // Parse the email address and alias address passed in.
        $my_email = $this->_makeEmailAddress($this->_user);
        if (is_a($my_email, 'PEAR_Error')) {
            return $my_email;
        }
        if (!empty($alias)) {
            $alias = $this->_makeEmailAddress($alias);
            if (is_a($alias, 'PEAR_Error')) {
                return $alias;
            }
        }

        // Now set up the .forward file.
        if (!empty($alias) && $alias != $my_email) {
            $contents = '| ' . $GLOBALS['conf']['vacation']['path'] .
                " -a $alias $my_email\n./Maildir/";
        } else {
            $contents = '| ' . $GLOBALS['conf']['vacation']['path'] .
                " $my_email\n./Maildir/";
        }
        $status = $this->_vfs->writeData('', '.qmail', $contents);
        if (is_a($status, 'PEAR_Error')) {
            return $status;
        }

        // Try to change the permissions, but ignore any errors.
        $this->_vfs->changePermissions('', '.qmail', '0600');
    }

    /**
     * Deletes the main vacation file.
     */
    function _deleteVacationFile()
    {
        // Restore previous .qmail, if any.
        if ($this->_vfs->exists('', '.qmail_horde')) {
            return $this->_vfs->rename('', '.qmail_horde', '', '.qmail');
        }
        return $this->_vfs->deleteFile('', '.qmail');
    }

    /**
     * Retrieves the current vacation details for the user.
     *
     * @param string $password  The password for user.
     *
     * @return array  Vacation details or PEAR_Error on failure.
     */
    function _getUserDetails($password)
    {
        if (!is_null($this->_details)) {
            return $this->_details;
        }

        if (is_a($checked = $this->_checkConfig(), 'PEAR_Error')) {
            return $checked;
        }

        // Connect to the server.
        if (is_a($connected = $this->_connect($password),
                 'PEAR_Error')) {
            return $connected;
        }

        if ($this->_vfs->exists('', '.vacation.msg')) {
            $message = $this->_vfs->read('', '.vacation.msg');
            if (is_a($message, 'PEAR_Error')) {
                return $message;
            }
            $this->_details = $this->_parseMessage($message);
            $this->_details['vacation'] = 'y';
        } else {
            $this->_details = array('vacation' => false);
        }

        return $this->_details;
    }

}
