/*
 * Copyright (C) 2001 Dan Dennedy <dan@dennedy.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
using std::cerr;
using std::endl;

#include "preferences.h"

#include <string.h>

#ifdef NEED_GNOMESUPPORT_H
#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-config.h>
#else
#include "gnome-stubs.h"
#endif

/** The global prefs object.
    It is accessible to other classes via the getInstance method.
*/

Preferences *Preferences::instance = NULL;

/** Singleton getInstance method. Standard pattern followed, non threadsafe
	but not required (at the moment) since it gets called before any threading
	is activated. Keep an eye on it though.

	\returns the single instance of Preferences.
*/

Preferences &Preferences::getInstance() {
	if ( instance == NULL )
		instance = new Preferences;
	return *instance;
}

/** The constructor loads the user preferences.

    Since this uses gnome-config, preferences are typically
    loaded from ~/.gnome/kino.
*/
Preferences::Preferences() {
    gchar *tempString;

    gnome_config_push_prefix("/kino/general/");

    maxUndos = gnome_config_get_int( "maxUndos=50" );
    dvDecoderAddNTSCSetup = gnome_config_get_bool( "dvDecoderAddNTSCSetup=false" );
    dvDecoderClampLuma = gnome_config_get_bool("dvDecoderClampLuma=false");
    dvDecoderClampChroma = gnome_config_get_bool("dvDecoderClampChroma=false");
    tempString = gnome_config_get_string( "defaultDirectory=~/" );
    if (tempString) {
        strncpy( defaultDirectory, tempString, 254);
        g_free(tempString);
    }
    deinterlacePreview = gnome_config_get_bool( "deinterlacePreview=false" );
    relativeSave = gnome_config_get_bool( "relativeSave=false" );

    gnome_config_pop_prefix();
}

/** Save the user preferences.
*/

/// Save the user preferences.
void
Preferences::Save() {
#ifdef NEED_GNOME_SUPPORT_H
    gnome_config_push_prefix("/kino/general/");

    gnome_config_set_int("maxUndos", maxUndos);
    gnome_config_set_bool("dvDecoderAddNTSCSetup", dvDecoderAddNTSCSetup);
    gnome_config_set_bool("dvDecoderClampLuma", dvDecoderClampLuma);
    gnome_config_set_bool("dvDecoderClampChroma", dvDecoderClampChroma);
    gnome_config_set_string("defaultDirectory", defaultDirectory);
    gnome_config_set_bool("deinterlacePreview", deinterlacePreview);
    gnome_config_set_bool("relativeSave", relativeSave);
    gnome_config_pop_prefix();

    gnome_config_sync();
#endif
}
