/*
 * Print list of free Cray XT/XE nodes to stdout.
 */
#include "basil_alps.h"
#include "cmdline.h"

extern char *unescape(const char const *orig);
extern void ns_print_pdsh_format(const struct nodespec *head, FILE *fp);

int main(int argc, char **argv)
{
	struct gengetopt_args_info args;
	struct nodespec *free_nodes, *cur;
	enum basil_version version;
	const char const *nid_fmt[] = { "%u", "%#x" };
	char *sep = NULL;
	int i, idx = 0;	/* set to 1 for hex format */

	if (cmdline_parser(argc, argv, &args) != 0)
		exit(EXIT_FAILURE);

	if (args.engine_flag) {
		char alps_engine[BASIL_STRING_LONG];

		if (get_alps_engine(alps_engine, sizeof(alps_engine)) == NULL)
			errx(1, "can not determine ALPS engine");
		printf("Using ALPS Engine %s\n", alps_engine);
		exit(EXIT_SUCCESS);
	}

	version    = get_basil_version();
	free_nodes = get_free_nodes(version);

	if (args.count_flag) {
		i = ns_count_nodes(free_nodes);
		fprintf(stderr, "%u free node%s\n", i, i == 1 ? "" : "s");
	}

	if (args.nodename_flag && !args.uncompressed_flag) {
		ns_print_pdsh_format(free_nodes, stdout);
		goto done;
	}

	sep = unescape(args.separator_arg);
	for (cur = free_nodes; cur; cur = cur->next) {
		if (cur != free_nodes)
			printf("%s", sep);
		printf(nid_fmt[idx], cur->start);

		if (args.uncompressed_flag) {
			for (i = cur->start + 1; i <= cur->end; i++) {
				printf("%s", sep);
				printf(nid_fmt[idx], i);
			}
		} else if (cur->start != cur->end) {
			printf("-");
			printf(nid_fmt[idx], cur->end);
		}
	}
done:
	if (free_nodes)
		printf("\n");
	free_nodespec(free_nodes);
	free(sep);

	return EXIT_SUCCESS;
}
