/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A skrooge plugin to payee operations
 *
 * @author Stephane MANKOWSKI
 */
#include "skgpayeeplugin.h"
#include "skgpayeepluginwidget.h"
#include "skgpayee_settings.h"
#include "skgtraces.h"
#include "skgdocumentbank.h"

#include <kactioncollection.h>
#include <kstandardaction.h>

/**
 * This plugin factory.
 */
K_PLUGIN_FACTORY(SKGPayeePluginFactory, registerPlugin<SKGPayeePlugin>();)
/**
 * This plugin export.
 */
K_EXPORT_PLUGIN(SKGPayeePluginFactory("skrooge_payee", "skrooge_payee"))

SKGPayeePlugin::SKGPayeePlugin(QObject* iParent, const QVariantList& /*iArg*/) : SKGInterfacePlugin(iParent)
{
    SKGTRACEIN(10, "SKGPayeePlugin::SKGPayeePlugin");
}

SKGPayeePlugin::~SKGPayeePlugin()
{
    SKGTRACEIN(10, "SKGPayeePlugin::~SKGPayeePlugin");
    currentBankDocument=NULL;
}

bool SKGPayeePlugin::setupActions(SKGDocument* iDocument, const QStringList& iArgument)
{
    SKGTRACEIN(10, "SKGPayeePlugin::setupActions");
    Q_UNUSED(iArgument);
    if (dynamic_cast<SKGDocumentBank*>(iDocument)==NULL) return false;

    currentBankDocument=iDocument;


    setComponentData( SKGPayeePluginFactory::componentData() );
    setXMLFile("skrooge_payee.rc");

    //Create yours actions here
    return true;
}

void SKGPayeePlugin::refresh()
{
    SKGTRACEIN(10, "SKGPayeePlugin::refresh");
}

void SKGPayeePlugin::close()
{
    SKGTRACEIN(10, "SKGPayeePlugin::close");
}

SKGTabPage* SKGPayeePlugin::getWidget()
{
    SKGTRACEIN(10, "SKGPayeePlugin::getWidget");
    return new SKGPayeePluginWidget(currentBankDocument);
}

QWidget* SKGPayeePlugin::getPreferenceWidget()
{
    SKGTRACEIN(10, "SKGPayeePlugin::getPreferenceWidget");
    //QWidget* widget=new QWidget();
    //ui.setupUi(widget);

    return NULL;
}

KConfigSkeleton* SKGPayeePlugin::getPreferenceSkeleton()
{
    return skgpayee_settings::self();
}

QString SKGPayeePlugin::title() const
{
    return i18nc("Noun, something that is used to track items","Payees");
}

QString SKGPayeePlugin::icon() const
{
    return "skrooge_payee";
}

QString SKGPayeePlugin::toolTip () const
{
    return i18nc("A tool tip", "Payees management");
}

int SKGPayeePlugin::getOrder() const
{
    return 28;
}

QStringList SKGPayeePlugin::tips() const
{
    QStringList output;
    output.push_back(i18nc("Description of a tips", "<p>... payees can be merged by drag & drop.</p>"));
    return output;
}

bool SKGPayeePlugin::isInContext() const
{
    return true;
}

#include "skgpayeeplugin.moc"
