/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * Display a summary of your information.
 *
 * @author Siddharth SHARMA
 *
 */

#include "skgdashboard2pluginwidget.h"
#include "skgdashboard2applet.h"
#include "skgmainpanel.h"
#include "skgtraces.h"
#include "skgdocument.h"
#include "skginterfaceplugin.h"

#include <QDomDocument>
#include <QGraphicsProxyWidget>
#include <QtGui/QGraphicsLinearLayout>


#include <KAction>
#include <KMessageBox>

#include <Plasma/Applet>
#include <plasma/corona.h>
#include <plasma/popupapplet.h>
#include <Plasma/Corona>
#include <plasma/containmentactions.h>
#include <plasma/view.h>

//#include "skgdashboard2widgetwrapper.h"

SKGDashboard2PluginWidget::SKGDashboard2PluginWidget ( SKGDocument* iDocument )
        :SKGTabPage ( iDocument )
{
    SKGTRACEIN ( 1, "SKGDashboard2PluginWidget::SKGDashboard2PluginWidget" );

    ui.setupUi ( this );
    KService::Ptr service = KService::serviceByDesktopPath( "plasma-kpart.desktop" );

    if (service)
    {
        QVariantList args = QVariantList() << "Online Services";

        plasmadashboard = service->createInstance<KParts::Part>(0,args);

        if (plasmadashboard)
        {
            ui.verticalLayout_6->addWidget(plasmadashboard->widget());
        }
        else
        {

            KMessageBox::error(this, i18n("Could not instantiate our Part!"));
        }
    }
    else
    {
        // if we couldn't find our Part, we exit since the Shell by
        // itself can't do anything useful
        KMessageBox::error(this, i18n("Could not find our Part!"));
    }

//new SKGDashboard2WidgetWrapper("Skrooge calculator plugin-0");

//plasmadashboard->componentData(new SKGDashboard2WidgetWrapper("Skrooge calculator plugin-0"));
//addApplet(new SKGDashboard2WidgetWrapper("Skrooge calculator plugin-0"));


//Creation of the Corona
    /*    dashboardCorona = new Plasma::Corona ( this );
        if ( dashboardCorona )
        {
            //Creation of the plasma containment
            containment = dashboardCorona->addContainment ("desktop");
            //Add plasma view in page
            view=new Plasma::View ( containment, this );
            //view->setWallpaperEnabled(false);
            view->setTrackContainmentChanges ( true );
            ui.verticalLayout_6->addWidget ( view );
            view->installEventFilter ( this );

            //Build menu
            int index=0;
            int nbdbw=0;
            while ( index>=0 )
            {
                SKGInterfacePlugin* plugin=SKGMainPanel::getMainPanel()->getPluginByIndex ( index );
                if ( plugin )
                {
                    nbdbw=plugin->getNbDashboardWidgets();
                    for ( int j=0; j<nbdbw; ++j )
                    {
                        //Create menu
                        QAction* act = new KAction ( KIcon ( plugin->icon() ), plugin->getDashboardWidgetTitle(j),this );
                        act->setData ( plugin->objectName() +'-'+SKGServices::intToString ( j ) );
                        containment->addToolBoxAction ( act );
                        connect ( act, SIGNAL ( triggered ( bool ) ), this, SLOT ( onAddWidget() ) );
                    }
                }
                else index=-2;
                ++index;

            }
            // Action for locking skroogoids
            lockAction = new KAction ( KIcon ( "object-locked" ),"Lock Skroogoids",this );
            containment->addToolBoxAction (lockAction );
            connect (lockAction, SIGNAL ( triggered ( bool ) ), this, SLOT ( toggleImmutability() ) );

            // removed unwanted actions from ToolBox
            containment->removeToolBoxAction(containment->action("zoom in"));
            containment->removeToolBoxAction(containment->action("add widgets"));
            containment->removeToolBoxAction(containment->action("configure"));
            containment->removeToolBoxAction(containment->action("remove"));
            containment->removeToolBoxAction(containment->action("add page"));
            containment->removeToolBoxAction(containment->action("lock page"));
        }
    */

}
/*
// Function for toggling Dashboard lock for Skroogoids
void SKGDashboard2PluginWidget::toggleImmutability()
{
    if (lockAction && containment)
    {
        if (containment->immutability()==Plasma::SystemImmutable) {
            containment->setImmutability(Plasma::Mutable);
            lockAction->setIcon ( KIcon ( "object-locked" ) );
            lockAction->setText("Lock Skroogoids");

        }
        else if (containment->immutability()== Plasma::Mutable) {
            containment->setImmutability(Plasma::SystemImmutable);
            lockAction->setIcon ( KIcon ( "object-unlocked" ) );
            lockAction->setText("Unlock Skroogoids");
        }
    }
}
*/
SKGDashboard2PluginWidget::~SKGDashboard2PluginWidget()
{
    /*  SKGTRACEIN ( 1, "SKGDashboard2PluginWidget::~SKGDashboard2PluginWidget" );
      containment=NULL;
      view=NULL;
      lockAction=NULL;
      dashboardCorona=NULL;
    */ }
/*
// i want to supply index number here of the plugin relative to function call
void SKGDashboard2PluginWidget::onAddWidget()
{
    QAction* sender=dynamic_cast<QAction*> ( this->sender() );
    if ( sender )
    {
        QString id=sender->data().toString();
        QStringList param=SKGServices::splitCSVLine ( id,'-' );

        SKGInterfacePlugin* db=SKGMainPanel::getMainPanel()->getPluginByName ( param.at ( 0 ) );
        if ( db )
        {
            SKGWidget* dbw=db->getDashboardWidget ( SKGServices::stringToInt ( param.at ( 1 ) ) );
            if ( dbw )
            {
                SKGDashboard2Applet* applet=new SKGDashboard2Applet(this, QVariantList());
                applet->setSKGWidget(dbw);
                applet->setData(12, id);
                containment->addApplet(applet, QPointF(-1,-1), false);

            }
        }
    }
}


QString SKGDashboard2PluginWidget::getState()
{
    SKGTRACEIN ( 10, "SKGDashboard2PluginWidget::getState" );
    QDomDocument doc ( "SKGML" );
    QDomElement root = doc.createElement ( "dashboard2" );
    doc.appendChild ( root );

    Plasma::Applet::List apps=containment->applets();
    int nb=apps.count();
    for (int i=0; i<nb; ++i)
    {
        SKGDashboard2Applet* applet=dynamic_cast<SKGDashboard2Applet*>(apps.at(i));
        if (applet)
        {
            QDomElement element = doc.createElement ( "ITEM-"+SKGServices::intToString ( i+1 ) );
            root.appendChild ( element );

            QStringList param=SKGServices::splitCSVLine ( applet->data(12).toString(),'-' );
            SKGWidget* item=applet->getSKGWidget();

            if ( item && param.count()==2 )
            {
                element.setAttribute ( "name", param.at ( 0 ) );
                element.setAttribute ( "index", param.at ( 1 ) );
                element.setAttribute ( "state", item->getState() );
                element.setAttribute("height",SKGServices::doubleToString(applet->geometry().height()));
                element.setAttribute("width",SKGServices::doubleToString(applet->geometry().width()));
                element.setAttribute("x",SKGServices::doubleToString(applet->geometry().x()));
                element.setAttribute("y",SKGServices::doubleToString(applet->geometry().y()));
            }
        }
    }

    return doc.toString();
}

void SKGDashboard2PluginWidget::setState ( const QString& iState )
{
    SKGTRACEIN ( 10, "SKGDashboard2PluginWidget::setState" );
    if ( !iState.isEmpty() )
    {
        QDomDocument doc ( "SKGML" );
        doc.setContent ( iState );
        QDomElement root = doc.documentElement();

        int i=1;
        while ( i>0 )
        {
            QDomElement element=root.firstChildElement ( "ITEM-"+SKGServices::intToString ( i ) );
            if ( !element.isNull() )
            {
                QString name=element.attribute ( "name");
                QString index=element.attribute ( "index" );
                SKGInterfacePlugin* plugin=SKGMainPanel::getMainPanel()->getPluginByName ( name );
                if ( index.isEmpty() ) index='0';
                if ( plugin )
                {
                    SKGWidget* dbw=plugin->getDashboardWidget ( SKGServices::stringToInt ( index ) );
                    if ( dbw )
                    {
                        SKGDashboard2Applet* applet=new SKGDashboard2Applet(this, QVariantList());
                        applet->setSKGWidget(dbw);
                        applet->setData(12, name+'-'+index);
                        QPointF pos(-1, -1);
                        if (!element.attribute("x").isEmpty())
                            pos=QPointF(SKGServices::stringToDouble(element.attribute("x")), SKGServices::stringToDouble(element.attribute("y")));
                        containment->addApplet(applet, pos, false);
                        dbw->setState(element.attribute ( "state" ));

                        if (!element.attribute("width").isEmpty())
                            applet->resize(QSizeF(SKGServices::stringToDouble(element.attribute("width")), SKGServices::stringToDouble(element.attribute("height"))));
                    }
                }
            }
            else i=-1;
            ++i;
        }
    }
}

QString SKGDashboard2PluginWidget::getDefaultStateAttribute()
{
    return "SKGDASHBOARD_DEFAULT_PARAMETERS";
}

QWidget* SKGDashboard2PluginWidget::getWidgetForPrint()
{
    return this;
}

void SKGDashboard2PluginWidget::resizeContainment()
{
    SKGTRACEIN ( 1, "SKGDashboard2PluginWidget::resizeContainment" );
    // Set up the containment
    QSizeF parentSize = qobject_cast< const QWidget* > ( this )->size();
    containment->resize ( parentSize.width(),parentSize.height() );
}

bool SKGDashboard2PluginWidget::eventFilter ( QObject *object, QEvent *event )
{
    if ( object==view &&  event && event->type() ==QEvent::Resize )
    {
        resizeContainment();
    }
    return QWidget::eventFilter ( object, event );
}
*/
#include "skgdashboard2pluginwidget.moc"
