/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * Display a summary of your information
 *
 * @author Siddharth SHARMA
 */
#include "skgdashboard2plugin.h"
#include "skgdashboard2pluginwidget.h"
#include "skgdashboard2_settings.h"
#include "skgtraces.h"

#include <kactioncollection.h>
#include <kstandardaction.h>

/**
 * This plugin factory.
 */
K_PLUGIN_FACTORY(SKGDashboard2PluginFactory, registerPlugin<SKGDashboard2Plugin>();)
/**
 * This plugin export.
 */
K_EXPORT_PLUGIN(SKGDashboard2PluginFactory("skg_dashboard2", "skg_dashboard2"))

SKGDashboard2Plugin::SKGDashboard2Plugin(QObject* iParent, const QVariantList& /*iArg*/) : SKGInterfacePlugin(iParent)
{
    SKGTRACEIN(10, "SKGDashboard2Plugin::SKGDashboard2Plugin");
}

SKGDashboard2Plugin::~SKGDashboard2Plugin()
{
    SKGTRACEIN(10, "SKGDashboard2Plugin::~SKGDashboard2Plugin");
    currentBankDocument=NULL;
}

bool SKGDashboard2Plugin::setupActions(SKGDocument* iDocument, const QStringList& iArgument)
{
    SKGTRACEIN(10, "SKGDashboard2Plugin::setupActions");
    Q_UNUSED(iArgument);

    currentBankDocument=iDocument;

    setComponentData( SKGDashboard2PluginFactory::componentData() );
    setXMLFile("skg_dashboard2.rc");

    //Create yours actions here
    return true;
}

void SKGDashboard2Plugin::refresh()
{
    SKGTRACEIN(10, "SKGDashboard2Plugin::refresh");
}

void SKGDashboard2Plugin::close()
{
    SKGTRACEIN(10, "SKGDashboard2Plugin::close");
}

SKGTabPage* SKGDashboard2Plugin::getWidget()
{
    SKGTRACEIN(10, "SKGDashboard2Plugin::getWidget");
    return new SKGDashboard2PluginWidget(currentBankDocument);
}

QWidget* SKGDashboard2Plugin::getPreferenceWidget()
{
    SKGTRACEIN(10, "SKGDashboard2Plugin::getPreferenceWidget");
    QWidget* widget=new QWidget();
    ui.setupUi(widget);

    return widget;
}

KConfigSkeleton* SKGDashboard2Plugin::getPreferenceSkeleton()
{
    return skgdashboard2_settings::self();
}

SKGError SKGDashboard2Plugin::savePreferences() const
{
    return SKGError();
}

QString SKGDashboard2Plugin::title() const
{
    return i18nc("A title", "Plasma dashboard");
}

QString SKGDashboard2Plugin::icon() const
{
    return "plasma";
}

QString SKGDashboard2Plugin::toolTip () const
{
    return i18nc("A tool tip", "Display a summary of your information");
}


int SKGDashboard2Plugin::getOrder() const
{
    return 999;
}

QStringList SKGDashboard2Plugin::tips() const
{
    QStringList output;
    output.push_back(i18nc("Description of a tips", "<p>... the plasma dashboard is fully customizable</p>"));
    return output;
}

bool SKGDashboard2Plugin::isInContext() const
{
    return true;
}

#include "skgdashboard2plugin.moc"
