# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Git
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/v6/sitemaps.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: sitemap created from document parameters

=end
module SiSU_Sitemaps
  require_relative 'dp'                                 # dp.rb
    include SiSU_Param
  require_relative 'se'                                 # se.rb
    include SiSU_Env
  require_relative 'xml_shared'                         # xml_shared.rb
    include SiSU_XML_Munge
  class Source
    def initialize(opt)
      @opt=opt
    end
    def read
      songsheet
    end
    def songsheet
      begin
        @sys=SiSU_Env::SystemCall.new
        fn_set_lang=SiSU_Env::StandardiseLanguage.new(@opt.lng).language
        @fn=SiSU_Env::EnvCall.new(@opt.fns).lang(fn_set_lang[:c])
        if @opt.act[:sitemap][:set]==:on
          @md=SiSU_Param::Parameters.new(@opt).get
          @trans=SiSU_XML_Munge::Trans.new(@md) #check @md is required
          @env=SiSU_Env::InfoEnv.new(@md.fns)
#         @file=SiSU_Env::FileOp.new(@md)
          @rdf=SiSU_XML_Tags::RDF.new(@md)
          @fnb_utf8_xml=@md.fnb.dup
          @trans.char_enc.utf8(@fnb_utf8_xml) \
            if @sys.locale =~/utf-?8/i
          output_map(sitemap)
        elsif @opt.selections.str =~/--sitemaps/
          @sitemap_idx_fn='sitemapindex.xml'
          @env=SiSU_Env::InfoEnv.new
          output_idx(sitemap_index)
          SiSU_Screen::Ansi.new(
            @opt.act[:color_state][:set],
            'sitemap index:',
            "#{@env.path.output}/#{@sitemap_idx_fn}"
          ).result unless @opt.act[:quiet][:set]==:on
        end
      rescue
        SiSU_Errors::Rescued.new($!,$@,@opt.cmd,@opt.fns).location do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
      end
    end
    def make_file(path,filename)
      (File.writable?("#{path}/.")) \
      ? (File.new("#{path}/#{filename}",'w+'))
      : (SiSU_Screen::Ansi.new(
           '',
           "is the file or directory writable?, could not create #{filename}"
         ).warn)
    end
    def output_map(sitemap)
      path=@md.file.output_path.sitemaps.dir
      filename=@fn[:sitemap]
      touch_path=@md.file.output_path.sitemaps.dir
      touch_filename=@fn[:sitemap_touch]
      SiSU_Env::FileOp.new(@md).make_path(path)
      file=SiSU_Env::FileOp.new(@md).make_file(path,filename)
      file << sitemap
      if FileTest.file?("#{touch_path}/#{touch_filename}")
        FileUtils::rm("#{touch_path}/#{touch_filename}")
      end
    end
    def output_idx(sitemap)
      path=@env.path.output
      filename=@sitemap_idx_fn
      make_path(path)
      file=make_file(path,filename)
      file << sitemap
    end
    def sitemap_index
      sitemap_files=Dir.glob("#{@env.path.sitemaps}/sitemap_*.xml")
      sitemap_idx=[]
      sitemap_idx << <<WOK
<?xml version="1.0" encoding="UTF-8"?>
<sitemapindex xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
   xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemaps/0.9
   http://www.sitemaps.org/schemas/sitemaps/sitemap.xsd"
     xmlns="http://www.sitemaps.org/schemas/sitemapindex/0.9">
WOK
      sitemap_files.each do |s|
        f=s.gsub(/.+?\/sitemap_([^\/]+?)\.xml$/,'\1')
        @trans.char_enc.utf8(f) \
          if @sys.locale =~/utf-?8/i
sitemap_idx << <<WOK
  <sitemap>
    <loc>#{@env.path.url.remote}/#{f}/sitemap.xml</loc>
  </sitemap>
WOK
      end
      sitemap_idx << <<WOK
</sitemapindex>
WOK
      sitemap_idx.join
    end
    def sitemap
      if defined? @md.date.modified \
      and @md.date.modified=~/\d{4}-\d{2}-\d{2}/
        sitemap_date_modified
      else sitemap_no_date
      end
    end
    def sitemap_date_modified
<<WOK
<?xml version='1.0' encoding='UTF-8'?>
<urlset xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemaps/0.9
  http://www.sitemaps.org/schemas/sitemaps/sitemap.xsd"
  xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
#{@rdf.comment_xml}
  <url>
    <loc>#{@env.path.url.remote}/#{@fnb_utf8_xml}/#{@fn[:toc]}</loc>
    <lastmod>#{@md.date.modified}</lastmod>
    <changefreq>monthly</changefreq>
    <priority>0.7</priority>
  </url>
  <url>
    <loc>#{@env.path.url.remote}/#{@fnb_utf8_xml}/#{@fn[:doc]}</loc>
    <lastmod>#{@md.date.modified}</lastmod>
    <priority>0.5</priority>
  </url>
  <url>
    <loc>#{@env.path.url.remote}/#{@fnb_utf8_xml}/#{@fn[:manifest]}</loc>
    <lastmod>#{@md.date.modified}</lastmod>
    <priority>0.5</priority>
  </url>
</urlset>
WOK
    end
    def sitemap_no_date
<<WOK
<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
#{@rdf.comment_xml}
  <url>
    <loc>#{@env.path.url.remote}/#{@fnb_utf8_xml}/#{@fn[:toc]}</loc>
    <changefreq>monthly</changefreq>
    <priority>0.7</priority>
  </url>
  <url>
    <loc>#{@env.path.url.remote}/#{@fnb_utf8_xml}/#{@fn[:doc]}</loc>
    <priority>0.5</priority>
  </url>
  <url>
    <loc>#{@env.path.url.remote}/#{@fnb_utf8_xml}/#{@fn[:manifest]}</loc>
    <priority>0.5</priority>
  </url>
</urlset>
WOK
    end
  end
end
__END__
* sanitize xml, pass through filter to ensure is valid - done but needs testing
* remote placement of sitemaps --sitemaps -R (probably makes more sense than doing against -Y [filename/wildcard]) - done but needs testing
* gzip sitemaps - not before testing / after testing
* issue with master documnts, naming and mapping, check multilingual

<!-- Document processing information:
     * Generated by: SiSU 0.48.6 of 2006w45/6 (20061111)
     * Ruby version: ruby 1.8.5 (2006-08-25) [i486-linux]
     *
     * Last Generated on: Sat Nov 18 15:28:08 +0000 2006
     * SiSU http://www.jus.uio.no/sisu
-->
