/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.resourceloader;

import com.google.clearsilver.jsilver.exceptions.JSilverTemplateNotFoundException;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeResourceLoader
implements ResourceLoader {
    private final List<ResourceLoader> loaders = new ArrayList<ResourceLoader>();

    public CompositeResourceLoader(Iterable<ResourceLoader> loaders) {
        for (ResourceLoader loader : loaders) {
            this.add(loader);
        }
    }

    public CompositeResourceLoader(ResourceLoader ... loaders) {
        for (ResourceLoader loader : loaders) {
            this.add(loader);
        }
    }

    public void add(ResourceLoader loader) {
        this.loaders.add(loader);
    }

    @Override
    public Reader open(String name) throws IOException {
        for (ResourceLoader loader : this.loaders) {
            Reader reader = loader.open(name);
            if (reader == null) continue;
            return new ReaderTracer(reader, loader);
        }
        return null;
    }

    @Override
    public Reader openOrFail(String name) throws JSilverTemplateNotFoundException, IOException {
        Reader reader = this.open(name);
        if (reader == null) {
            throw new JSilverTemplateNotFoundException(name);
        }
        return reader;
    }

    @Override
    public void close(Reader reader) throws IOException {
        if (!(reader instanceof ReaderTracer)) {
            throw new IllegalArgumentException("I can't close a reader I didn't open.");
        }
        reader.close();
    }

    @Override
    public Object getKey(String filename) {
        return filename;
    }

    @Override
    public Object getResourceVersionId(String filename) {
        for (ResourceLoader loader : this.loaders) {
            Object currentKey = loader.getResourceVersionId(filename);
            if (currentKey == null) continue;
            return currentKey;
        }
        return null;
    }

    private static class ReaderTracer
    extends FilterReader {
        private final ResourceLoader originalLoader;

        public ReaderTracer(Reader in, ResourceLoader originalLoader) {
            super(in);
            this.originalLoader = originalLoader;
        }

        public void close() throws IOException {
            this.originalLoader.close(this.in);
        }
    }
}

