/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.output;

import com.google.clearsilver.jsilver.output.OutputBufferProvider;

public class ThreadLocalOutputBufferProvider
implements OutputBufferProvider {
    private final ThreadLocal<StringBuilder> pool;
    private final ThreadLocal<Boolean> available;

    public ThreadLocalOutputBufferProvider(final int bufferSize) {
        this.pool = new ThreadLocal<StringBuilder>(){

            @Override
            protected StringBuilder initialValue() {
                return new StringBuilder(bufferSize);
            }
        };
        this.available = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return true;
            }
        };
    }

    public Appendable get() {
        if (!this.available.get().booleanValue()) {
            throw new IllegalStateException("Thread buffer is not free.");
        }
        StringBuilder sb = this.pool.get();
        this.available.set(false);
        sb.setLength(0);
        return sb;
    }

    public void release(Appendable buffer) {
        if (buffer != this.pool.get()) {
            throw new IllegalArgumentException("Can't release buffer that does not correspond to this thread.");
        }
        this.available.set(true);
    }
}

