/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2;

import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.ResourceBundleTextProvider;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import com.opensymphony.xwork2.util.ValueStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class TextProviderSupport
implements ResourceBundleTextProvider {
    private Class clazz;
    private LocaleProvider localeProvider;
    private ResourceBundle bundle;

    public TextProviderSupport() {
    }

    public TextProviderSupport(Class clazz, LocaleProvider provider) {
        this.clazz = clazz;
        this.localeProvider = provider;
    }

    public TextProviderSupport(ResourceBundle bundle, LocaleProvider provider) {
        this.bundle = bundle;
        this.localeProvider = provider;
    }

    public void setBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    public void setLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    public String getText(String key) {
        return this.getText(key, key, Collections.EMPTY_LIST);
    }

    public String getText(String key, String defaultValue) {
        return this.getText(key, defaultValue, Collections.EMPTY_LIST);
    }

    public String getText(String key, String defaultValue, String arg) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(arg);
        return this.getText(key, defaultValue, args);
    }

    public String getText(String key, List args) {
        return this.getText(key, key, args);
    }

    public String getText(String key, String[] args) {
        return this.getText(key, key, args);
    }

    public String getText(String key, String defaultValue, List args) {
        Object[] argsArray;
        Object[] objectArray = argsArray = args != null && !((Object)args).equals(Collections.EMPTY_LIST) ? args.toArray() : null;
        if (this.clazz != null) {
            return LocalizedTextUtil.findText(this.clazz, key, this.getLocale(), defaultValue, argsArray);
        }
        return LocalizedTextUtil.findText(this.bundle, key, this.getLocale(), defaultValue, argsArray);
    }

    public String getText(String key, String defaultValue, String[] args) {
        if (this.clazz != null) {
            return LocalizedTextUtil.findText(this.clazz, key, this.getLocale(), defaultValue, (Object[])args);
        }
        return LocalizedTextUtil.findText(this.bundle, key, this.getLocale(), defaultValue, (Object[])args);
    }

    public String getText(String key, String defaultValue, List args, ValueStack stack) {
        Object[] argsArray = args != null ? args.toArray() : null;
        Locale locale = null;
        locale = stack == null ? this.getLocale() : (Locale)stack.getContext().get("com.opensymphony.xwork2.ActionContext.locale");
        if (locale == null) {
            locale = this.getLocale();
        }
        if (this.clazz != null) {
            return LocalizedTextUtil.findText(this.clazz, key, locale, defaultValue, argsArray, stack);
        }
        return LocalizedTextUtil.findText(this.bundle, key, locale, defaultValue, argsArray, stack);
    }

    public String getText(String key, String defaultValue, String[] args, ValueStack stack) {
        Locale locale = null;
        locale = stack == null ? this.getLocale() : (Locale)stack.getContext().get("com.opensymphony.xwork2.ActionContext.locale");
        if (locale == null) {
            locale = this.getLocale();
        }
        if (this.clazz != null) {
            return LocalizedTextUtil.findText(this.clazz, key, locale, defaultValue, (Object[])args, stack);
        }
        return LocalizedTextUtil.findText(this.bundle, key, locale, defaultValue, (Object[])args, stack);
    }

    public ResourceBundle getTexts(String aBundleName) {
        return LocalizedTextUtil.findResourceBundle(aBundleName, this.getLocale());
    }

    public ResourceBundle getTexts() {
        if (this.clazz != null) {
            return this.getTexts(this.clazz.getName());
        }
        return this.bundle;
    }

    private Locale getLocale() {
        return this.localeProvider.getLocale();
    }
}

