#include <string.h>
#include "messagebasictypes.h"
#include "messagecomplextypes.h"
#include "messagesinfotypes.h"


namespace Msg
{


void pushBackLoadavg(Message & message, const Loadavg & value)
{
  pushBackfloat32(message, value.load1);
  pushBackfloat32(message, value.load5);
  pushBackfloat32(message, value.load15);
}


void popFrontLoadavg(Message & message, Loadavg & returnValue)
{
  popFrontfloat32(message,returnValue.load1);
  popFrontfloat32(message,returnValue.load5);
  popFrontfloat32(message,returnValue.load15);
}


void pushBackMeminfo(Message & message, const Meminfo & value)
{
  pushBackfloat32(message, value.mem_total);
  pushBackfloat32(message, value.mem_used);
  pushBackfloat32(message, value.mem_free);

  pushBackfloat32(message, value.swap_total);
  pushBackfloat32(message, value.swap_used);
  pushBackfloat32(message, value.swap_free);
}


void popFrontMeminfo(Message & message, Meminfo & returnValue)
{
  popFrontfloat32(message,returnValue.mem_total);
  popFrontfloat32(message,returnValue.mem_used);
  popFrontfloat32(message,returnValue.mem_free);

  popFrontfloat32(message,returnValue.swap_total);
  popFrontfloat32(message,returnValue.swap_used);
  popFrontfloat32(message,returnValue.swap_free);
}


void pushBackCpustat(Message & message, const Cpustat & value)
{
  pushBackfloat32(message, value.userp);
  pushBackfloat32(message, value.nicep);
  pushBackfloat32(message, value.sysp);
  pushBackfloat32(message, value.idlep);
  pushBackfloat32(message, value.iowaitp);
  pushBackfloat32(message, value.irqp);
  pushBackfloat32(message, value.softirqp);
}


void popFrontCpustat(Message & message, Cpustat & returnValue)
{
  popFrontfloat32(message, returnValue.userp);
  popFrontfloat32(message, returnValue.nicep);
  popFrontfloat32(message, returnValue.sysp);
  popFrontfloat32(message, returnValue.idlep);
  popFrontfloat32(message, returnValue.iowaitp);
  popFrontfloat32(message, returnValue.irqp);
  popFrontfloat32(message, returnValue.softirqp);
}


void pushBackCpuinfo(Message & message, const Cpuinfo & value)
{
  pushBackint32(message, value.cpus);
  pushBackfloat32(message, value.speedmhz);
}


void popFrontCpuinfo(Message & message, Cpuinfo & returnValue)
{
  popFrontint32(message, returnValue.cpus);
  popFrontfloat32(message, returnValue.speedmhz);
}


void pushBackUptime(Message & message, const Uptime & value)
{
  pushBackint32(message, value.days);
  pushBackint32(message, value.seconds);
}


void popFrontUptime(Message & message, Uptime & returnValue)
{
  popFrontint32(message, returnValue.days);
  popFrontint32(message, returnValue.seconds);
}


void pushBackUsers(Message & message, const Users & value)
{
  pushBackint32(message, value.number);
}


void popFrontUsers(Message & message, Users & returnValue)
{
  popFrontint32(message, returnValue.number);
}


void pushBackProcinfo(Message & message, const Procinfo & value)
{
  std::string tmpString;

  pushBackint32(message, value.pid);
  tmpString=value.command;
  pushBackstring8(message, tmpString);
  pushBackint8(message, value.state);
  pushBackint32(message, value.priority);
  tmpString=value.username;
  pushBackstring8(message, tmpString);
  pushBackfloat32(message, value.cpupercent);
}


void popFrontProcinfo(Message & message, Procinfo & returnValue)
{
  std::string tmpString;

  popFrontint32(message, returnValue.pid);
  popFrontstring8(message, tmpString);
  strncpy(returnValue.command,tmpString.c_str(),COMMSIZE);
  popFrontint8(message, returnValue.state);
  popFrontint32(message, returnValue.priority);
  popFrontstring8(message, tmpString);
  strncpy(returnValue.username,tmpString.c_str(),USERNAMEMAX);
  popFrontfloat32(message, returnValue.cpupercent);
}


void pushBackUnameinfo(Message & message, const Unameinfo & value)
{
  pushBackstring8(message, value.sysname);
  pushBackstring8(message, value.nodename);
  pushBackstring8(message, value.release);
  pushBackstring8(message, value.version);
  pushBackstring8(message, value.machine);
}


void popFrontUnameinfo(Message & message, Unameinfo & returnValue)
{
  popFrontstring8(message, returnValue.sysname);
  popFrontstring8(message, returnValue.nodename);
  popFrontstring8(message, returnValue.release);
  popFrontstring8(message, returnValue.version);
  popFrontstring8(message, returnValue.machine);
}


void pushBackNetload(Message & message, const Netload & value)
{
  std::string tmpString;

  tmpString=value.iface;
  pushBackstring8(message, tmpString);

  pushBackfloat32(message, value.rxbytes);
  pushBackfloat32(message, value.txbytes);
  pushBackfloat32(message, value.rxpkt);
  pushBackfloat32(message, value.txpkt);
}


void popFrontNetload(Message & message, Netload & returnValue)
{
  std::string tmpString;

  popFrontstring8(message, tmpString);
  strncpy(returnValue.iface,tmpString.c_str(),IFACESIZE);

  popFrontfloat32(message, returnValue.rxbytes);
  popFrontfloat32(message, returnValue.txbytes);
  popFrontfloat32(message, returnValue.rxpkt);
  popFrontfloat32(message, returnValue.txpkt);
}


void pushBackDiskload(Message & message, const Diskload & value)
{
  pushBackfloat32(message, value.readkbytespersec);
  pushBackfloat32(message, value.writekbytespersec);
}


void popFrontDiskload(Message & message, Diskload & returnValue)
{
  popFrontfloat32(message,returnValue.readkbytespersec);
  popFrontfloat32(message,returnValue.writekbytespersec);
}



void pushBackWsinfo(Message & message, const Wsinfo & value)
{
  pushBackstring8(message, value.name);
  pushBackstring8(message, value.inetaddr);
  pushBackLoadavg(message, value.loadavg);
  pushBackMeminfo(message, value.meminfo);
  pushBackCpustat(message, value.cpustat);
  pushBackCpuinfo(message, value.cpuinfo);
  pushBackUptime(message, value.uptime);
  pushBackUsers(message, value.users);
  for (int i=0;i<PROCINFOMAX;i++)
  {
    pushBackProcinfo(message, value.procinfo[i]);
  }
  pushBackUnameinfo(message, value.unameinfo);
  pushBackNetload(message, value.netload);
  pushBackDiskload(message, value.diskload);
  pushBackstring8(message, value.marker);
}


void popFrontWsinfo(Message & message, Wsinfo & returnValue)
{
  popFrontstring8(message, returnValue.name);
  popFrontstring8(message, returnValue.inetaddr);
  popFrontLoadavg(message, returnValue.loadavg);
  popFrontMeminfo(message, returnValue.meminfo);
  popFrontCpustat(message, returnValue.cpustat);
  popFrontCpuinfo(message, returnValue.cpuinfo);
  popFrontUptime(message, returnValue.uptime);
  popFrontUsers(message, returnValue.users);
  for (int i=0;i<PROCINFOMAX;i++)
  {
    popFrontProcinfo(message, returnValue.procinfo[i]);
  }
  popFrontUnameinfo(message, returnValue.unameinfo);
  popFrontNetload(message, returnValue.netload);
  popFrontDiskload(message, returnValue.diskload);
  popFrontstring8(message, returnValue.marker);
}


}
