/*
 * __BEGIN_COPYRIGHT
 * SimpleDB API
 * 
 * Copyright (C) 2005 Eminence Technology Pty Ltd
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You can view the GNU Lesser General Public Licence at
 * http://www.gnu.org/licenses/lgpl.html or you can write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Eminence Technology Pty Ltd can be contacted by writing to
 * Eminence Technology, PO Box 118, Moorooka QLD 4105, Australia.
 * Alternatively, you may email opensource [at] eminence [dot] com [dot] au
 * __END_COPYRIGHT
 */

#include "SimpleDBFactory.h"

using namespace SimpleDB ;
SimpleDBFactory* SimpleDBFactory::_instance = 0 ;

SimpleDBFactory* SimpleDBFactory::Instance() 
{
  if (_instance == 0)
    _instance = new SimpleDBFactory () ;
  return _instance ;
}

std::auto_ptr<Database> SimpleDBFactory::getDBHandle(const std::string dsn)
{
  /* Simply Returns a Database handle ,
   * Memory control now belongs to the caller.
   */
  return std::auto_ptr<Database> (new Database(dsn));
}

void SimpleDBFactory::Kill ()
{
  if (_instance != 0) 
    delete _instance ;
  _instance = 0 ;
}
