
/****************************************************************************
**
** Copyright (C) 2011 Christian B. Huebschle & George M. Sheldrick
** All rights reserved.
** Contact: chuebsch@moliso.de
**
** This file is part of the ShelXle
**
** This file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file COPYING included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
**
****************************************************************************/
#ifndef FCVSFO_H
#define FCVSFO_H 1
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>
#include <string.h>
#include <QtGui>

typedef struct {
int h,k,l;
} Omit;

struct MCell {
  double a,b,c,al,be,ga;
  double phi,V,as,bs,cs,tau,cosga,cosal,cosbe,singa,tanga;
  double wave;
};

typedef struct {
  int h,k,l;
  double F;
  double phase;
  double sigma;
  double stl;
} Refls;

class gv:public QGraphicsScene{
Q_OBJECT
public:
gv( qreal x, qreal y, qreal width, qreal height, QObject * parent = 0 );
  QGraphicsRectItem *selEckt;
  QList<int> selected;
  QPointF selStart,selEnd;
//  gv();
signals:
  void meinstatus(int da);
  void listen();
protected:
  void mouseMoveEvent ( QGraphicsSceneMouseEvent  * mouseEvent );
  void mousePressEvent ( QGraphicsSceneMouseEvent * mouseEvent ); 
private:
};

class FcVsFo: public QDialog {
Q_OBJECT
public:
FcVsFo(QString filename, double a,double b, double c, double al, double be, double ga, double lambda);
~FcVsFo();
public slots:
	void delayMe();
	void readFCF();
        void omitref();
	void st(int da);
	void zoomin();
	void zoomout();
	void zoomoff();
	void zoomfit();
	void selektiert();
	void graphChange(int type);
signals:
	void weg(const QString &);
private:
	QString fileName;
	int listType;
	QGraphicsView *view;
	gv *scene;
	QList<Refls> Fc,Fo;
	Omit omits;
	double foMax,foMin,fcMax,fcMin;
	QLabel *state,*state2;
	QTextBrowser *brw;
	QTimer *timer;
	MCell cell;	
    QGraphicsItem *diagonale;
	QGraphicsTextItem *txt,*txt2;
};
#endif
