#!/usr/bin/env cwl-runner

# This CWL file was automatically generated using CTDConverter.
# Visit https://github.com/WorkflowConversion/CTDConverter for more information.

baseCommand: roi_feature_projection
class: CommandLineTool
cwlVersion: v1.0
doc: "Compute the projection of a ROI file to regions from a BED or GFF file.  The\
  \ result is a ROI file where each interval from the BED/GFF/GTF file that overlapped\
  \ with one input ROI file is a region of interest, with the coverage counts projected\
  \ to the new region of interest.\n\n\n\nFor more information, visit http://www.seqan.de"
inputs:
- default: 'false'
  doc: Set verbosity to a minimum.
  id: param_quiet
  inputBinding:
    prefix: -quiet
  label: Set verbosity to a minimum.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Enable verbose output.
  id: param_verbose
  inputBinding:
    prefix: -verbose
  label: Enable verbose output.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Enable very verbose output.
  id: param_very-verbose
  inputBinding:
    prefix: -very-verbose
  label: Enable very verbose output.
  type:
  - 'null'
  - string
- doc: ROI file to read.
  id: param_in-roi
  inputBinding:
    prefix: -in-roi
  label: ROI file to read.
  type: File
- doc: BED, GFF, or GTF file to read.
  id: param_in-features
  inputBinding:
    prefix: -in-features
  label: BED, GFF, or GTF file to read.
  type: File
- doc: Filename for out-roi output file
  id: param_out-roi_filename
  inputBinding:
    prefix: -out-roi
  label: Filename for out-roi output file
  type: string
- doc: Path to FASTA file with genome; optional.  When given, this is used for computing
    the overall region's C+G content.
  id: param_genome
  inputBinding:
    prefix: -genome
  label: Path to FASTA file with genome; optional.  When given, this is used for computing
    the overall region's C+G content.
  type:
  - 'null'
  - File
- default: projection
  doc: The mode in which to combine the ROI and BED/GFF file.  See section Combination
    Modes below for details.
  id: param_mode
  inputBinding:
    prefix: -mode
  label: The mode in which to combine the ROI and BED/GFF file.  See section Combination
    Modes below for details.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Enable strand-specific mode if set.
  id: param_strand-specific
  inputBinding:
    prefix: -strand-specific
  label: Enable strand-specific mode if set.
  type:
  - 'null'
  - string
- doc: The GFF/GTF record type (value of third column) to keep.  Keep all if not set
    or input file type is not GFF/GTF.
  id: param_gff-type
  inputBinding:
    prefix: -gff-type
  label: The GFF/GTF record type (value of third column) to keep.  Keep all if not
    set or input file type is not GFF/GTF.
  type:
  - 'null'
  - string
- doc: The GFF/GTF tag to use for grouping, e.g. "Parent", "transcript_id". No grouping
    if empty.  When using the grouping feature, the --mode is automatically set to
    projection.
  id: param_gff-group-by
  inputBinding:
    prefix: -gff-group-by
  label: The GFF/GTF tag to use for grouping, e.g. "Parent", "transcript_id". No grouping
    if empty.  When using the grouping feature, the --mode is automatically set to
    projection.
  type:
  - 'null'
  - string
label: Region Of Interest Projection.
outputs:
- doc: ROI file to write.
  id: param_out-roi
  label: ROI file to write.
  outputBinding:
    glob: $(inputs.param_out-roi_filename)
  type: File
